/**
 * TODO: This plugin needs cleanup and a rewrite.  (Use api 2.0 for everything? )
 */
#include <stdio.h>
#include <string.h>
#include <gtk/gtk.h>
#include <libxml/parser.h>
#include <libxml/tree.h>
#include <libmpd/debug_printf.h>
#include <gmpc/plugin.h>
#include <gmpc/gmpc_easy_download.h>
#include <gmpc/metadata.h>
#include <glib.h>
#include <glib/gstdio.h>
#include <config.h>

#define LASTFM_API_KEY "ec1cdd08d574e93fa6ef9ad861ae795a" 
#define LASTFM_API_ROOT "http://ws.audioscrobbler.com/2.0/"



static char *__lastfm_art_get_artist_similar(char *nartist);
/*
GMutex *last_fm_second_lock = NULL;
*/
gulong timeout_handler = 0;

static int lastfm_get_enabled()
{
	return cfg_get_single_value_as_int_with_default(config, "cover-lastfm", "enable", TRUE);
}
static void lastfm_set_enabled(int enabled)
{
	cfg_set_single_value_as_int(config, "cover-lastfm", "enable", enabled);
}

static void lastfm_init(void)
{
}
static void lastfm_destroy(void)
{
	if(timeout_handler)
		g_source_remove(timeout_handler);
	timeout_handler = 0;

	printf("destroyed last.fm\n");
}

static int lastfm_fetch_cover_priority(void){
	return cfg_get_single_value_as_int_with_default(config, "cover-lastfm", "priority", 80);
}
static void lastfm_fetch_cover_priority_set(int priority){
	cfg_set_single_value_as_int(config, "cover-lastfm", "priority", priority);
}

static xmlNodePtr get_first_node_by_name(xmlNodePtr xml, gchar *name) {
    if(name == NULL) return NULL;
	if(xml) {
		xmlNodePtr c = xml->xmlChildrenNode;
		for(;c;c=c->next) {
			if(c->name && xmlStrEqual(c->name, (xmlChar *) name))
				return c;
		}
	}
	return NULL;
}

static char *__lastfm_art_xml_get_image(char *data,int size, char *type)
{
	if(size  == 0)
		return NULL;
	/* Hack to check for xml file */
    if(data == NULL) return NULL;
	if(data[0] != '<')
		return NULL;
	gchar *url = NULL;
	xmlDocPtr doc = xmlParseMemory(data,size);
	if(doc)
	{
		xmlNodePtr root = xmlDocGetRootElement(doc);
        if(root)
        {
            /* loop through all albums */
            xmlNodePtr cur = get_first_node_by_name(root,type);
            if(cur)
            {
                int type = 0;
                xmlNodePtr cur2 = cur->xmlChildrenNode;
                for(;cur2;cur2 = cur2->next)
                {
                    if(cur2->name)
                    {
                        if (xmlStrEqual(cur2->name, (xmlChar *)"image"))
                        {

                            xmlChar *temp = xmlGetProp(cur2, (xmlChar *)"size");
                            if(temp)
                            {
                                /**
                                 * We want large image, but if that is not available, get the medium one 
                                 */
                                if(xmlStrEqual(temp, (xmlChar *)"medium") && type < 2)
                                {
                                    xmlChar *xurl = xmlNodeGetContent(cur2);
                                    url = g_strdup((char *)xurl);
                                    xmlFree(xurl);
                                    type = 2;
                                }else if(xmlStrEqual(temp, (xmlChar *)"large"))
                                {
                                    xmlChar *xurl = xmlNodeGetContent(cur2);
                                    if(url) g_free(url);
                                    url = g_strdup((char *)xurl);
                                    xmlFree(xurl);
                                    type = 3;
                                }
                                xmlFree(temp);
                            }
                        }
                    }
                }
            }
        }
		xmlFreeDoc(doc);
		
	}
	return url;
}

static int __lastfm_art_get_artist_image(mpd_Song *song,char *nartist, char **path)
{

	gmpc_easy_download_struct data= {NULL, 0,-1,NULL, NULL};
	int found = META_DATA_UNAVAILABLE;
	char furl[1024];


	snprintf(furl,1024,LASTFM_API_ROOT"?method=artist.getinfo&artist=%s&api_key=%s", nartist,LASTFM_API_KEY);

	if(gmpc_easy_download(furl, &data))
	{
		char *url = __lastfm_art_xml_get_image(data.data, data.size, "artist");
		gmpc_easy_download_clean(&data);
		if(url && url[0] != '\0' && strstr(url, "noartist_") == NULL) 
		{
			gmpc_easy_download(url, &data);
			if(data.size){
				FILE *fp = NULL;
				char *imgpath = NULL;
				imgpath = gmpc_get_metadata_filename(META_ARTIST_ART, song, "jpg");
				fp = fopen(imgpath, "wb");
				if(fp)
				{
                    size_t size;
    			    size = fwrite(data.data, sizeof(char), data.size,fp);
                    if(size != data.size){
                        debug_printf(DEBUG_ERROR, "Something went wrong writing image to file");
                    }
					fclose(fp);
				}
				*path = imgpath;
				gmpc_easy_download_clean(&data);
				found = META_DATA_AVAILABLE;
                debug_printf(DEBUG_INFO,"Found cover art, returning\n");
			}
		}
		if(url)g_free(url);

	}

	return found;
}
/*
 * Get 20 artists
 */
static char *__lastfm_art_xml_get_artist_similar(char *data,int size)
{
	char *retv = NULL;
	GString *string;
	if(size  == 0)
		return NULL;
    if(data == NULL) return NULL;
	if(data[0] != '<')
		return NULL;
	string = g_string_new("");
	xmlDocPtr doc = xmlParseMemory(data,size);
	if(doc)
	{
		xmlNodePtr root = xmlDocGetRootElement(doc);
		xmlNodePtr cur = get_first_node_by_name(root, "similarartists");
        if(cur)
        {
            xmlNodePtr cur2 = cur->xmlChildrenNode;
            for(;cur2;cur2=cur2->next)
            {
                if(xmlStrEqual(cur2->name, (xmlChar *)"artist"))
                {
                    xmlNodePtr cur3 = cur2->xmlChildrenNode;
                    for(;cur3;cur3=cur3->next)
                    {
                        if(xmlStrEqual(cur3->name, (xmlChar *)"name"))
                        {
                            xmlChar *temp = xmlNodeGetContent(cur3);
                            g_string_append_printf(string, "%s\n", temp);
                            xmlFree(temp);
                        }
                    }
                }
            }
        }
		xmlFreeDoc(doc);
		
	}
	if(string->len>0)
		retv = string->str;
	g_string_free(string, FALSE);
	return retv;
}

/*
 * Get's similar list 
 */
gchar *__lastfm_art_get_artist_similar(char *nartist)
{

	gmpc_easy_download_struct data= {NULL, 0,-1,NULL, NULL};
	char furl[1024];
	char *artist = g_uri_escape_string(nartist, NULL, TRUE);
	snprintf(furl,1024,LASTFM_API_ROOT"?method=artist.getsimilar&artist=%s&api_key=%s", artist,LASTFM_API_KEY);
	debug_printf(DEBUG_INFO, "furl: %s\n", furl);
	g_free(artist);
	if(gmpc_easy_download(furl, &data))
	{
		char *result = __lastfm_art_xml_get_artist_similar(data.data,data.size);
		gmpc_easy_download_clean(&data);
		return result;
	}
	return NULL;
}
/*
 * Get 20Songs 
 */
static char *__lastfm_art_xml_get_song_similar(char *data,int size)
{
	char *retv = NULL;
	GString *string;
	if(size  == 0)
		return NULL;
    if(data == NULL) return NULL;
    if(data[0] != '<')
		return NULL;
	string = g_string_new("");
	xmlDocPtr doc = xmlParseMemory(data,size);
	if(doc)
	{
		xmlNodePtr root = xmlDocGetRootElement(doc);
		xmlNodePtr cur = get_first_node_by_name(root, "similartracks");
        if(cur)
        {
            xmlNodePtr cur2 = cur->xmlChildrenNode;
            for(;cur2;cur2=cur2->next)
            {
                if(xmlStrEqual(cur2->name, (xmlChar *)"track"))
                {
                    xmlNodePtr cur3 = cur2->xmlChildrenNode;
                    xmlChar *artist = NULL;
                    xmlChar *title = NULL;
                    for(;cur3;cur3=cur3->next)
                    {
                        if(xmlStrEqual(cur3->name, (xmlChar *)"name"))
                        {
                            xmlChar *temp = xmlNodeGetContent(cur3);
                            title = temp; 
                        }
                        else if (xmlStrEqual(cur3->name, (xmlChar *)"artist")) 
                        {
                            xmlNodePtr cur4 = get_first_node_by_name(cur3, "name");
                            if(cur4){
                                xmlChar *temp = xmlNodeGetContent(cur4);
                                artist = temp; 
                            }
                        }
                    }
                    if(artist && title) {

                        g_string_append_printf(string, "%s::%s\n", artist, title);
                    }
                    if(artist) xmlFree(artist);
                    if(title) xmlFree(title);
                }
            }
        }
		xmlFreeDoc(doc);
		
	}
	if(string->len>0)
		retv = string->str;
	g_string_free(string, FALSE);
	return retv;
}

/*
 * Get's similar list 
 */
static gchar *__lastfm_art_get_song_similar(char *nartist, char *ntitle)
{

	gmpc_easy_download_struct data= {NULL, 0,-1,NULL, NULL};
	char furl[1024];
	char *artist = g_uri_escape_string(nartist, NULL, TRUE);
    char *title =  g_uri_escape_string(ntitle, NULL, TRUE);
	snprintf(furl,1024,LASTFM_API_ROOT"?method=track.getsimilar&artist=%s&track=%s&api_key=%s", artist,title,LASTFM_API_KEY);
	debug_printf(DEBUG_INFO, "furl: %s\n", furl);
	g_free(artist);
    g_free(title);
	if(gmpc_easy_download(furl, &data))
	{
		char *result = __lastfm_art_xml_get_song_similar(data.data,data.size);
		gmpc_easy_download_clean(&data);
		return result;
	}
	return NULL;
}



/** 
 * Get album image
 */
static int __lastfm_art_get_album_image(mpd_Song *song,char *artist, char *album, char **path)
{

	gmpc_easy_download_struct data= {NULL, 0,-1,NULL, NULL};
	int found = META_DATA_UNAVAILABLE;
	char furl[1024];
	snprintf(furl,1024,LASTFM_API_ROOT"?method=album.getinfo&artist=%s&album=%s&api_key=%s", artist,album,LASTFM_API_KEY);
	debug_printf(DEBUG_INFO, "furl: %s\n", furl);
	if(gmpc_easy_download(furl, &data))
	{
		char *url = __lastfm_art_xml_get_image(data.data, data.size,"album");
		gmpc_easy_download_clean(&data);
		if(url && url[0] != '\0' &&  strstr(url, "noartist_") == NULL && strstr(url, "noimage") == NULL) 
		{
			gmpc_easy_download(url, &data);
			/* Don't use images under 900 bytes */
			if(data.size > 900){
				FILE *fp = NULL;
				char *imgpath = NULL;
				imgpath = gmpc_get_metadata_filename(META_ALBUM_ART, song, "jpg");
				fp = fopen(imgpath, "wb");
				if(fp)
				{
					size_t size = fwrite(data.data, sizeof(char), data.size,fp);
                    if(size != data.size)
                    {
                        debug_printf(DEBUG_ERROR, "Something went wrong writing image to file");
                    }
					fclose(fp);
				}
				*path = imgpath;
				gmpc_easy_download_clean(&data);
				found = META_DATA_AVAILABLE;
				debug_printf(DEBUG_INFO, "Found album art for: %s %s\n", artist, album);
			}
		}
		if(url)g_free(url);
	}
	return found;
}
/**
 * Get artist info 
 */


static char * __lastfm_art_xml_get_artist_bio(char *data , int size )
{
	xmlDocPtr doc = xmlParseMemory(data,size);
	char *info=NULL;
	if(doc)
	{
		xmlNodePtr root = xmlDocGetRootElement(doc);
		xmlNodePtr bio = get_first_node_by_name(get_first_node_by_name(get_first_node_by_name(root,"artist"),"bio"),"content");
		if(bio)
		{
			xmlChar *temp = xmlNodeGetContent(bio);
			info = g_strdup((char *)temp);
			xmlFree(temp);
		}
	}
	xmlFreeDoc(doc);
	
	return info;
}
static gchar *__lastfm_art_get_artist_txt(mpd_Song *song)
{

	gmpc_easy_download_struct data= {NULL, 0,-1,NULL, NULL};
	char furl[1024];
	char *artist = g_uri_escape_string(song->artist, NULL, TRUE);
	/* Create the uri */
	snprintf(furl,1024, LASTFM_API_ROOT"?method=artist.getinfo&artist=%s&api_key=%s", artist,LASTFM_API_KEY);
	printf("uri: %s\n", furl);
	/* free artist name */
	g_free(artist);
	/* Download */
	if(gmpc_easy_download(furl, &data))
	{
		gchar *imgpath = NULL;
		/* Parse the data and try to get bio. */
		gchar *result = __lastfm_art_xml_get_artist_bio(data.data,data.size);
		/* Cleanup download struct */
		gmpc_easy_download_clean(&data);
		/* If there is a result store it. */
		if(result)
		{
			FILE *fp = NULL;
            imgpath = gmpc_get_metadata_filename(META_ARTIST_TXT, song, "jpg");
			fp = fopen(imgpath, "w");
			if(fp)
			{
				int j=0,depth=0;;
				for(j=0; j < strlen(result);j++)
				{
					if(result[j] == '<') depth++;
					else if(result[j] == '>' && depth) depth--;
					else if(depth == 0)
					{
						/* Quick and dirty html unescape*/
						if(strncasecmp(&result[j], "&lt;", 4) == 0){
							fputc('<', fp);
							j+=3;
						}else if (strncasecmp(&result[j], "&gt;", 4) == 0){
							fputc('>', fp);
							j+=3;
						}else if (strncasecmp(&result[j], "&quot;", 6) == 0){
							fputc('"', fp);
							j+=5;
						}else if (strncasecmp(&result[j], "&amp;", 5) == 0){
							fputc('&', fp);
							j+=4;
						}
						else
							fputc(result[j],fp);
					}
				}
				fclose(fp);
			}
			/* If we failed to open the file, return NULL */
			else 
			{
				g_free(imgpath);
				imgpath = NULL;
			}
			g_free(result);
		}
		return imgpath;
	}
	return NULL;
}

/** other */
static int lastfm_fetch_cover_album_art(mpd_Song *song, char **path)
{
	int retval;
	char *artist = g_uri_escape_string(song->artist, NULL, TRUE);
	char *album = g_uri_escape_string(song->album, NULL, TRUE);
	debug_printf(DEBUG_INFO, "Trying to fetch: %s:%s\n", artist, album);
	retval = __lastfm_art_get_album_image(song,artist,album, path);
	g_free(artist);
	g_free(album);
	return retval;
}

static int lastfm_fetch_cover_art(mpd_Song *song, char **path)
{
	int retval;
	char *artist = g_uri_escape_string(song->artist, NULL, TRUE);
	retval = __lastfm_art_get_artist_image(song,artist,path);
	g_free(artist);
	return retval;
}

static int lastfm_fetch_get_image(mpd_Song *song,MetaDataType type, char **path)
{
	int result = 0;
	if(song->artist == NULL || lastfm_get_enabled() == FALSE)
	{
		return META_DATA_UNAVAILABLE;
	}

	if(type == META_ARTIST_ART)
	{
		/** So we don't do to much queries a second */
		/* this is nicer then waiting one second, because now the result is directly available, only a new query < 1 second is delayed
		 */
		result = lastfm_fetch_cover_art(song, path);
		return result;
	}
	else if (type == META_ALBUM_ART && cfg_get_single_value_as_int_with_default(config, "cover-lastfm", "fetch-album", TRUE))
	{
		result = lastfm_fetch_cover_album_art(song, path);
		return result;
	}
	else if (type == META_ARTIST_SIMILAR)
	{
		*path = __lastfm_art_get_artist_similar(song->artist);
		if(*path)
		{
			return META_DATA_AVAILABLE;	
		}
		if(*path) g_free(*path);
	}
	else if (type == META_SONG_SIMILAR)
	{
        printf("Song sim\n");
        if(song->artist && song->title)
        {
            printf("fetching\n");
            *path = __lastfm_art_get_song_similar(song->artist,song->title);
            if(*path)
            {
                return META_DATA_AVAILABLE;	
            }
            if(*path) g_free(*path);
        }
	}
	/* Fetch artist info */
	else if (type == META_ARTIST_TXT)
	{
		/* Wait for the max 1x a second lock. */
		*path = __lastfm_art_get_artist_txt(song);
		/* If there is a path, return it */
		if(*path)
		{
			return META_DATA_AVAILABLE;	
		}
	}
	return META_DATA_UNAVAILABLE; 
}	

gmpcMetaDataPlugin lf_cover = {
	.get_priority   = lastfm_fetch_cover_priority,
    .set_priority   = lastfm_fetch_cover_priority_set,
	.get_image      = lastfm_fetch_get_image
};

int plugin_api_version = PLUGIN_API_VERSION;

gmpcPlugin plugin = {
	.name           = "Last FM Artist and Album Image Fetcher",
	.version        = {PLUGIN_MAJOR_VERSION,PLUGIN_MINOR_VERSION,PLUGIN_MICRO_VERSION},
	.plugin_type    = GMPC_PLUGIN_META_DATA,
	.init           = lastfm_init,
	.destroy        = lastfm_destroy,
	.metadata       = &lf_cover,
	.get_enabled    = lastfm_get_enabled,
	.set_enabled    = lastfm_set_enabled
};
