/* $Id: log.c,v 1.5 1999/12/13 08:46:56 xfmail Exp $ */

#include <config.h>
#include <fmail.h>
#include <umail.h>
#include <choose_folder.h>

#define MAX_LOG 256

static FD_Log *log_obj = NULL;
static int ready = 0;
static int log_lines = 0;
static FILE *lfd = NULL;

extern cfgfile Config;
#include <cfgfile.h>

void xfm_log_close_fd() {
    if(lfd)
        fclose(lfd);
    lfd = NULL;
}

void xfm_log_reopen_fd() {
    xfm_log_close_fd();
    if((lfd = fopen(Config.getCString("logfile", ""), "a")) ==
       NULL) {
        display_msg(MSG_WARN, "log", "Can not open\n%s",
                    Config.getCString("logfile", ""));
        fl_set_button(log_obj->Log_Tofile, 0);
        return;
    }
    fl_set_button(log_obj->Log_Tofile, 1);
}

void Log_Win_Call(FL_OBJECT * obj, long param) {
}

void Log_Close_Call(FL_OBJECT * obj, long param) {
    char geom[16];

    if(ready) {
        sprintf(geom, "%d %d", log_obj->Log->w, log_obj->Log->h);
        Config.set("loggeom", geom);
        fl_hide_form(log_obj->Log);
    }
    ready = 0;
    fl_set_menu_item_mode(menu_misc, 8, FL_PUP_BOX);
}

void Log_Clear_Call(FL_OBJECT * obj, long param) {
    fl_clear_browser(log_obj->Log_Win);
    log_lines = 0;
    if(lfd) {
        if(fflush(lfd) != 0)
            xfm_log_reopen_fd();
    }
}

void Log_Tofile_Call(FL_OBJECT * obj, long param) {
    char *lfname;
    time_t ltime;

    ltime = time(NULL);

    if(fl_get_button(obj)) {
        if(lfd)
            fclose(lfd);
        lfd = NULL;
        fl_set_fselector_title("Choose log file name");
        if(!
           (lfname =
            (char *) fl_show_file_selector("Log to", "", "",
                                           "xflog.txt"))) {
            fl_set_button(obj, 0);
            return;
        }

        if((lfd = fopen(lfname, "a")) == NULL) {
            display_msg(MSG_WARN, "log", "Can not open\n%s", lfname);
            fl_set_button(obj, 0);
            return;
        }
        Config.set("logfile", lfname);
        fprintf(lfd, "--- XFMail log started: %s", ctime(&ltime));
    } else {
        if(lfd) {
            fprintf(lfd, "--- XFMail log finished: %s", ctime(&ltime));
            fclose(lfd);
        }
        Config.remove("logfile");
        lfd = NULL;
    }
}

void xfm_log_str(char *str) {
    if(!log_obj)
        return;

    if(!str)
        return;

    if((strlen(str) < 1) || (strlen(str) > 200))
        return;

    if(log_lines > MAX_LOG) {
        fl_clear_browser(log_obj->Log_Win);
        log_lines = 0;
        if(lfd) {
            if(fflush(lfd) != 0)
                xfm_log_reopen_fd();
        }
    }

    fl_addto_browser(log_obj->Log_Win, str);

    if(lfd) {
        if(fputs(str, lfd) != 0)
            xfm_log_reopen_fd();
        if(lfd)
            fputc('\n', lfd);
    }
    log_lines++;
    return;
}

int xfm_log_close(FL_FORM * form, void *data) {
    log_win();
    return FL_IGNORE;
}

void xfm_log_init() {
    log_obj = create_form_Log();
    fl_set_form_atclose(log_obj->Log, xfm_log_close, NULL);
    fl_set_form_minsize(log_obj->Log, 410, 160);
    if(Config.exist("logfile"))
        xfm_log_reopen_fd();
    else
        fl_set_button(log_obj->Log_Tofile, 0);
}

void log_win() {
    int w, h;
    char geom[16];

    if(ready) {
        sprintf(geom, "%d %d", log_obj->Log->w, log_obj->Log->h);
        Config.set("loggeom", geom);
        fl_hide_form(log_obj->Log);
        ready = 0;
        fl_set_menu_item_mode(menu_misc, 8, FL_PUP_BOX);

        return;
    }

    ready = 1;
    fl_set_menu_item_mode(menu_misc, 8, FL_PUP_CHECK);

    Config.setFlags("loggeom", CF_NOTCHANGED);
    w = 410;
    h = 160;
    sscanf(Config.getCString("loggeom", ""), "%d %d", &w, &h);
    if(log_obj == NULL) {
        log_obj = create_form_Log();
        fl_set_form_atclose(log_obj->Log, xfm_log_close, NULL);
    }

    fl_set_form_minsize(log_obj->Log, 410, 160);
    fl_set_form_size(log_obj->Log, w, h);
    fl_show_form(log_obj->Log, FL_PLACE_FREE_CENTER, FL_TRANSIENT,
                 "Log window");

    return;
}
