#!/bin/sh

# self-extracting setup builder
# version 1.0
# Wim Kerkhoff
# November 18, 1999
# wim@netmaster.ca

# TODO: add options to create debs & rpms, etc
# ie, xfmail-1.4.4.sh --deb to generate a debian package

# this is little shell script builds a self-extracting executable for xfmail
# run it from the xfmail/ source directory
# modify variables below as necessary.
# it should leave a $NAME-$VERSION.sh in $TEMPDIR

#################
# NOTE: by default this script will run 'make clean' on the source tree you specified. You may not want that to happen... then comment the 'make clean' line out below.
#################

# program version... up with every release
VERSION=1.4.6

# name of the program... xfmail or archimedes or this or that or ying or yang or foo or bar
# this is also the name of the directory your program is in
NAME=xfmail

# a name for the self-extracting exe...
EXE=$NAME-$VERSION.sh

# your local source directory
INPUTDIR=/home/wim/dev/cvs/

# temporary directory used when creating the self-extracting file..
TEMPDIR=/tmp/$NAME.builddir

TAR=tar
GUNZIP=gunzip

rm -rf $TEMPDIR > /dev/null
mkdir $TEMPDIR
cd $INPUTDIR
cd ..
echo "$TAR cvvf $TEMPDIR/$NAME-$VERSION.tar $NAME"
cd $INPUTDIR
cd $NAME
make clean
cd ..
$TAR cvvf $TEMPDIR/$NAME-$VERSION.tar $NAME
gzip $TEMPDIR/$NAME-$VERSION.tar

echo "#!/bin/bash" > $TEMPDIR/$EXE
echo >> $TEMPDIR/$EXE
echo "cat > $NAME-$VERSION.uuencoded <<'REAL_EOF'" >> $TEMPDIR/$EXE
uuencode $TEMPDIR/$NAME-$VERSION.tar.gz $NAME-$VERSION.tar.gz >>$TEMPDIR/$EXE
echo "REAL_EOF" >> $TEMPDIR/$EXE
echo "uudecode $NAME-$VERSION.uuencoded" >> $TEMPDIR/$EXE
echo "rm -rf $NAME-$VERSION.uuencod*" >> $TEMPDIR/$EXE
echo "gunzip $NAME-$VERSION.tar.gz" >> $TEMPDIR/$EXE
echo "rm -rf $NAME-$VERSION.tar.gz" >> $TEMPDIR/$EXE
echo "tar -xvf $NAME-$VERSION.tar" >> $TEMPDIR/$EXE 
echo "rm -rf $NAME-$VERSION.tar" >> $TEMPDIR/$EXE
echo "cd $NAME && ./configure && make && make install" >> $TEMPDIR/$EXE

# set the permissions on the file so it can be executed...
chmod +x $TEMPDIR/$EXE

# clean up the tarball we made...
rm -rf $TEMPDIR/$NAME-$VERSION.tar.gz
