//
//
// C++ Implementation: dubplaylist.cpp
//
// Description: 
//
//
// Author: Eray Ozkural (exa) <erayo@cs.bilkent.edu.tr>, (C) 2001
//
// Copyright: See COPYING file that comes with this distribution
//
//

//#include dubplaylist.cpp

#include <kmessagebox.h>
#include <kdebug.h>
#include <noatun/playlist.h>

#include "dub.h"

#include "dubplaylist.h"

/** Construct playlist object */
DubPlaylist::DubPlaylist()
 : Playlist(0, "Dub Playlist")
 , dub(0)
 , visible(false)
{
  kdDebug() << "cons DUB playlist" << endl;
}

DubPlaylist::~DubPlaylist(){
  kdDebug() << "destruct DUB playlist " << endl;
  // destroy app
  delete dub;
}

void DubPlaylist::reset() {
  kdDebug() << "reset" << endl;
}

void DubPlaylist::clear() {
  kdDebug() << "reset" << endl;
}

void DubPlaylist::addFile(const KURL&, bool play) {
  KMessageBox::information(0, "Adding files not supported yet, see configuration");
}

PlaylistItem DubPlaylist::next() {
  kdDebug() << "dub: next" << endl;
  dub->selectNextFile();
  updateCurrent();
  return currentItem;
}

PlaylistItem DubPlaylist::current() {
  if (!currentItem.isNull())
    kdDebug() << "current item:" << currentItem.data()->url().prettyURL() << endl;
  return currentItem;
}

PlaylistItem DubPlaylist::previous() {
  kdDebug() << "previous" << endl;
  dub->selectPreviousFile();
  updateCurrent();
  return currentItem;
}

PlaylistItem DubPlaylist::getFirst() const {
  kdDebug() << "getFirst" << endl;
  return 0;
  const KFileItem* first = dub->queryFirstFile();
  if (first) {
    DubPlaylistItem* firstData = new DubPlaylistItem(*first);
    return PlaylistItem(firstData);
  }
  else
    return 0;
}

PlaylistItem DubPlaylist::getAfter(const PlaylistItem &item) const {
  kdDebug() << "getAfter" << endl;
  return 0;
}

bool DubPlaylist::listVisible() const {
  kdDebug() << "listVisible" << endl;
  return visible;
}

void DubPlaylist::init() {
  kdDebug() << "init" << endl;
  dub = new DubApp(0, this);
  kdDebug() << "init: test playlist() " << endl;
  playlist();
//  rootItem = DubPlaylistItem(dub->queryRoot());
//  rootItem = DubPlaylistItem(&root);
}

void DubPlaylist::showList() {
  kdDebug() << "showList" << endl;
  visible = true;
  Q_ASSERT(dub);
  dub->show();
}

void DubPlaylist::hideList() {
  kdDebug() << "hideList" << endl;
  visible = false;
  Q_ASSERT(dub);
  dub->hide();
}


//void DubPlaylist::remove(const PlaylistItem&) {
//  KMessageBox::information(0, "Removing files not supported yet, see configuration");
//}

//void DubPlaylist::sort() {
//  kdDebug() << "sort" << endl;
//}

Playlist* DubPlaylist::playlist() {
  kdDebug() << "playlist pointer " << this << endl;
  return static_cast<Playlist*>(this);
}

void DubPlaylist::setCurrent(const KFileItem* file, bool play) {
  Q_ASSERT(file);
  currentItem = new DubPlaylistItem(*file);
  if (play)
    emit playCurrent();
}

void DubPlaylist::setCurrent(const PlaylistItem &play)
{
  currentItem=play;
  emit playCurrent();
}

/** No descriptions */
void DubPlaylist::updateCurrent() {
  KFileItem* active = dub->getActiveFile();
  if ( active ) {
    currentItem = new DubPlaylistItem(*active);
    emit playCurrent();
  }
}
