/***************************************************************************
                          kountdown.h  -  the screensaver
                             -------------------
    begin                : Sun Feb 10 09:52:20 CET 2002
    copyright            : (C) 2002 by Erik Johansson
    email                : erre@telia.com
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef KOUNTDOWN_H
#define KOUNTDOWN_H

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include <kscreensaver.h>

class QColor;
class QFont;
class QString;
class QPixmap;
class QRect;
class QTimer;

class KDTimer;
struct STimeLeft;

/**
* Kountdown is the screensaver.
*/
class Kountdown : public KScreenSaver
{
  Q_OBJECT 
  public:
		Kountdown( WId drawable );
		virtual ~Kountdown();

	public slots:
		void readSettings(int);
		
	private slots:
 		void slotRepaint() { (this->*repaint)(); }
  		void slotRepaintNone();
		void slotRepaintLoop();
		void slotRepaintPopup();

		void slotGetText();

	private:
		void readGlobalSettings();
		void kountdown();
     QFont randomFont();
     QColor randomColor();

		// Settings, set after current setting (start, half, finish)
		QColor backCol, fontCol;
		QString text;
		QFont font;				
		QString textDisplay, oldTimeString, targetDate, targetTime;
  		int textEffect;

		KDTimer *timer;				// The timer that counts down
		QTimer *repaintTimer;
		QPixmap *qpixmap;  	// Paint in this, bitBlt it to the screen
		int step, speed;
  		int popupTime;
		QRect rect, temp;
		const STimeLeft *tiden;
  		void (Kountdown::*repaint) ();
    	void (Kountdown::*listRepaint[3]) ();
};

#endif
