#!/usr/local/bin/perl
# upgrade.cgi
# Upgrade webmin if possible

require './webmin-lib.pl';
&ReadParseMime();

if ($in{'source'} == 0) {
	# from local file
	&error_setup(&text('upgrade_err1', $in{'file'}));
	$file = $in{'file'};
	if (!(-r $file)) { &error($text{'upgrade_efile'}); }
	}
elsif ($in{'source'} == 1) {
	# from uploaded file
	&error_setup($text{'upgrade_err2'});
	$file = &tempname();
	$need_unlink = 1;
	if ($no_upload) {
                &error($text{'upgrade_ebrowser'});
                }
	open(MOD, "> $file");
	print MOD $in{'upload'};
	close(MOD);
	}
else {
	# find latest version at www.webmin.com by looking at index page
	&error_setup(&text('upgrade_err3', $in{'url'}));
	$file = &tempname();
	&http_download('www.webmin.com', 80, '/webmin/', $file);
	open(FILE, $file);
	while(<FILE>) {
		if (/webmin-([0-9\.]+)\.tar\.gz/) {
			$version = $1;
			last;
			}
		}
	close(FILE);
	unlink($file);
	if ($version <= &get_webmin_version()) {
		&error(&text('upgrade_eversion', $version));
		}
	&http_download('www.webmin.com', 80,
		       "/webmin/download/webmin-$version.tar.gz", $file);
	$need_unlink = 1;
	}

# gunzip the tarfile if needed
open(FILE, $file);
read(FILE, $two, 2);
close(FILE);
if ($two eq "\037\213") {
	if (!&has_command("gunzip")) {
		unlink($file) if ($need_unlink);
		&error($text{'upgrade_egunzip'});
		}
	$newfile = &tempname();
	system("gunzip -c $file >$newfile 2>/dev/null");
	unlink($file) if ($need_unlink);
	$need_unlink = 1;
	$file = $newfile;
	}

# Check if it is a webmin tarfile
open(TAR, "tar tf $file 2>&1 |");
while(<TAR>) {
	if (/^webmin-([0-9\.]+)\//) {
		$version = $1;
		}
	}
close(TAR);
if (!$version) {
	unlink($file) if ($need_unlink);
	&error($text{'upgrade_etar'});
	}
if ($version <= &get_webmin_version()) {
	&error(&text('upgrade_eversion', $version));
	}

# Extract it next to the current directory and run setup.sh
$| = 1;
&header($text{'upgrade_title'}, "");
print "<hr>\n";
system("cd ../.. ; tar xf $file >/dev/null 2>&1");
unlink($file) if ($need_unlink);
$ENV{'config_dir'} = $config_directory;
$ENV{'webmin_upgrade'} = 1;
$ENV{'autothird'} = 1;
print $text{'upgrade_setup'},"<p>\n";
system("(cd ../../webmin-$version ; ./setup.sh) >/dev/null 2>/dev/null </dev/null &");

print "<hr>\n";
&footer("", $text{'index_return'});

