# syslog-lib.pl
# Functions for the syslog module

do '../web-lib.pl';
&init_config();

# get_config()
sub get_config
{
local $lnum = 0;
local ($line, $cont, @rv);
local $tag = { 'tag' => '*',
	       'index' => 0,
	       'line' => 0 };
push(@rv, $tag);
open(CONF, $config{'syslog_conf'});
while($line = <CONF>) {
	local $slnum = $lnum;
	$line =~ s/\r|\n//g;
	if ($line =~ /\\$/) {
		# continuation .. get the next lines
		$line =~ s/\\$//;
		while($cont = <CONF>) {
			$lnum++;
			$cont =~ s/^[#\s]+//;
			$cont =~ s/\r|\n//g;
			$line .= $cont;
			last if ($line !~ s/\\$//);
			}
		}
	if ($line =~ /^(#*)\s*([^#\s]+\.\S+)\s+(\S+)$/ ||
	    $line =~ /^(#*)\s*([^#\s]+\.\S+)\s+(\|.*)$/) {
		local $act = $3;
		local $log = { 'active' => !$1,
			       'sel' => [ split(/;/, $2) ],
			       'line' => $slnum,
			       'eline' => $lnum };
		if ($act =~ /^\-(\/\S+)$/) {
			$log->{'file'} = $1;
			$log->{'sync'} = 1;
			}
		elsif ($act =~ /^\|(.*)$/) {
			$log->{'pipe'} = $1;
			}
		elsif ($act =~ /^(\/\S+)$/) {
			$log->{'file'} = $1;
			}
		elsif ($act =~ /^\@(\S+)$/) {
			$log->{'host'} = $1;
			}
		elsif ($act eq '*') {
			$log->{'all'} = 1;
			}
		else {
			$log->{'users'} = [ split(/,/, $act) ];
			}
		$log->{'index'} = scalar(@rv);
		$log->{'section'} = $tag;
		$tag->{'eline'} = $lnum;
		push(@rv, $log);
		}
	elsif ($line =~ /^(#?)!(\S+)$/) {
		push(@rv, { 'tag' => $2,
			    'index' => scalar(@rv),
			    'line' => $lnum,
			    'eline' => $lnum });
		$tag = $rv[@rv-1];
		}
	$lnum++;
	}
close(CONF);
return \@rv;
}

# create_log(&log)
sub create_log
{
local $lref = &read_file_lines($config{'syslog_conf'});
if ($config{'tags'}) {
	splice(@$lref, $_[0]->{'section'}->{'eline'}+1, 0, &log_line($_[0]));
	}
else {
	push(@$lref, &log_line($_[0]));
	}
&flush_file_lines();
}

# update_log(&old, &log)
sub update_log
{
local $lref = &read_file_lines($config{'syslog_conf'});
if ($config{'tags'} && $_[0]->{'section'} ne $_[1]->{'section'}) {
	if ($_[0]->{'section'}->{'line'} < $_[1]->{'section'}->{'line'}) {
		splice(@$lref, $_[1]->{'section'}->{'eline'}+1, 0,
		       &log_line($_[1]));
		splice(@$lref, $_[0]->{'line'},
		       $_[0]->{'eline'} - $_[0]->{'line'} + 1);
		}
	else {
		splice(@$lref, $_[0]->{'line'},
		       $_[0]->{'eline'} - $_[0]->{'line'} + 1);
		splice(@$lref, $_[1]->{'section'}->{'eline'}+1, 0,
		       &log_line($_[1]));
		}
	}
else {
	splice(@$lref, $_[0]->{'line'}, $_[0]->{'eline'} - $_[0]->{'line'} + 1,
	       &log_line($_[1]));
	}
&flush_file_lines();
}

# delete_log(&log)
sub delete_log
{
local $lref = &read_file_lines($config{'syslog_conf'});
splice(@$lref, $_[0]->{'line'}, $_[0]->{'eline'} - $_[0]->{'line'} + 1);
&flush_file_lines();
}

sub log_line
{
local $d;
if ($_[0]->{'file'}) {
	$d = ($_[0]->{'sync'} ? "-" : "").$_[0]->{'file'};
	}
elsif ($_[0]->{'pipe'}) {
	$d = '|'.$_[0]->{'pipe'};
	}
elsif ($_[0]->{'host'}) {
	$d = '@'.$_[0]->{'host'};
	}
elsif ($_[0]->{'users'}) {
	$d = join(",", @{$_[0]->{'users'}});
	}
else {
	$d = '*';
	}
return ($_[0]->{'active'} ? "" : "#").join(";", @{$_[0]->{'sel'}})."\t".$d;
}

1;

