#!/usr/local/bin/perl
# index.cgi
# Display syslog rules

require './syslog-lib.pl';
&header($text{'index_title'}, "", undef, 1, 1);
print "<hr>\n";

if ($config{'m4_conf'}) {
	# Does the config file need to be passed through m4?
	$oldslash = $/;
	$/ = undef;
	open(CONF, $config{'syslog_conf'});
	$conf1 = <CONF>;
	close(CONF);
	open(CONF, "$config{'m4_path'} $config{'syslog_conf'} |");
	$conf2 = <CONF>;
	close(CONF);
	$/ = $oldslash;
	if ($conf1 ne $conf2) {
		# syslog.conf has m4 directives .. ask the user if he wants
		# to filter the file
		print "<p>",&text('index_m4msg',
				  "<tt>$config{'syslog_conf'}</tt>"),"\n";
		print "<center><form action=m4.cgi>\n";
		print "<input type=submit value='$text{'index_m4'}'>\n";
		print "</form></center>\n";
		print "<hr>\n";
		&footer("/", $text{'index'});
		exit;
		}
	}

# Display syslog rules
$conf = &get_config();
print "<table border width=100%>\n";
print "<tr $tb> <td><b>$text{'index_to'}</b></td> ",
      $config{'tags'} ? "<td><b>$text{'index_tag'}</b></td>" : "",
      "<td><b>$text{'index_active'}</b></td> ",
      "<td><b>$text{'index_rule'}</b></td> </tr>\n";
foreach $c (@$conf) {
	next if ($c->{'tag'});
	print "<tr $cb>\n";
	print "<td><a href='edit_log.cgi?idx=$c->{'index'}'>";
	if ($c->{'file'}) {
		print &text('index_file', "<tt>$c->{'file'}</tt>");
		}
	elsif ($c->{'pipe'} && $config{'pipe'} == 1) {
		print &text('index_pipe', "<tt>$c->{'pipe'}</tt>");
		}
	elsif ($c->{'pipe'} && $config{'pipe'} == 2) {
		print &text('index_pipe2', "<tt>$c->{'pipe'}</tt>");
		}
	elsif ($c->{'host'}) {
		print &text('index_host', "<tt>$c->{'host'}</tt>");
		}
	elsif ($c->{'all'}) {
		print $text{'index_all'};
		}
	else {
		print &text('index_users',
			    "<tt>".join(" ", @{$c->{'users'}})."</tt>");
		}
	print "</a></td>\n";
	if ($config{'tags'}) {
		printf "<td>%s</td>\n",
			$c->{'section'}->{'tag'} eq '*'
			? $text{'all'} : $c->{'section'}->{'tag'};
		}
	print "<td>",$c->{'active'} ? $text{'yes'}
				    : "<font color=#ff0000>$text{'no'}</font>",
	      "</td> <td>\n";
	print join("&nbsp;;&nbsp;", @{$c->{'sel'}});
	print "</td> </tr>\n";
	}
print "</table>\n";
print "<a href='edit_log.cgi?new=1'>$text{'index_add'}</a> <p>\n";

print "<hr>\n";
if (open(PID, $config{'pid_file'}) && <PID> =~ /^(\d+)$/ && kill(0, $1)) {
	print "<form action=restart.cgi>\n";
	print "<table width=100%><tr>\n";
	print "<input type=hidden name=pid value='$1'>\n";
	print "<td><input type=submit value='$text{'index_restart'}'></td>\n";
	print "<td>$text{'index_restartmsg'}</td>\n";
	print "</tr></table></form>\n";
	}
else {
	print "<form action=start.cgi>\n";
	print "<table width=100%><tr>\n";
	print "<td><input type=submit value='$text{'index_start'}'></td>\n";
	print "<td>",&text('index_startmsg', "<tt>$config{'syslogd'}</tt>"),
	      "</td>\n";
	print "</tr></table></form>\n";
	}
close(PID);

print "<hr>\n";
&footer("/", $text{'index'});

