#!/usr/local/bin/perl
# install_pack.cgi
# Install a package from some source

require './software-lib.pl';
$| = 1;
if ($ENV{REQUEST_METHOD} eq "POST") { &ReadParseMime(); }
else { &ReadParse(); $no_upload = 1; }
&error_setup($text{'install_err'});

if ($in{source} == 0) {
	# installing from local file (or maybe directory)
	if (!$in{'local'})
		{ &error($text{'install_elocal'}); }
	if (!-r $in{'local'})
		{ &error(&text('install_elocal2', $in{'local'})); }
	$source = $in{'local'};
	$pfile = $in{'local'};
	$need_unlink = 0;
	}
elsif ($in{source} == 1) {
	# installing from upload .. store file in temp location
	if ($no_upload) {
		&error($text{'install_eupload'});
		}
	$in{'upload_filename'} =~ /([^\/]+$)/;
	$pfile = "/tmp/$1";
	open(PFILE, "> $pfile");
	print PFILE $in{'upload'};
	close(PFILE);
	$source = $in{'upload_filename'};
	$need_unlink = 1;
	}
elsif ($in{source} == 2) {
	# installing from URL.. store downloaded file in temp location
	$in{'url'} =~ /\/([^\/]+)\/*$/;
	$pfile = "/tmp/$1";
	if ($in{'url'} =~ /^http:\/\/([^\/]+)(\/.*)$/) {
		# Make a HTTP request
		$host = $1; $page = $2; $port = 80;
		if ($host =~ /^(.*):(\d+)$/) { $host = $1; $port = $2; }
		&http_download($host, $port, $page, $pfile);
		}
	elsif ($in{'url'} =~ /^ftp:\/\/([^\/]+)(\/.*)$/) {
		$host = $1; $file = $2;
		&ftp_download($host, $file, $pfile);
		}
	else { &error(&text('install_eurl', $in{'url'})); }
	$source = $in{'url'};
	$need_unlink = 1;
	}

# Check validity
if (!&is_package($pfile)) {
	if (-d $pfile) {
		&error(&text('install_edir', &package_system()));
		}
	else {
		# attempt to uncompress
		local $unc = &uncompress_if_needed($pfile, $need_unlink);
		if ($unc ne $pfile) {
			# uncompressed ok..
			if (!&is_package($unc)) {
				unlink($unc);
				&error(&text('install_ezip',
					     &package_system()));
				}
			$pfile = $unc;
			}
		else {
			# uncompress failed.. give up
			unlink($pfile) if ($need_unlink);
			&error(&text('install_efile', &package_system()));
			}
		}
	}

# ask for package to install and install options
&header($text{'install_title'}, "", "install");
@rv = &file_packages($pfile);
print "<hr>\n";

print "<form action=do_install.cgi>\n";
print "<input type=hidden name=file value=\"$pfile\">\n";
print "<input type=hidden name=need_unlink value=\"$need_unlink\">\n";
print "<table border>\n";
print "<tr $tb> <td><b>$text{'install_header'}</b></td> </tr>\n";
print "<tr $cb> <td><table>\n";
print "<tr> <td valign=top><b>$text{'install_packs'}</b></td>\n";
print $wide_install_options ? "<td colspan=3>\n" : "<td>\n";
foreach (@rv) {
	($p, $d) = split(/\s+/, $_, 2);
	print "$d ($p)<br>\n";
	}
&install_options($pfile, $p);
print "</table></td></tr>\n";
print "</table><p><input type=submit value=\"$text{'install_ok'}\"></form>\n";

print "<hr>\n";
&footer("", $text{'index_return'});


