# servers-lib.pl
# Common functions for managing servers

do '../web-lib.pl';
&init_config();

sub list_servers
{
local ($f, @rv);
opendir(DIR, $module_config_directory);
while($f = readdir(DIR)) {
	if ($f =~ /^(\d+)\.serv$/) {
		push(@rv, &get_server($1));
		}
	}
closedir(DIR);
return @rv;
}

# get_server(id)
sub get_server
{
local $serv;
$serv->{'id'} = $_[0];
&read_file("$module_config_directory/$_[0].serv", $serv) || return undef;
return $serv;
}

# save_server(&server)
sub save_server
{
&write_file("$module_config_directory/$_[0]->{'id'}.serv", $_[0]);
}

# delete_server(id)
sub delete_server
{
unlink("$module_config_directory/$_[0].serv");
}

@server_types = ( [ 'caldera', 'OpenLinux' ],
		  [ 'redhat', 'Redhat Linux' ],
		  [ 'suse', 'SuSE Linux' ],
		  [ 'debian', 'Debian Linux' ],
		  [ 'mandrake', 'Mandrake Linux' ],
		  [ 'linux', 'Linux' ],
		  [ 'freebsd', 'FreeBSD' ],
		  [ 'solaris', 'Solaris' ],
		  [ 'hpux', 'HP/UX' ],
		  [ 'sco', 'SCO' ],
		  [ 'mac', 'Macintosh' ],
		  [ 'irix', 'IRIX' ],
		  [ 'unknown', 'Other' ] );


1;

