#!/usr/local/bin/perl
# list_relay.cgi
# List domains to while relaying is allowed

require './sendmail-lib.pl';
$access{'relay'} || &error($text{'relay_ecannot'});
&header($text{'relay_title'}, "");
print "<hr>\n";

$conf = &get_sendmailcf();
$ver = &find_type("V", $conf);
if ($ver->{'value'} !~ /^(\d+)/ || $1 < 8) {
	# Only sendmail 8.9 and above supports relay domains (I think)
	print "<p><b>",$text{'relay_eversion'},"</b> <p>\n";
	print "<hr>\n";
	&footer("", $text{'index_return'});
	exit;
	}

foreach $f (&find_type("F", $conf)) {
	if ($f->{'value'} =~ /^R[^\/]*(\/\S+)/) { $relayfile = $1; }
	}
if ($relayfile) {
	# get domains listed in a separate file
	open(RELAY, $relayfile);
	while(<RELAY>) {
		s/\r|\n//g;
		s/#.*$//g;
		if (/\S/) { push(@dlist, $_); }
		}
	close(RELAY);
	}

# Add domains from sendmail.cf
foreach $f (&find_type("C", $conf)) {
	if ($f->{'value'} =~ /^R\s*(.*)$/) {
		push(@dlist, split(/\s+/, $1));
		}
	}

print "<form method=post action=save_relay.cgi>\n";
print "<input type=hidden name=relayfile value=\"$relayfile\">\n";
print "<table cellpadding=5 width=100%><tr><td valign=top nowrap>\n";
print "<b>$text{'relay_domains'}</b><br>\n";
print "<textarea name=dlist rows=10 cols=30>",
	join("\n", @dlist),"</textarea><br>\n";
print "<input type=submit value=\"$text{'save'}\">\n";

print "</td><td valign=top>\n";
print &text('relay_desc1', "list_access.cgi"),"<p>\n";
print &text('relay_desc2', "list_mailers.cgi"),"<br>\n";
print "</td></tr></table>\n";
print "</form>\n";

print "<hr>\n";
&footer("", $text{'index_return'});


