#!/usr/local/bin/perl
# list_mail.cgi
# List the mail messages for some user

require './sendmail-lib.pl';
require './boxes-lib.pl';
&ReadParse();
&can_read_mail($in{'user'}) || &error($text{'mail_ecannot'});

&header($text{'mail_title'}, "");
print "<center><font size=+2>",
      &text('mail_for', "<tt>$config{'mail_dir'}/$in{'user'}</tt>"),
      "</font></center>\n";
print "<hr>\n";

if (!defined($in{'start'}) && $config{'order_mail'}) {
	# View mail from the oldest
	@mail = reverse(&list_mails($in{'user'}, 0, $config{'perpage'}-1));
	$in{'start'} = @mail-$config{'perpage'};
	$in{'start'} = 0 if ($in{'start'} < 0);
	}
else {
	# View mail from the most recent
	@mail = reverse(&list_mails($in{'user'},
			-$in{'start'}, -$in{'start'}-$config{'perpage'}+1));
	}
if ($in{'start'} || @mail > $config{'perpage'}) {
	print "<center>\n";
	if ($in{'start'}+$config{'perpage'} < @mail) {
		printf "<a href='list_mail.cgi?user=%s&start=%d'>%s</a>\n",
			$in{'user'}, $in{'start'}+$config{'perpage'},
			'<img src=/images/left.gif border=0 align=middle>';
		}
	local $s = @mail-$in{'start'};
	local $e = @mail-$in{'start'}-$config{'perpage'}+1;
	print "<font size=+1>",&text('mail_pos', $s, $e < 1 ? 1 : $e,
				     scalar(@mail)),"</font>\n";
	if ($in{'start'}) {
		printf "<a href='list_mail.cgi?user=%s&start=%d'>%s</a>\n",
			$in{'user'}, $in{'start'}-$config{'perpage'},
			'<img src=/images/right.gif border=0 align=middle>';
		}
	print "</center>\n";
	}

if (!@mail) {
	print "<b>$text{'mail_none'}</b><p>\n";
	}
else {
	print "<form action=delete_mail.cgi>\n";
	print "<input type=hidden name=user value='$in{'user'}'>\n";
	print "<table border width=100%>\n";
	print "<tr $tb> <td>&nbsp;</td> <td><b>$text{'mail_from'}</b></td> ",
	      "<td><b>$text{'mail_date'}</b></td> ",
	      "<td><b>$text{'mail_size'}</b></td> ",
	      "<td><b>$text{'mail_subject'}</b></td> </tr>\n";
	}

for($i=$in{'start'}; $i<@mail && $i<$in{'start'}+$config{'perpage'}; $i++) {
	local $idx = $mail[$i]->{'idx'};
	print "<tr $cb>\n";
	print "<td><input type=checkbox name=d value=$idx></td>\n";
	print "<td nowrap><a href='view_mail.cgi?user=$in{'user'}&idx=$idx'>",
              &simplify_from($mail[$i]->{'header'}->{'from'}),"</td>\n";
	print "<td nowrap>",&simplify_date($mail[$i]->{'header'}->{'date'}),
	      "</td>\n";
	print "<td nowrap>",int($mail[$i]->{'size'}/1000)+1," Kb";
	if ($mail[$i]->{'header'}->{'content-type'} =~ /multipart\/\S+/i) {
		print "&nbsp;<img src=images/attach.gif>";
		}
	print "</td>\n";
	print "<td>",&simplify_subject($mail[$i]->{'header'}->{'subject'}),
	      "</td>\n";
	print "</tr>\n";
	}
if (@mail) {
	print "</table>\n";
	print "<a href='' onClick='for(i=0; i<document.forms[0].d.length; i++) { document.forms[0].d[i].checked = true; } return false'>$text{'mail_all'}</a>&nbsp;\n";
	print "<a href='' onClick='for(i=0; i<document.forms[0].d.length; i++) { document.forms[0].d[i].checked = !document.forms[0].d[i].checked; } return false'>$text{'mail_invert'}</a>&nbsp;\n";
	}

print "<table width=100%> <tr>\n";
if (@mail) {
	print "<td>\n";
	print "<input type=submit name=delete value=\"$text{'mail_delete'}\">\n";
	print "</td></form>\n";
	}
print "<form action=reply_mail.cgi>\n";
print "<input type=hidden name=user value=\"$in{'user'}\">\n";
print "<input type=hidden name=new value=1>\n";
print "<td align=right><input type=submit value=\"$text{'mail_compose'}\">\n";
print "</td></form> </tr></table>\n";

if (@mail) {
	print "<hr>\n";
	print "<form action=mail_search.cgi>\n";
	print "<input type=hidden name=user value=\"$in{'user'}\">\n";
	print "<b>$text{'mail_search'}</b>\n";
	print "<select name=field>\n";
	foreach $f ('from', 'subject', 'to', 'cc', 'date', 'body') {
		printf "<option value=%s>%s\n", $f, $text{"mail_$f"};
		}
	print "</select>\n";
	print "<b>$text{'mail_match'}</b> <input name=match size=20>\n";
	print "&nbsp;<input type=submit value='$text{'mail_ok'}'\n";
	print "</form><p>\n";
	}

print "<hr>\n";
&footer("list_boxes.cgi", $text{'boxes_return'});


