
do './samba-lib.pl';

# useradmin_create_user(&details)
# Create a new samba user if sync is enabled
sub useradmin_create_user
{
&get_share("global");
if (&istrue("encrypt passwords") && $config{'smb_passwd'} &&
    $config{'sync_add'} && !&get_user($_[0]->{'user'})) {
	# Add a user to smbpasswd
	local $u = { 'name' => $_[0]->{'user'},
		     'uid' => $_[0]->{'uid'} };
	if ($samba_version >= 2) {
		local @opts = ("U");
		push(@opts, "N") if ($_[0]->{'passmode'} == 0);
		push(@opts, "D") if ($_[0]->{'passmode'} == 1);
		$u->{'opts'} = \@opts;
		}
	else {
		$u->{'real'} = $_[0]->{'real'};
		$u->{'home'} = $_[0]->{'home'};
		$u->{'shell'} = $_[0]->{'shell'};
		}
	$u->{'pass1'} = $u->{'pass2'} = ("X" x 32);
	if ($_[0]->{'passmode'} == 0)
		{ $u->{'pass1'} = "NO PASSWORDXXXXXXXXXXXXXXXXXXXXX"; }
	&create_user($u);
	if ($_[0]->{'passmode'} == 3)
		{ &set_password($_[0]->{'user'}, $_[0]->{'plainpass'}); }
	}
}

# useradmin_delete_user(&details)
# Delete a samba user
sub useradmin_delete_user
{
&get_share("global");
if (&istrue("encrypt passwords") && $config{'smb_passwd'} &&
    $config{'sync_delete'} && ($u = &get_user($_[0]->{'user'}))) {
	# Delete the user
	&delete_user($u);
	}
}

# useradmin_modify_user(&details)
# Update a samba user
sub useradmin_modify_user
{
&get_share("global");
if (&istrue("encrypt passwords") && $config{'smb_passwd'} &&
    $config{'sync_change'} && ($u = &get_user($_[0]->{'olduser'}))) {
	# Update details
	$u->{'uid'} = $_[0]->{'uid'};
	$u->{'name'} = $_[0]->{'user'};
	if ($u->{'opts'}) {
		local @opts = grep { !/[ND]/ } @{$u->{'opts'}};
		push(@opts, "N") if ($_[0]->{'passmode'} == 0);
		push(@opts, "D") if ($_[0]->{'passmode'} == 1);
		$u->{'opts'} = \@opts;
		}
	else {
		$u->{'real'} = $_[0]->{'real'};
		$u->{'home'} = $_[0]->{'home'};
		$u->{'shell'} = $_[0]->{'shell'};
		}
	if ($_[0]->{'passmode'} == 0) {
		$u->{'pass1'} = "NO PASSWORDXXXXXXXXXXXXXXXXXXXXX";
		$u->{'pass2'} = ("X" x 32);
		}
	elsif ($_[0]->{'passmode'} == 1) {
		$u->{'pass1'} = $u->{'pass2'} = ("X" x 32);
		}
	&modify_user($u);
	if ($_[0]->{'passmode'} == 3) {
		&set_password($_[0]->{'user'}, $_[0]->{'plainpass'});
		}
	}
}

sub get_user
{
local @ulist = &list_users();
local $u;
foreach $u (@ulist) {
	return $u if ($u->{'name'} eq $_[0]);
	}
return undef;
}

1;

