# opts.pl
# Defines which smb.conf options are available in which samba versions

# default_options(&array, version)
# Fills in the given associative array with the default value for all
# supported options, based on the given samba version
sub default_options
{
@op = ( [ "admin users",		"",		1.905,	1 ],
	[ "announce as",		"NT",		???,	0 ],
	[ "announce version",		"4.2",		???,	0 ],
	[ "auto services",		"",		0,	0 ],
	[ "=preload" ],
	[ "allow hosts",		"",		0,	0 ],
	[ "=hosts allow" ],
	[ "alternate permissions",	"no",		1.916,	1 ],
	[ "available",			"yes",		1.513,	1 ],
	[ "bind interfaces only",	"false",	1.918,	0 ],
	[ "browseable",			"yes",		0,	1 ],
	[ "browse list",		"yes",		0,	0 ],
	[ "case sensitive",		"no",		0,	0 ],
	[ "=case sig names" ],
	[ "character set",		"",		0,	0 ],
	[ "client code page",		"850",		1.917,	0 ],
	[ "comment",			"",		0,	1 ],
	[ "copy",			"",		0,	1 ],
	[ "create mode",		"0744",		0,	1 ],
	[ "=create mask" ],
	[ "dead time",			0,		0,	0 ],
	[ "debug level",		"",		1.900,	0 ],
	[ "=log level" ],
	[ "default case",		"lower",	1.800,	1 ],
	[ "default service",		"",		1.700,	0 ],
	[ "=default" ],
	[ "delete readonly",		"no",		0,	1 ],
	[ "deny hosts",			"",		1.525,	1 ],
	[ "=hosts deny" ],
	[ "delete veto files",		"false",	???,	1 ],
	[ "dfree command",		"",		1.541,	0 ],
	[ "directory mask",		"0755",		???,	1 ],
	[ "=directory mode" ],
	[ "dns proxy",			"yes",		???,	0 ],
	[ "domain controller",		"no",		1.916,	0 ],
	[ "domain logons",		"no",		1.916,	0 ],
	[ "domain master",		"no",		1.916,	0 ],
	[ "dont descend",		"",		1.522,	1 ],
	[ "dos filetimes",		"false",	???,	1 ],
	[ "encrypt passwords",		"false",	0,	0 ],
	[ "fake oplocks",		"no",		0,	1 ],
	[ "follow symlinks",		"yes",		0,	1 ],
	[ "force create mode",		"0000",		???,	1 ],
	[ "force directory mode",	"0000",		???,	1 ],
	[ "force group",		"",		1.802,	1 ],
	[ "group" ],
	[ "force user",			"",		1.913,	1 ],
	[ "getwd cache",		"no",		1.703,	0 ],
	[ "guest account",		"nobody",	1.900,	1 ],
	[ "guest only",			"no",		1.604,	1 ],
	[ "=only guest" ],
	[ "hide dot files",		"yes",		1.802,	1 ],
	[ "hide files",			"",		???,	1 ],
	[ "homedir map",		"",		???,	0 ],
	[ "hosts equiv",		"",		1.800,	0 ],
	[ "interfaces",			"",		???,	0 ],
	[ "invalid users",		"",		1.800,	1 ],
	[ "keep alive",			0,		0,	0 ],
	[ "lm announce",		"auto",		???,	0 ],
	[ "lm interval",		60,		???,	0 ],
	[ "load printers",		"yes",		1.802,	0 ],
	[ "local master",		"yes",		???,	0 ],
	[ "lock directory",		"",		1.705,	0 ],
	[ "=lock dir" ],
	[ "locking",			"yes",		1.609,	1 ],
	[ "log file",			"",		1.900,	0 ],
	[ "logon drive",		"",		???,	0 ],
	[ "logon home",			"",		???,	0 ],
	[ "logon path",			"",		???,	0 ],
	[ "logon script",		"",		???,	0 ],
	[ "lppause command",		"",		0,	0 ],
	[ "lpq cache time",		10,		1.914,	0 ],
	[ "lpq command",		"",		???,	1 ],
	[ "lpresume command",		"",		???,	1 ],
	[ "lprm command",		"",		???,	1 ],
	[ "magic output",		"",		1.700,	1 ],
	[ "magic script",		"",		1.700,	1 ],
	[ "mangle case",		"no",		0,	1 ],
	[ "mangled map",		"",		1.802,	1 ],
	[ "mangled names",		"yes",		1.800,	1 ],
	[ "mangling char",		"~",		1.800,	1 ],
	[ "mangled stack",		50,		1.700,	0 ],
	[ "map archive",		"yes",		1.913,	1 ],
	[ "map hidden",			"no",		0,	1 ],
	[ "map system",			"no",		0,	1 ],
	[ "max connections",		0,		1.705,	1 ],
	[ "max disk size",		0,		???,	0 ],
	[ "max log size",		5000,		1.900,	0 ],
	[ "max mux",			50,		1.802,	0 ],
	[ "max ttl",			14400,		1.915,	0 ],
	[ "max wins ttl",		259200,		???,	0 ],
	[ "max xmit",			65535,		1.525,	0 ],
	[ "message command",		"",		1.901,	0 ],
	[ "min print space",		0,		1.914,	1 ],
	[ "min wins ttl",		21600,		???,	0 ],
	[ "netbios aliases",		"",		???,	0 ],
	[ "netbios name",		"",		???,	0 ],
	[ "nis homedir",		"false",	???,	0 ],
	[ "null passwords",		"no",		1.803,	0 ],
	[ "only user",			"false",	1.703,	1 ],
	[ "oplocks",			"true",		1.918,	1 ],
	[ "os level",			???,		???,	0 ],
	[ "passwd chat",		"",		1.914,	0 ],
	[ "passwd program",		"/bin/passwd",	0 ],
	[ "password level",		0,		1.700,	0 ],
	[ "password server",		"",		1.900,	0 ], # multiple
	[ "path",			"",		0,	1 ],
	[ "=directory" ],
	[ "postexec",			"",		1.906,	1 ],
	[ "postscript",			"false",	1.801,	1 ],
	[ "preexec",			"",		0,	1 ],
	[ "=exec" ],
	[ "preferred master",		"no",		???,	0 ],
	[ "preserve case",		"no",		0,	1 ],
	[ "print command",		"",		1.518,	1 ],
	[ "printable",			"no",		0,	1 ],
	[ "=print ok" ],
	[ "printcap name",		"",		1.513,	0 ],
	[ "printer",			"",		0,	1 ],
	[ "=printer name" ],
	[ "printer driver",		"",		0,	1 ],
	[ "printer driver file",	"",		???,	0 ],
	[ "printer driver location",	"",		???,	1 ],
	[ "printing",			"",		1.918,	1 ],
	[ "printing",			"",		0,	0 ],
	[ "protocol",			"NT1",		1.603,	0 ],
	[ "public",			"no",		0,	1 ],
	[ "=guest ok" ],
	[ "read list",			"",		1.802,	1 ],
	[ "read prediction",		"false",	1.705,	0 ],
	[ "read raw",			"yes",		1.700,	0 ],
	[ "read size",			2048,		1.900,	0 ],
	[ "remote announce",		"",		???,	0 ],
	[ "remote browse sync",		"",		???,	0 ],
	[ "revalidate",			"false",	1.902,	1 ],
	[ "root directory",		"/",		1.522,	0 ],
	[ "=root" ],
	[ "=root dir" ],
	[ "root preexec",		"",		1.9.11,	1 ],
	[ "root postexec",		"",		1.9.11,	1 ],
	[ "security",			"SHARE",	1.609,	0 ],
	[ "server string",		"",		1.800,	0 ],
	[ "shared file entries",	113,		???,	0 ],
	[ "shared mem size",		102400,		???,	0 ],
	[ "smb passwd file",		"",		1.914,	0 ],
	[ "smbrun",			"",		1.911,	0 ],
	[ "share modes",		"yes",		1.913,	1 ],
	[ "short preserve case",	"no",		1.914,	1 ],
	[ "socket address",		"",		???,	0 ],
	[ "socket options",		"",		1.903,	0 ],
	[ "status",			"yes",		1.803,	0 ],
	[ "strict locking",		"no",		1.900,	1 ],
	[ "strip dot",			"no",		1.900,	1 ],
	[ "syslog",			1,		???,	0 ],
	[ "syslog only",		"no",		???,	0 ],
	[ "sync always",		"no",		1.914,	1 ],
	[ "time offset",		0,		???,	0 ],
	[ "time server",		"false",	???,	0 ],
	[ "unix realname",		"no",		???,	0 ],
	[ "user",			"",		1.502,	1 ],
	[ "=username" ],
	[ "username level",		0,		???,	0 ],
	[ "username map",		"",		1.913,	0 ],
	[ "valid chars",		"",		1.912,	1 ],
	[ "valid users",		"",		1.800,	1 ],
	[ "veto files",			"",		???,	1 ],
	[ "veto oplock files",		"",		???,	1 ],
	[ "volume",			"",		0,	1 ],
	[ "wide links",			"yes",		0,	1 ],
	[ "wins proxy",			"no",		???,	0 ],
	[ "wins server",		"",		???,	0 ],
	[ "wins support",		"no",		???,	0 ],
	[ "workgroup",			"",		1.913,	0 ],
	[ "writable",			"no",		1.513,	1 ],
	[ "=write ok" ],
	[ "write list",			"",		1.802,	1 ],
	[ "write raw",			"yes",		1.913,	0 ] ];



	[ "exec" ],
	[ "max packet" ]

}

