#!/usr/local/bin/perl
# raid_form.cgi
# Display a form for creating a raid device

require './raid-lib.pl';
&foreign_require("fdisk", "fdisk-lib.pl");
&foreign_require("mount", "mount-lib.pl");
&ReadParse();
$conf = &get_raidtab();

# Display headers
$max = 0;
foreach $c (@$conf) {
	if ($c->{'value'} =~ /md(\d+)$/ && $1 >= $max) {
		$max = $1+1;
		}
	}
&header($text{'create_title'}, "");
$raid = { 'value' => "/dev/md$max",
	  'members' => [ { 'name' => 'raid-level',
			   'value' => $in{'level'} },
			 { 'name' => 'persistent-superblock',
			   'value' => 1 }
		       ] };
print "<hr>\n";

# Find partitions used by raid
foreach $c (@$conf) {
	foreach $d (&find_value('device', $c->{'members'})) {
		if ($c eq $raid) {
			$sel{$d}++;
			}
		else {
			$used{$d}++;
			}
		}
	}

# Find mounted partitions
foreach $m (&foreign_call("mount", "list_mounted")) {
	$used{$m->[1]}++;
	$mounted{$m->[1]} = $m->[0];
	}
foreach $m (&foreign_call("mount", "list_mounts")) {
	$used{$m->[1]}++;
	}

# Find available partitions
foreach $d (&foreign_call("fdisk", "list_disks")) {
	foreach $p (&foreign_call("fdisk", "list_partitions", $d->{'device'})) {
		next if ($used{$p->{'device'}} || $p->{'extended'});
		$tag = &foreign_call("fdisk", "tag_name", $p->{'type'});
		$disks .= sprintf "<option value='%s'>%s %s\n",
			$p->{'device'}, $p->{'desc'},
			$tag ? "($tag)" : "";
		}
	}
foreach $c (@$conf) {
	if ($c->{'active'} && !$used{$c->{'value'}}) {
		$disks .= sprintf "<option value='%s'>%s\n",
				$c->{'value'},
				&text('create_rdev', substr($c->{'value'}, -1));
		}
	}
if (!$disks) {
	print "<p><b>$text{'create_nodisks'}</b> <p>\n";
	print "<hr>\n";
	&footer("", $text{'index_return'});
	exit;
	}

print "<form action=create_raid.cgi>\n";
print "<input type=hidden name=idx value='$in{'idx'}'>\n";
print "<table border>\n";
print "<tr $tb> <td><b>$text{'create_header'}</b></td> </tr>\n";
print "<tr $cb> <td><table>\n";

print "<tr> <td><b>$text{'create_device'}</b></td>\n";
print "<td><tt>$raid->{'value'}</tt></td> </tr>\n";
print "<input type=hidden name=device value='$raid->{'value'}'>\n";

$lvl = &find_value('raid-level', $raid->{'members'});
print "<tr> <td><b>$text{'create_level'}</b></td>\n";
print "<td>",$lvl eq 'linear' ? $text{'linear'}
			      : $text{"raid$lvl"},"</td> </tr>\n";
print "<input type=hidden name=level value='$lvl'>\n";

$super = &find_value('persistent-superblock', $raid->{'members'});
print "<tr> <td><b>$text{'create_super'}</b></td>\n";
printf "<td><input name=super type=radio value=1 %s> %s\n",
	$super ? 'checked' : '', $text{'yes'};
printf "<td><input name=super type=radio value=0 %s> %s</td> </tr>\n",
	$super ? '' : 'checked', $text{'no'};

if ($lvl eq '5') {
	$parity = &find_value('parity-algorithm', $raid->{'members'});
	print "<tr> <td><b>$text{'create_parity'}</b></td>\n";
	print "<td><select name=parity>\n";
	foreach $a ('', 'left-asymmetric', 'right-asymmetric',
		    'left-symmetric', 'right-symmetric') {
		printf "<option value='%s' %s>%s\n",
			$a, $parity eq $a ? 'selected' : '',
			$a ? $a : $text{'default'};
		}
	print "</select></td> </tr>\n";
	}

$chunk = &find_value('chunk-size', $raid->{'members'});
print "<tr> <td><b>$text{'create_chunk'}</b></td>\n";
print "<td><select name=chunk>\n";
for($i=4; $i<=4096; $i*=2) {
	printf "<option value=%d %s>%d Kb\n",
		$i, $chunk == $i ? 'selected' : '', $i;
	}
print "</select></td> </tr>\n";

# Display partitions in raid, spares and parity
print "<tr> <td valign=top><b>$text{'create_disks'}</b></td>\n";
print "<td><select name=disks multiple size=4>\n";
print $disks;
print "</select></td> </tr>\n";

if ($lvl >= 4) {
	print "<tr> <td valign=top><b>$text{'create_spares'}</b></td>\n";
	print "<td><select name=spares multiple size=4>\n";
	print $disks;
	print "</select></td> </tr>\n";
	}

if ($lvl == 4) {
	print "<tr> <td valign=top><b>$text{'create_pdisk'}</b></td>\n";
	print "<td><select name=pdisk>\n";
	print "<option value='' selected>$text{'create_auto'}\n";
	print $disks;
	print "</select></td> </tr>\n";
	}

print "<tr> <td><b>$text{'create_force'}</b></td>\n";
print "<td><input type=radio name=force value=1> $text{'yes'}\n";
print "<input type=radio name=force value=0 checked> $text{'no'}\n";
print "</td> </tr>\n";

print "</table></td></tr></table>\n";

print "<input type=submit value='$text{'create'}'></form>\n";

print "<hr>\n";
&footer("", $text{'index_return'});

