#!/usr/local/bin/perl
# mkfs.cgi
# Create a new linux filesystem

require './raid-lib.pl';
&foreign_require("fdisk", "fdisk-lib.pl");
&foreign_require("proc", "proc-lib.pl");

&ReadParse();
&error_setup($text{'mkfs_err'});
&foreign_call("fdisk", "error_setup", $text{'mkfs_err'});
&foreign_call("fdisk", "ReadParse");
$conf = &get_raidtab();
$raid = $conf->[$in{'idx'}];
$cmd = &foreign_call("fdisk", "mkfs_parse", "ext2", $raid->{'value'});

$lvl = &find_value('raid-level', $raid->{'members'});
$chunk = &find_value('chunk-size', $raid->{'members'});
if ($lvl >= 4) {
	$bs = $in{'ext2_b_def'} ? 4096 : $in{'ext2_b'};
	}

&header($text{'mkfs_title'}, "");
print "<hr>\n";
print &text('mkfs_exec', "<tt>$cmd</tt>"),"<p>\n";
print "<pre>\n";
&foreign_call("proc", "safe_process_exec", $cmd, 0, 0, STDOUT, undef, 1);
print "</pre>\n";

if ($?) { print "<b>$text{'mkfs_failed'}</b> <p>\n"; }
else { print "$text{'mkfs_ok'} <p>\n"; }

print "<hr>\n";
&footer("", $text{'index_return'});

