#!/usr/local/bin/perl
# index.cgi
# Display a list of all existing processes

require './proc-lib.pl';
&header($text{'index_title'}, "", "tree", "proc", 1);
print "<hr>\n";

&index_links("tree");
print "<table border width=100%>\n";
print "<tr $tb> <td><b>$text{'pid'}</b></td> <td><b>$text{'owner'}</b></td>\n";
print "         <td><b>$text{'command'}</b></td> </tr>\n";
@procs = sort { $a->{'pid'} <=> $b->{'pid'} } &list_processes();
$min = 999;
foreach $pr (@procs) {
	$p = $pr->{'pid'}; $pp = $pr->{'ppid'};
	$argmap{$p} = $pr->{'args'};
	$usermap{$p} = $pr->{'user'};
	push(@{$children{$pp}}, $p);
	$min = $p if ($p < $min);
	}
&walk_procs("", $min);
print "</table><p>\n";

print "<hr>\n";
&footer("/", $text{'index'});


# walk_procs(indent, pid)
sub walk_procs
{
local(@ch, $_, $args);
print "<tr $cb><td><tt>$_[0]<a href=\"edit_proc.cgi?$_[1]\">",
      "$_[1]</a></tt></td> <td>$usermap{$_[1]}</td>\n";
$args = &cut_string($argmap{$_[1]}, 70);
print "<td>$args</td> </tr>\n";
foreach (@{$children{$_[1]}}) {
	&walk_procs("$_[0]&nbsp;", $_) if ($_ != $_[1]);
	}
}

