#!/usr/local/bin/perl
# newdb.cgi
# Create a new database with one optional table

require './mysql-lib.pl';
&ReadParse();
$access{'create'} || &error($text{'newdb_ecannot'});
&error_setup($text{'newdb_err'});

$in{'db'} =~ /^[A-z0-9\.\-]+$/ || &error($text{'newdb_edb'});
if (!$in{'table_def'}) {
	$in{'table'} =~ /^\S+$/ || &error($text{'table_ename'});
	for($i=0; defined($in{"field_$i"}); $i++) {
		next if (!$in{"field_$i"});
		$in{"field_$i"} =~ /^\S+$/ ||
			&error(&text('table_efield', $in{"field_$i"}));
		$in{"type_$i"} || &error(&text('table_etype', $in{"field_$i"}));
		if ($in{"size_$i"}) {
			push(@fields, sprintf "%s %s(%s)",
			     $in{"field_$i"}, $in{"type_$i"}, $in{"size_$i"});
			}
		else {
			push(@fields, sprintf "%s %s",
			     $in{"field_$i"}, $in{"type_$i"});
			}
		}
	@fields || &error($text{'table_enone'});
	}
&execute_sql($master_db, "create database $in{'db'}");
if (@fields) {
	$sql = "create table $in{'table'} (".join(",", @fields).")";
	&execute_sql($in{'db'}, $sql);
	}
if ($access{'dbs'} ne '*') {
	$access{'dbs'} .= "$in{'db'} ";
	&save_module_acl(\%access);
	}
&redirect("");

