#!/usr/local/bin/perl
# save_mesg.cgi
# Save message options

require './majordomo-lib.pl';
&ReadParse();
%access = &get_module_acl();
&can_edit_list(\%access, $in{'name'}) ||
	&error("You are not allowed to edit this mailing list");
$list = &get_list($in{'name'}, &get_config());
$conf = &get_list_config($list->{'config'});
&save_opt($conf, $list->{'config'}, "reply_to", \&check_reply);
&save_opt($conf, $list->{'config'}, "sender", \&check_sender);
&save_opt($conf, $list->{'config'}, "resend_host", \&check_host);
&save_opt($conf, $list->{'config'}, "subject_prefix");
&save_select($conf, $list->{'config'}, "precedence");
&save_choice($conf, $list->{'config'}, "purge_received");
&save_opt($conf, $list->{'config'}, "maxlength", \&check_maxlength);
&flush_file_lines();
&redirect("edit_list.cgi?name=$in{'name'}", "mailing list");

sub check_reply
{
return $_[0] =~ /^\S+$/ ? undef : "Missing or invalid Reply-To: address";
}

sub check_sender
{
return $_[0] =~ /\@/ ? "Sender: address must not include a hostname" :
       $_[0] =~ /^\S+$/ ? undef : "Missing or invalid Sender: address";
}

sub check_host
{
return $_[0] =~ /^[A-z0-9\-\.]+$/ ? undef : "Missing or invalid hostname";
}

sub check_maxlength
{
return $_[0] =~ /^\d+$/ ? undef : "Missing or invalid maximum message size";
}

