#!/usr/local/bin/perl
# create_list.cgi
# Create a new mailing list

require './majordomo-lib.pl';
require 'ctime.pl';
%access = &get_module_acl();
$access{'create'} || &error("You are not allowed to create new lists");
&ReadParse();
$conf = &get_config();
$ldir = &perl_var_replace(&find_value("listdir", $conf), $conf);
$program_dir = $config{'smrsh_program_dir'} ? $config{'smrsh_program_dir'}
				            : $config{'program_dir'};

# Validate inputs
$in{'name'} =~ /^\S+$/ ||
	&error("Invalid or missing list name");
$in{'name'} = lc($in{'name'});
if (&get_list($in{'name'}, $conf)) {
	&error("A mailing list called '$in{'name'}' already exists");
	}
$aliases_files = &get_aliases_file();
@aliases = &foreign_call("sendmail", "list_aliases", $aliases_files);
foreach $a (@aliases) {
	if ($a->{'enabled'} && lc($a->{'name'}) eq lc($in{'name'})) {
		&error("A mail alias for '$in{'name'}' already exists");
		}
	}
$in{'owner'} =~ /^\S+$/ ||
	&error("Invalid or missing owner's email address");
$in{'password'} =~ /^\S+$/ ||
	&error("Invalid or missing administration password");
$in{'moderator_def'} || $in{'moderator'} =~ /^\S+$/ ||
	&error("Invalid or missing moderator's email address");
$in{'info'} =~ s/\r//g;
$in{'footer'} =~ s/\r//g;

# Create list members file
open(MEMS, ">$ldir/$in{'name'}");
close(MEMS);
&set_permissions("$ldir/$in{'name'}");

# Have majordomo create the new config file, by fooling the wrapper
# into thinking it has received an email with a config command
open(WRAPPER, "|$program_dir/wrapper majordomo >/dev/null 2>&1");
print WRAPPER "From: root\n\n";
print WRAPPER "config $in{'name'} $in{'password'}\n\n";
close(WRAPPER);

# create the .info file
$lfile = "$ldir/$in{'name'}.config";
$list = &get_list_config($lfile);
chop($ctime = ctime(time()));
$updated = "[Last updated on: $ctime]\n";
open(INFO, ">$ldir/$in{'name'}.info");
if (&find_value("date_info", $list) eq "yes") {
	print INFO $updated;
	}
print INFO $in{'info'};
close(INFO);
&set_permissions("$ldir/$in{'name'}.info");

# Create aliases for the new list
$lname = $config{'dynamic'} ? time()+$$ : "$in{'name'}-list";
&newlist_alias($in{'name'}, "|$program_dir/wrapper resend ".
		            "-l $in{'name'} $lname");
&newlist_alias($lname, ":include:$ldir/$in{'name'}");
&newlist_alias("owner-".$in{'name'}, $in{'owner'});
&newlist_alias($in{'name'}."-owner", $in{'owner'});
&newlist_alias($in{'name'}."-approval", $in{'owner'});
&newlist_alias($in{'name'}."-request", "|$program_dir/wrapper ".
				       "majordomo -l $in{'name'}", 1);

# Update the new config file
&save_list_directive($list, $lfile, "description", $in{'desc'});
&save_list_directive($list, $lfile, "admin_passwd", $in{'password'});
&save_list_directive($list, $lfile, "approve_passwd", $in{'password'});
&save_list_directive($list, $lfile, "message_footer", $in{'footer'}, 1);
&save_list_directive($list, $lfile, "moderate", $in{'moderate'});
&save_list_directive($list, $lfile, "moderator",
		     $in{'moderator_def'} ? "" : $in{'moderator'});
&flush_file_lines();

# add to this user's ACL
if ($access{'lists'} ne '*') {
	$access{'lists'} .= " $in{'name'}";
	&save_module_acl(\%access);
	}
&redirect("edit_list.cgi?name=$in{'name'}");

# newlist_alias(name, value, last)
sub newlist_alias
{
local $al = { 'name' => $_[0],
	      'values' => [ $_[1] ],
	      'enabled' => 1 };
&foreign_call("sendmail", "create_alias", $al, $aliases_files, !$_[2]);
}

