
require './lpadmin-lib.pl';

# acl_security_form(&options)
# Output HTML for editing security options for the lpadmin module
sub acl_security_form
{
print "<tr> <td valign=top><b>$text{'acl_printers'}</b></td>\n";
print "<td colspan=3><select name=printers multiple size=4 width=15>\n";
local @plist = &list_printers();
local ($p, %pcan);
map { $pcan{$_}++ } split(/\s+/, $_[0]->{'printers'});
foreach $p (@plist) {
	local $prn = &get_printer($p);
	printf "<option value=%s %s>%s (%s)\n",
		$p, $pcan{$p} || $pcan{'*'} ? 'selected' : '',
		$prn->{'desc'}, $p;
	}
print "</select></td> </tr>\n";

print "<tr> <td valign=top><b>$text{'acl_cancel'}</b></td> <td colspan=3>\n";
printf "<input type=radio name=cancel value=0 %s> $text{'no'}\n",
	$_[0]->{'cancel'} == 0 ? "checked" : "";
printf "<input type=radio name=cancel value=1 %s> $text{'yes'}\n",
	$_[0]->{'cancel'} == 1 ? "checked" : "";
printf "<input type=radio name=cancel value=2 %s> $text{'acl_listed'}<br>\n",
	$_[0]->{'cancel'} == 2 ? "checked" : "";
print "<select name=jobs multiple size=4 width=15>\n";
map { $jcan{$_}++ } split(/\s+/, $_[0]->{'jobs'});
foreach $p (@plist) {
	local $prn = &get_printer($p);
	printf "<option value=%s %s>%s (%s)\n",
		$p, $jcan{$p} ? 'selected' : '',
		$prn->{'desc'}, $p;
	}
print "</select></td> </tr>\n";

print "<tr> <td><b>$text{'acl_add'}</b></td>\n";
printf "<td><input type=radio name=add value=1 %s> $text{'yes'}\n",
	$_[0]->{'add'} ? "checked" : "";
printf "<input type=radio name=add value=0 %s> $text{'no'}</td>\n",
	$_[0]->{'add'} ? "" : "checked";

print "<td><b>$text{'acl_stop'}</b></td>\n";
printf "<td><input type=radio name=stop value=1 %s> $text{'yes'}\n",
	$_[0]->{'stop'} ? "checked" : "";
printf "<input type=radio name=stop value=0 %s> $text{'no'}</td> </tr>\n",
	$_[0]->{'stop'} ? "" : "checked";
}

# acl_security_save(&options)
# Parse the form for security options for the bind8 module
sub acl_security_save
{
local @sel = split(/\0/, $in{'printers'});
local @prns = &list_printers();
if (scalar(@sel) == scalar(@prns)) {
	$_[0]->{'printers'} = '*';
	}
else {
	$_[0]->{'printers'} = join(" ", @sel);
	}
$_[0]->{'cancel'} = $in{'cancel'};
$_[0]->{'jobs'} = $in{'cancel'} == 2 ? join(" ", split(/\0/, $in{'jobs'})) : "";
$_[0]->{'add'} = $in{'add'};
$_[0]->{'stop'} = $in{'stop'};
}

