#!/usr/local/bin/perl
# delboot.pl
# Called by uninstall.sh to stop webmin being started at boot time

$no_acl_check++;
require './init-lib.pl';
if (!$config{'init_base'}) {
	# Remove from boot time rc script
	open(LOCAL, $config{'local_script'});
	@local = <LOCAL>;
	close(LOCAL);
	$start = "$config_directory/start";
	open(LOCAL, ">$config{'local_script'}");
	print LOCAL grep { !/^$start/ } @local;
	close(LOCAL);
	print "Deleted from bootup script $config{'local_script'}\n";
	}
else {
	# Delete bootup action
	foreach (&action_levels('S', "webmin")) {
		/^(\S+)\s+(\S+)\s+(\S+)$/;
		&delete_rl_action($in{action}, $1, 'S');
		}
	foreach (&action_levels('K', "webmin")) {
		/^(\S+)\s+(\S+)\s+(\S+)$/;
		&delete_rl_action($in{action}, $1, 'K');
		}
	$fn = &action_filename("webmin");
	unlink($fn);
	print "Deleted init script $fn\n";
	}

