#!/usr/local/bin/perl
# newfs_form.cgi
# Display a form asking for new filesystem details

require './format-lib.pl';
&ReadParse();
&can_edit_disk($in{'dev'}) || &error("You are not allowed to format this disk");
&header("Create Filesystem", "");
print "<hr>\n";

print "<form action=newfs.cgi>\n";
print "<input type=hidden name=dev value=\"$in{dev}\">\n";

print "Clicking the button at the bottom of this form will\n";
print "build a new <b>",&fstype_name("ufs"),"</b> on the device\n";
print "<b><tt>$in{dev}</tt></b>. All data on this partition will be\n";
print "permanently erased. <p>\n";

if ((@stat = &device_status($in{dev})) && $stat[1] ne "swap") {
	print "This partition has been mounted on <tt>$stat[0]</tt> as a\n";
	print &fstype_name($in{type}),". Creating a new filesystem will\n";
	print "erase all files that were previously accesible under this\n";
	print "directory. <p>\n";
	}

print "<table border width=100%>\n";
print "<tr $tb> <td><b>Filesystem Options</b></td> </tr>\n";
print "<tr $cb> <td><table width=100%>\n";
&opt_input("Spare blocks / cylinder", "ufs_a", "", 1);
&opt_input("Logical block size", "ufs_b", "bytes", 0);
&opt_input("Cylinders / group", "ufs_c", "", 1);
&opt_input("Rotational delay", "ufs_d", "ms", 0);
&opt_input("Fragment size", "ufs_f", "bytes", 1);
&opt_input("Inode size", "ufs_i", "bytes", 0);
&opt_input("Reserved space", "ufs_m", "%", 1);
&opt_input("Rotational positions", "ufs_n", "", 0);
print "<tr> <td align=right><b>Optimize for</b></td>\n";
print "<td><select name=ufs_o>\n";
print "<option value=\"\"> Default\n";
print "<option value=space> Space\n";
print "<option value=time> Time\n";
print "</select></td>\n";
&opt_input("Disk speed", "ufs_r", "rpm", 0);
&opt_input("Filesystem size", "ufs_s", "sectors", 1);
&opt_input("Tracks / cylinder", "ufs_t", "", 0);
&opt_input("Max contiguous blocks", "ufs_cb", "", 1);
print "</table></td></tr></table><br>\n";

print "<div align=right>\n";
print "<input type=submit value=\"Create Filesystem\"></form>\n";
print "</div>\n";

print "<hr>\n";
&footer("", "disk list");

