#!/usr/local/bin/perl
# save_part.cgi
# Save changes to an existing or new partition

require './fdisk-lib.pl';
&error_setup($text{'save_err'});
&ReadParse();

@dlist = &list_disks();
$dinfo = $dlist[$in{'disk'}];
&can_edit_disk($dinfo->{'device'}) ||
	&error($text{'save_ecannot'});
@plist = &list_partitions($dinfo->{'device'});
if ($in{'delete'}) {
	# deleting a partition
	$pinfo = $plist[$in{'part'}];
	&delete_partition($dinfo->{'device'}, $pinfo->{'number'});
	&redirect("");
	}
elsif (!$in{'new'}) {
	# changing existing partition
	$pinfo = $plist[$in{'part'}];
	&change_type($dinfo->{'device'}, $pinfo->{'number'}, $in{'type'});
	&redirect("");
	}
else {
	# Adding new partition
	$in{start} =~ /^\d+$/ ||
		&error(&text('save_estart', $in{'start'}));
	$in{end} =~ /^\d+$/ ||
		&error(&text('save_eend', $in{'end'}));
	$in{start} >= $in{'min'} ||
		&error(&text('save_emin', $in{'min'}));
	$in{end} <= $in{'max'} ||
		&error(&text('save_emax', $in{'max'}));
	$in{start} < $in{end} ||
		&error($text{'save_eminmax'});

	# Check for partition overlap..
	foreach $pinfo (@plist) {
		if (($in{'start'} >= $pinfo->{'start'} &&
		     $in{'start'} <= $pinfo->{'end'} ||
		     $in{'end'} >= $pinfo->{'start'} &&
		     $in{'end'} <= $pinfo->{'end'}) &&
		     !($in{'new'}==2 && $pinfo->{'extended'})) {
			&error(&text('save_eoverlap', $pinfo->{'number'},
				     $pinfo->{'start'}, $pinfo->{'end'}));
			}
		}
	if ($in{'new'} == 3) {
		&create_extended($dinfo->{'device'}, $in{'newpart'},
				$in{'start'}, $in{'end'});
		}
	else {
		&create_partition($dinfo->{'device'}, $in{'newpart'},
				  $in{'start'}, $in{'end'}, $in{'type'});
		}
	if (&need_reboot($dinfo)) { &ask_reboot($dinfo); }
	else { &redirect(""); }
	}

# ask_reboot(disk)
# Display a form asking for a reboot
sub ask_reboot
{
&header($text{'reboot_title'}, "");
print "<hr>\n";
local $what = &text('select_device', uc($_[0]->{'type'}),
		    uc(substr($_[0]->{'device'}, -1)));
print "<b>",&text('reboot_why', $what),"</b> <p>\n";
print "<form action=reboot.cgi>\n";
print "<center><input type=submit value=\"$text{'reboot_ok'}\"></center>\n";
print "</form>\n";

print "<hr>\n";
&footer("", $text{'index_return'});
}

