#!/usr/local/bin/perl
# edit_share.cgi
# Display a form for editing a shared directory

require './dfs-lib.pl';
$s = $ARGV[0];

if ($s) { &header("Edit Share", "", "edit_share"); }
else { &header("Create Share", "", "create_share"); }
print "<hr>\n";

print "<form action=\"save_share.cgi\">\n";
if ($s) {
	print "<input type=hidden name=old value=\"$s\">\n";
	@sinfo = &get_share($s);
	}
print "<table border width=100%><tr $cb><td><table width=100%>\n";

print "<tr> <td>",&hlink("<b>Directory</b>","dir"),"</td>\n";
print "<td><input size=40 name=directory value=\"$sinfo[0]\">\n";
print &file_chooser_button("directory", 1);
print "</td>\n";

print "<tr> <td>",&hlink("<b>Description</b>","desc"),"</td>\n";
print "<td><input name=desc size=40 value=\"$sinfo[1]\"></td></tr>\n";

print "</table></td></tr></table><p>\n";
print "<table width=100% border>\n";
&parse_options($sinfo[2]);
print "<tr $tb>\n";
print "<td>",&hlink("<b>Read-only access</b>","ro"),"</td>\n";
print "<td>",&hlink("<b>Read-write access</b>","rw"),"</td>\n";
print "<td>",&hlink("<b>Root access</b>","root"),"</td> </tr>\n";

# $fn = "<font size=-2>"; $efn = "</font>";
printf "<tr $cb><td><input type=radio name=readonly value=0 %s> None<br>\n",
	defined($options{"ro"}) ? "" : "checked";
printf "<input type=radio name=readonly value=1 %s> All hosts<br>\n",
	defined($options{"ro"}) && $options{"ro"} eq "" ? "checked" : "";
printf "<input type=radio name=readonly value=2 %s> Listed hosts..<br>\n",
	$options{"ro"} ne "" ? "checked" : "";
printf "$fn<textarea name=rolist rows=8 cols=25>%s</textarea>$efn</td>\n",
	join("\n", split(/:/, $options{"ro"}));

printf "<td><input type=radio name=readwrite value=0 %s> None<br>\n",
	defined($options{"rw"}) ? "" : "checked";
printf "<input type=radio name=readwrite value=1 %s> All hosts<br>\n",
	defined($options{"rw"}) && $options{"rw"} eq "" ? "checked" : "";
printf "<input type=radio name=readwrite value=2 %s> Listed hosts..<br>\n",
	$options{"rw"} ne "" ? "checked" : "";
printf "$fn<textarea name=rwlist rows=8 cols=25>%s</textarea>$efn</td>\n",
	join("\n", split(/:/, $options{"rw"}));

printf "<td><input type=radio name=root value=0 %s> None<p>\n",
	defined($options{"root"}) ? "" : "checked";
printf "<input type=radio name=root value=2 %s> Listed hosts..<br>\n",
	$options{"root"} ne "" ? "checked" : "";
printf "$fn<textarea name=rtlist rows=8 cols=25>%s</textarea>$efn</td></tr>\n",
	join("\n", split(/:/, $options{"root"}));
print "</table><p>\n";

print "<table border width=100%>\n";
print "<tr $tb> <td><b>Share Options</b></td> </tr>\n";
print "<tr $cb> <td><table width=100%>\n";
print "<tr> <td>",&hlink("<b>Allow mounting of subdirs?</b>","sub"),"</td>\n";
printf "<td><input type=radio name=nosub value=0 %s> Yes\n",
	defined($options{"nosub"}) ? "" : "checked";
printf "<input type=radio name=nosub value=1 %s> No</td>\n",
	!defined($options{"nosub"}) ? "" : "checked";

print "<td>",&hlink("<b>Allow setuid files?</b>","suid"),"</td>\n";
printf "<td nowrap><input type=radio name=nosuid value=0 %s> Yes\n",
	defined($options{"nosuid"}) ? "" : "checked";
printf "<input type=radio name=nosuid value=1 %s> No</td> </tr>\n",
	!defined($options{"nosuid"}) ? "" : "checked";

print "<tr> <td>",&hlink("<b>Clients must use DES?</b>","des"),"</td>\n";
printf "<td nowrap><input type=radio name=secure value=1 %s> Yes\n",
	defined($options{"secure"}) ? "checked" : "";
printf "<input type=radio name=secure value=0 %s> No</td>\n",
	!defined($options{"secure"}) ? "checked" : "";

print "<td>",&hlink("<b>Clients must use kerberos?</b>","kerberos"),"</td>\n";
printf "<td nowrap><input type=radio name=kerberos value=1 %s> Yes\n",
	defined($options{"kerberos"}) ? "checked" : "";
printf "<input type=radio name=kerberos value=0 %s> No</td> </tr>\n",
	!defined($options{"kerberos"}) ? "checked" : "";

print "<tr> <td>",&hlink("<b>Anonymous user</b>","anon"),"</td> <td>\n";
printf "<input type=radio name=anon_m value=0 %s> Not set\n",
	defined($options{"anon"}) ? "" : "checked";
printf "<input type=radio name=anon_m value=1 %s> No access\n",
	$options{"anon"} == -1 ? "checked" : "";
$user = defined($options{"anon"}) && $options{"anon"} != -1 ?
		getpwuid($options{'anon'}) : undef;
printf "<input type=radio name=anon_m value=2 %s>\n",
	$user ? "checked" : "";
print "<input name=anon size=8 value=\"$user\"> ",
	&user_chooser_button("anon", 0),"</td>\n";

print "<td>",&hlink("<b>ACL OK option?</b>","aclok"),"</td>\n";
printf "<td nowrap><input type=radio name=aclok value=1 %s> Yes\n",
	defined($options{"aclok"}) ? "checked" : "";
printf "<input type=radio name=aclok value=0 %s> No</td> </tr>\n",
	!defined($options{"aclok"}) ? "checked" : "";

if ($gconfig{'os_version'} >= 7) {
	print "<tr> <td>",&hlink("<b>WebNFS share?</b>","public"),"</td>\n";
	printf "<td nowrap><input type=radio name=public value=1 %s> Yes\n",
		defined($options{"public"}) ? "checked" : "";
	printf "<input type=radio name=public value=0 %s> No</td>\n",
		!defined($options{"public"}) ? "checked" : "";

	print "<td>",&hlink("<b>WebNFS index file</b>","index"),"</td>\n";
	printf "<td nowrap><input type=radio name=index_def value=1 %s> None\n",
		defined($options{"index"}) ? "" : "checked";
	printf "<input type=radio name=index_def value=0 %s>\n",
		defined($options{"index"}) ? "checked" : "";
	printf "<input name=index size=10 value=\"%s\"></td> </tr>\n",
		$options{"index"};
	}

print "</table></td> </tr></table><p>\n";

if ($s ne "") {
	print "<table width=100%>\n";
	print "<tr> <td><input type=submit value=Save></td>\n";
	print "</form><form action=\"delete_share.cgi\">\n";
	print "<input type=hidden name=directory value=\"$s\">\n";
	print "<td align=right><input type=submit value=Delete></td> </tr>\n";
	print "</form></table><p>\n";
	}
else {
	print "<input type=submit value=Create></form><p>\n";
	}
print "<hr>\n";
&footer("", "list of shares");

