# dfs-lib.pl
# Common functions for managing dfstab files

do '../web-lib.pl';
&init_config();

# list_shares()
# Return a list of all the directories currently being shared
sub list_shares
{
local(@rv);
open(DFS, $config{dfstab_file});
while(<DFS>) {
	chop; s/#.*$//g;
	if (!/\S/) { next; }
	if (/-F\s+(\S+)/ && $1 ne "nfs") { next; }
	/(\/\S*)\s*$/; push(@rv, $1);
	}
close(DFS);
return @rv;
}


# get_share(directory)
# Return an array containing the following for some directory
#  directory, desc, options
sub get_share
{
local(@rv);
open(DFS, $config{dfstab_file});
while(<DFS>) {
	chop; s/#.*$//g;
	if (!/\S/) { next; }
	if (/(\/\S*)\s*$/ && $1 eq $_[0]) {
		# found matching share
		$rv[0] = $1;
		if (/-d\s+"([^"]+)"/) { $rv[1] = $1; }
		elsif (/-d\s+(\S+)/) { $rv[1] = $1; }
		if (/-o\s+"([^"]+)"/) { $rv[2] = $1; }
		elsif (/-o\s+(\S+)/) { $rv[2] = $1; }
		}
	}
close(DFS);
return @rv;
}


# create_share(directory, desc, options)
# Add a new share to the dfstab file
sub create_share
{
open(DFS, ">> $config{dfstab_file}");
print DFS "share";
if ($_[1]) { print DFS " -d \"$_[1]\""; }
if ($_[2]) { print DFS " -o $_[2]"; }
print DFS " $_[0]\n";
close(DFS);
}


# modify_share(old_directory, directory, desc, options)
# Modify an existing share
sub modify_share
{
local(@dfs);
open(DFS, $config{dfstab_file});
@dfs = <DFS>;
close(DFS);
open(DFS, "> $config{dfstab_file}");
foreach (@dfs) {
	chop; ($line = $_) =~ s/#.*$//g;
	if ($line =~ /(\/\S+)\s*$/ && $1 eq $_[0]) {
		# found share to change..
		/\s*(\S+)/;
		print DFS $1;
		if ($_[2]) { print DFS " -d \"$_[2]\""; }
		if ($_[3]) { print DFS " -o $_[3]"; }
		print DFS " $_[1]\n";
		}
	else {
		# leave this line alone
		print DFS "$_\n";
		}
	}
close(DFS);
}


# delete_share(directory)
# Delete the share for a particular directory
sub delete_share
{
local(@dfs);
open(DFS, $config{dfstab_file});
@dfs = <DFS>;
close(DFS);
open(DFS, "> $config{dfstab_file}");
foreach (@dfs) {
	chop; ($line = $_) =~ s/#.*$//g;
	if ($line !~ /(\/\S+)\s*$/ || $1 ne $_[0]) {
		# Leave this line alone
		print DFS "$_\n";
		}
	}
close(DFS);
}


# parse_options(string)
# Parse a mount options string like rw=foo,nosuid,... into the associative
# array %options. Parts with no value are given an empty string as the value
sub parse_options
{
local($opt);
undef(%options);
foreach $opt (split(/,/, $_[0])) {
	if ($opt =~ /^([^=]+)=(.*)$/) {
		$options{$1} = $2;
		}
	else {
		$options{$opt} = "";
		}
	}
}

# join_options()
# Returns a list of options from the %options array, in the form used in
# the dfstab file
sub join_options
{
local(@list, $k);
foreach $k (keys %options) {
	if ($options{$k} eq "") {
		push(@list, $k);
		}
	else {
		push(@list, "$k=$options{$k}");
		}
	}
return join(',', @list);
}

1;

