# mod_ssl.pl
# Defines editors for mod_ssl directives

sub mod_ssl_directives
{
local($rv);
$rv = [ [ 'SSLEngine', 0, 14, 'virtual', undef, 10 ],
	[ 'SSLProtocol', 0, 14, 'virtual', undef, 10 ],
	[ 'SSLCertificateFile', 0, 14, 'virtual', undef, 9 ],
	[ 'SSLCertificateKeyFile', 0, 14, 'virtual', undef, 8 ],
	[ 'SSLVerifyClient', 0, 14, 'virtual directory htaccess', undef, 7 ],
	[ 'SSLVerifyDepth', 0, 14, 'virtual directory htaccess', undef, 6 ],
	[ 'SSLLog', 0, 14, 'virtual', undef, 5 ],
	[ 'SSLRequireSSL', 0, 14, 'directory htaccess', undef, 4 ] ];
return &make_directives($rv, $_[0], "mod_ssl");
}

sub edit_SSLEngine
{
return (1, "Enable SSL?",
	&choice_input($_[0]->{'value'}, "SSLEngine", "",
		      "Yes,on", "No,off", "Default,"));
}
sub save_SSLEngine
{
return &parse_choice("SSLEngine");
}

@sslprotos = ("SSLv2", "SSLv3", "TLSv1");
sub edit_SSLProtocol
{
local ($rv, $p, %prot);
local @list = $_[0] ? @{$_[0]->{'words'}} : ("all");
foreach $p (@list) {
	if ($p =~ /^\+?all$/i) { map { $prot{lc($_)} = 1 } @sslprotos; }
	elsif ($p =~ /^\-all$/i) { undef(%prot); }
	elsif ($p =~ /^\-(\S+)/) { $prot{lc($1)} = 0; }
	elsif ($p =~ /^\+(\S+)/) { $prot{lc($1)} = 1; }
	}
foreach $p (@sslprotos) {
	$rv .= sprintf "<input type=checkbox name=SSLProtocol value=$p %s> $p ",
		$prot{lc($p)} ? "checked" : "";
	}
return (1, "SSL protocols", $rv);
}
sub save_SSLProtocol
{
local @sel = split(/\0/, $in{'SSLProtocol'});
if (scalar(@sel) == scalar(@sslprotos)) { return ( [ ] ); }
return ( [ join(" ", (map { "+$_" } @sel)) ] );
}

sub edit_SSLCertificateFile
{
return (2, "Certificate/private key file",
	&opt_input($_[0]->{'value'}, "SSLCertificateFile", "Default", 35).
	&file_chooser_button("SSLCertificateFile", 0));
}
sub save_SSLCertificateFile
{
return &parse_opt("SSLCertificateFile", '\S',
		  "Missing certificate/private key file");
}

sub edit_SSLCertificateKeyFile
{
return (2, "Private key file",
	&opt_input($_[0]->{'value'}, "SSLCertificateKeyFile", "Default", 35).
	&file_chooser_button("SSLCertificateKeyFile", 0));
}
sub save_SSLCertificateKeyFile
{
return &parse_opt("SSLCertificateKeyFile", '\S',
		  "Missing private key file");
}

sub edit_SSLVerifyClient
{
return (1, "Client SSL certificate",
	&select_input($_[0]->{'value'}, "SSLVerifyClient", "",
		      "Default,", "Not required,none", "Optional,optional",
		      "Required,require", "Optional no CA,optional_no_ca"));
}
sub save_SSLVerifyClient
{
return &parse_select("SSLVerifyClient");
}

sub edit_SSLVerifyDepth
{
return (1, "Client certificate depth",
	&opt_input($_[0]->{'value'}, "SSLVerifyDepth", "Default", 6));
}
sub save_SSLVerifyDepth
{
return &parse_opt("SSLVerifyDepth", '^\d+$',
		  "Certificate depth must be an integer");
}

sub edit_SSLLog
{
return (1, "SSL log file",
	&opt_input($_[0]->{'value'}, "SSLLog", "Default", 20));
}
sub save_SSLLog
{
return &parse_opt("SSLLog", '\S', "Missing SSL log file");
}

sub edit_SSLRequireSSL
{
return (1, "Allow SSL access only",
	&choice_input($_[0] ? 1 : 0, "SSLRequireSSL", 0, "Yes,1", "No,0"));
}
sub save_SSLRequireSSL
{
return $in{'SSLRequireSSL'} ? ( [ "" ] ) : ( [ ] );
}

