# mod_cgi.pl
# Defines editors CGI logging directives

sub mod_cgi_directives
{
local($rv);
$rv = [ [ 'ScriptLog', 0, 11, 'global', 1.2 ],
        [ 'ScriptLogLength', 0, 11, 'global', 1.2 ],
        [ 'ScriptLogBuffer', 0, 11, 'global', 1.2 ] ];
return &make_directives($rv, $_[0], "mod_cgi");
}

sub mod_cgi_handlers
{
return ("cgi-script");
}

sub edit_ScriptLog
{
return (1, "$text{'mod_cgi_0'}",
        &opt_input($_[0]->{'value'}, "ScriptLog", "$text{'mod_cgi_1'}", 20).
        &file_chooser_button("ScriptLog", 0));
}
sub save_ScriptLog
{
$in{'ScriptLog_def'} || &allowed_auth_file($in{'ScriptLog'}) ||
	&error($text{'mod_cgi_9'});
return &parse_opt("ScriptLog", '^\S+$', "$text{'mod_cgi_2'}");
}

sub edit_ScriptLogLength
{
return (1, "$text{'mod_cgi_3'}",
        &opt_input($_[0]->{'value'}, "ScriptLogLength", "$text{'mod_cgi_4'}", 8)."bytes");
}
sub save_ScriptLogLength
{
return &parse_opt("ScriptLogLength", '^\d+$', "$text{'mod_cgi_5'}");
}

sub edit_ScriptLogBuffer
{
return (1, "$text{'mod_cgi_6'}",
        &opt_input($_[0]->{'value'}, "ScriptLogBuffer", "$text{'mod_cgi_7'}", 6)."bytes");
}
sub save_ScriptLogBuffer
{
return &parse_opt("ScriptLogBuffer", '^\d+$', "$text{'mod_cgi_8'}");
}

1;

