# mod_auth_dbm.pl
# Defines editors for DBM file authentication directives

sub mod_auth_dbm_directives
{
local($rv);
$rv = [ [ 'AuthDBMUserFile AuthDBMGroupFile AuthDBMAuthoritative',
          0, 4, 'directory htaccess' ] ];
return &make_directives($rv, $_[0], "mod_auth_dbm");
}

sub edit_AuthDBMUserFile_AuthDBMGroupFile_AuthDBMAuthoritative
{
local($rv, $uf, $gf);
$uf = $_[0] ? 1 : 0; $gf = $_[1] ? 1 : 0;
$rv = "<table border><tr><td><table>\n";

$rv .= "<tr> <td><b>User DBM file</b></td> <td>".
       &opt_input($_[0]->{'value'}, "AuthDBMUserFile", "Default", 25).
       &file_chooser_button("AuthDBMUserFile", 0)."</td></tr>\n";

$rv .= "<tr> <td><b>Group DBM file</b></td> <td>".
       &opt_input($_[1]->{'value'}, "AuthDBMGroupFile", "Default", 25).
       &file_chooser_button("AuthDBMGroupFile", 0)."</td></tr>\n";

$rv .= "<tr> <td><b>Pass failures to next module?</b></td> <td>".
       &choice_input($_[2]->{'value'}, "AuthDBMAuthoritative", "",
       "Yes,off", "No,on", "Default,")."</td> </tr>\n";
$rv .= "</table></td></tr></table>\n";
return (2, "DBM file authentication", $rv);
}
sub save_AuthDBMUserFile_AuthDBMGroupFile_AuthDBMAuthoritative
{
local(@rv);
@rv = (&parse_opt("AuthDBMUserFile", '^\S+$', "Invalid user DBM file name") ,
       &parse_opt("AuthDBMGroupFile", '^\S+$', "Invalid group DBM file name") ,
       &parse_choice("AuthDBMAuthoritative", ""));
return @rv;
}

1;

