# mod_auth.pl
# Defines editors for text-file authentication directives

sub mod_auth_directives
{
local($rv);
$rv = [ [ 'AuthUserFile AuthGroupFile AuthAuthoritative', 0, 4, 'directory htaccess' ] ];
return &make_directives($rv, $_[0], "mod_auth");
}

sub edit_AuthUserFile_AuthGroupFile_AuthAuthoritative
{
local($rv, $uf, $gf);
$uf = $_[0] ? 1 : 0; $gf = $_[1] ? 1 : 0;
$rv = "<table border><tr><td><table>\n";

$rv .= "<tr> <td><b>$text{'mod_auth_0'}</b></td> <td>".
       &opt_input($_[0]->{'value'}, "AuthUserFile", "Default", 25).
       &file_chooser_button("AuthUserFile", 0).
       ($uf ? "&nbsp;<a href=\"list_authusers.cgi?file=".$_[0]->{'value'}.
       "&url=".&urlize(&this_url())."\">$text{'mod_auth_1'}</a>" : "")."</td></tr>\n";

$rv .= "<tr> <td><b>$text{'mod_auth_2'}</b></td> <td>".
       &opt_input($_[1]->{'value'}, "AuthGroupFile", "Default", 25).
       &file_chooser_button("AuthGroupFile", 0).
       ($gf ? "&nbsp;<a href=\"list_authgroups.cgi?file=".$_[1]->{'value'}.
       "&url=".&urlize(&this_url())."\">$text{'mod_auth_3'}</a>" : "")."</td></tr>\n";

$rv .= "<tr> <td><b>$text{'mod_auth_4'}</b></td> <td>".
       &choice_input($_[2]->{'value'}, "AuthAuthoritative", "",
       "Yes,off", "No,on", "Default,")."</td> </tr>\n";
$rv .= "</table></td></tr></table>\n";
return (2, "$text{'mod_auth_5'}", $rv);
}
sub save_AuthUserFile_AuthGroupFile_AuthAuthoritative
{
$in{'AuthUserFile_def'} || &allowed_auth_file($in{'AuthUserFile'}) ||
	&error($text{'mod_auth_6'});
$in{'AuthGroupFile_def'} || &allowed_auth_file($in{'AuthGroupFile'}) ||
	&error($text{'mod_auth_7'});
return (&parse_opt("AuthUserFile", '^\S+$', "Invalid user text file name") ,
        &parse_opt("AuthGroupFile", '^\S+$', "Invalid group text file name") ,
        &parse_choice("AuthAuthoritative", ""));
}

1;

