
#ifndef MENU_H
#define MENU_H


#ifndef SYSGLOBALS_H
#include <p2c/sysglobals.h>
#endif

#ifndef MYLIB_H
#include <p2c/mylib.h>
#endif

#ifndef TABLET_STUFF_H
#include "tablet_stuff.h"
#endif

#ifndef GR_STUFF_H
#include "gr_stuff.h"
#endif

#ifndef MAT_STUFF_H
#include "mat_stuff.h"
#endif

#ifndef CRT_STUFF_H
#include "crt_stuff.h"
#endif

#ifndef BB_STUFF_H
#include "bb_stuff.h"
#endif

#ifndef DATA_TYPES_H
#include "data_types.h"
#endif

#ifndef FFMAN_H
#include "ffman.h"
#endif

#ifndef PRIM_STUFF_H
#include "prim_stuff.h"
#endif


#define chHi            12

#define chOff           (chHi - 3)

#define menuSelectColor      4
#define menuSelectForeColor  3
#define menuBackColor        7
#define menuForeColor        0


typedef struct menuElem {
  struct menuElem *next;
  Char name[21];
  Char keq[4];   /* keyboard equivalent */
  boolean active, selected, changed;
  short color, ly, hy;
  void *proc;
} menuElem;

typedef struct menux {
  struct menux *next;
  Char title[21];
  menuElem *elems;
  short lx, hx, width, height;
  boolean selected;
} menux;

typedef struct region {
  Pixmap saveArea;
  int x, y, width, height;
} region;

typedef struct dialogRec {
  region savedRegion;
  short baseX, baseY, width, height, backColor;
} dialogRec;

typedef struct fixedColorRec{
  short x, y, wid;
} fixedColorRec;


#define maxFixed        23

typedef struct fixedMenuRec {
  short ly, hy;
  boolean sel, changed;
} fixedMenuRec;


extern boolean quit;
extern long botOfMenuBar, leftOfMenu, rightOfMenu;

extern menux *head, *curr;
extern Pixmap saveArea;
extern fixedColorRec fixedColor;
extern void *fixedMenuHandler;
extern fixedMenuRec fixedMenu[maxFixed];


extern void menu_clip_on(void);
extern void menu_clip_off(void);

extern void menu_show(void);
extern void clickOrDrag(m_tablet_info p);

extern void about(void);
extern void outString(long x, long y, long field, long foreColor, long backColor, Char *s);
extern void outCString(long x, long y, long field, long foreColor, long backColor, Char *s);
extern void rightStr(long x, long y, Char *s);
extern void saveRegion(long x1, long y1, long x2, long y2, region *r);
extern void restoreRegion(region *r);
extern void startDialog(dialogRec *d);

extern void finishDialog(dialogRec *d);
extern void initPull(void);
extern void startMenu(Char *name);
extern void addElem(Char *name, Char *key, void *proc);
extern void drawMenuBar(void);
extern void unpull(menux *mp);
extern void pull(menux *mp);

extern void pullUpdate(menux *mp);
extern void pullDownMenus(m_tablet_info p);
extern void drawFixedColors(void);
extern void updateFixedMenu(void);
extern void drawFixedMenu(void);

extern void doFixedMenu(m_tablet_info p);


#endif /*MENU_H*/
