
#ifndef MAT_STUFF_H
#define MAT_STUFF_H

#ifdef mips
#define const
#endif


typedef struct mat_matrix {
  long a, b, c, d, e, f, g;
} mat_matrix;

typedef struct mat_state {
  mat_matrix m;
} mat_state;

typedef double mat_r_array[91];


#define pi              3.141592654

extern const mat_matrix mat_ident_mat;

extern mat_matrix ctm;
extern double *rSinI;


extern void mat_init(void);
extern double cosD(long d);
extern double sinD(long d);
extern long aTan2I(double s, double c);
extern long mat_findRot(void);

extern long mat_newLength(long oldLen);
extern void mat_push(mat_state *m);

extern void mat_pop(mat_state *m);
extern void mat_print(void);
extern void mat_assign(void);
extern void mat_ident(void);
extern void mat_tran(long dx, long dy);
extern void mat_scale(long x, long y, long num);
extern void mat_rot(long c, long s);
extern void mat_transform(long x, long y, long *rx, long *ry);
extern void mat_rtransform(long x, long y, long *rx, long *ry);
extern void mat_untransform(long x, long y, long *rx, long *ry);
extern void mat_runtransform(long x, long y, long *rx, long *ry);

extern void mat_premult(mat_matrix *m);


#endif /*MAT_STUFF_H*/
