
#ifndef DISPMOD_H
#define DISPMOD_H

#include <p2c/newcrt.h>

#ifndef SYSGLOBALS_H
#include <p2c/sysglobals.h>
#endif


/*dispShort=-32768..32767;*/

typedef enum {
  d_msg, d_int, d_sint, d_str, d_enum, d_slist, d_char, d_array
} dispKinds;

typedef enum {
  d_nop, d_disp, d_highlight, d_inc, d_dec, d_set, d_assign
} dispOp;

typedef struct dispArrElem {
  short color;
  boolean select;
  Char *str;
} dispArrElem;

typedef dispArrElem dispArray[20];

typedef struct dispArrRec {
  short allocElem;   /* How many entries allocated */
  short numElem;   /* How many entries used */
  short x, y;   /* Position of display box */
  short w, h;   /* Width, height of display box */
  short top;   /* Current element # at top of display */
  dispArrElem *arr;
} dispArrRec;

typedef Char *dispSListArr[100];

typedef struct dispRec {
  struct dispRec *next;   /* Linked list. */
  short x, y, f;   /* Position and field. */
  void *proc;   /* Called whenever we do something. */
  short color;   /* To indicate selected status or just for fun. */
  boolean expert;   /* Only fit for experts to change? */
  dispKinds kind;
  union {
    Char *msgp;   /* Just text to display on the screen */
    struct {
      long *icur, ilow, ihigh;
    } U1;
    struct {
      short *shcur, shlow, shhigh;
    } U2;
    struct {
      Char *strCur, *strDef;
      short strDefCur, strMaxLen;
    } U3;
    struct {
      Char **sList;
      short sListMax, *sListCur;
    } U5;
    struct {
      dispArrRec *arrInfo;
      short arrPos;
    } U7;
    struct {
      Char *ecur, ehigh, elow;
      Char *enames;
    } U4;
  } UU;
} dispRec;


extern dispRec *dispHead;
extern short dispColor;
extern Char dispAssgn[256];
extern boolean dispExpert;


extern void dispBegin(void);
extern void dispRefresh(void);
extern void dispDisp(Char *terms, Char *exit, dispRec **curElem);
extern dispRec *dispMake(short x, short y, short f, void* proc, dispKinds kind);
extern void dispAddStr(short x, short y, short f, Char *c, Char *defaults);
extern void dispAddMsg(short x, short y, short f, Char *m);
extern void dispAddShort(short x, short y, short f, short *i, short low, short high);
extern void dispAddInt(short x, short y, short f, long *i, long low, long high);
extern void dispAddPtr(short x, short y, short f, void **i);
extern void dispAddEnum1(short x, short y, short f, Char *e, short high, Char *names);
extern void dispAddEnum2(short x, short y, short f, short *e, short high, Char *names);
extern void dispAddSList(short x, short y, short f, short *e, short high, Char **names);
extern void dispAddArr(short px, short py, short pw, short ph,
                       short num, short alloc, dispArrElem *ap);


#endif /*DISPMOD_H*/
