// generated by Fast Light User Interface Designer (fluid) version 2.0000

#include "exercise.h"
#include <FL/fl_draw.h>
#include <string.h>
#include <stdio.h>
#ifdef FLTK_2
#include <FL/Fl_Color_Chooser.H>
#include <FL/Fl_Font.H>
#else
#include <FL/fl_show_colormap.H>
#include <FL/Enumerations.H>
#define FL_NORMAL_BOX FL_DOWN_BOX
#define FL_THIN_BOX FL_THIN_DOWN_BOX
#define glyph_box down_box
#endif
static char row_head[3][50];
static char col_head[2][50];
static char cell_text[50];
static int style=-1;
static int style_section=0;
static int last_style_section=0;
static Fl_Boxtype box_list[] = {FL_FLAT_BOX,FL_UP_BOX,FL_DOWN_BOX,FL_NORMAL_BOX,FL_THIN_UP_BOX,FL_THIN_DOWN_BOX,FL_THIN_BOX,FL_ENGRAVED_BOX,FL_BORDER_BOX,FL_ROUND_UP_BOX,FL_ROUND_DOWN_BOX,FL_DIAMOND_UP_BOX,FL_DIAMOND_DOWN_BOX,FL_DIAMOND_BOX,FL_SHADOW_BOX,FL_ROUNDED_BOX,FL_OVAL_BOX};
static Fl_Align alignment_list[] = {Fl_Align(FL_ALIGN_TOP | FL_ALIGN_LEFT),FL_ALIGN_TOP,Fl_Align(FL_ALIGN_TOP | FL_ALIGN_RIGHT),FL_ALIGN_LEFT,Fl_Align(0),FL_ALIGN_RIGHT,Fl_Align(FL_ALIGN_BOTTOM | FL_ALIGN_LEFT),FL_ALIGN_BOTTOM,Fl_Align(FL_ALIGN_BOTTOM | FL_ALIGN_RIGHT)};
static Fl_Font font_list[] = {FL_HELVETICA,FL_HELVETICA_BOLD,FL_HELVETICA_ITALIC,FL_HELVETICA_BOLD_ITALIC,FL_COURIER,FL_COURIER_BOLD,FL_COURIER_ITALIC,FL_COURIER_BOLD_ITALIC,FL_TIMES,FL_TIMES_BOLD,FL_TIMES_ITALIC,FL_TIMES_BOLD_ITALIC,FL_SYMBOL,FL_SCREEN,FL_SCREEN_BOLD,FL_ZAPF_DINGBATS};

Flv_List2::Flv_List2(int x, int y, int w, int h, const char *l) : Flv_List(x,y,w,h,l) {
}

void Flv_List2::draw_row(int Offset, int &X, int &Y, int &W, int &H, int R) {
  char *buf[] =
	{	"Global","Title/label","Row footer",
		"Row header",
		"Current row",
		"Column footer", "Column header",
		"Current column", "Current cell"
	};
	Flv_List::draw_row(Offset,X,Y,W,H,R);
	fl_draw(buf[R], X-Offset, Y, W, H, FL_ALIGN_LEFT );
}

Flv_ListE::Flv_ListE(int x, int y, int w, int h, const char *l) : Flv_List(x,y,w,h,l) {
}

void Flv_ListE::draw_row(int Offset, int &X, int &Y, int &W, int &H, int R) {
  Flv_Style s;
	char *p;

	if (R<0)
		p = row_head[R+3];
	else
		p = cell_text;
	get_style(s,R);
	Flv_List::draw_row(Offset,X,Y,W,H,R);
	fl_draw(p, X-Offset, Y, W, H, s.align() );
}

Flv_TableE::Flv_TableE(int x, int y, int w, int h, const char *l) : Flv_Table(x,y,w,h,l) {
}

void Flv_TableE::draw_cell(int Offset, int &X, int &Y, int &W, int &H, int R, int C) {
  Flv_Style s;
	char *p;

	if (R<0 && C>-1)	//	Row header
		p = row_head[R+3];
	else if (C<0 && R>-1)	//	Column header
		p = col_head[C+2];
	else if (C<0 || R<0)		//	Corner
		p = "";
	else					//	Cell text
		p = cell_text;
	get_style(s,R,C);
	Flv_Table::draw_cell(Offset,X,Y,W,H,R, C);
	fl_draw(p, X-Offset, Y, W, H, s.align() );
}

Flv_List_Alignment::Flv_List_Alignment(int x, int y, int w, int h, const char *l) : Flv_List(x,y,w,h,l) {
}

void Flv_List_Alignment::draw_row(int Offset, int &X, int &Y, int &W, int &H, int R) {
  char *buf[] =
	{	"Top Left","Top Center","Top Right",
		"Center Left","Center Center","Center Right",
		"Bottom Left","Bottom Center","Bottom Right"
	};

	Flv_List::draw_row(Offset,X,Y,W,H,R);
	fl_draw(buf[R], X-Offset, Y, W, H, FL_ALIGN_LEFT );
}

Flv_List_Font::Flv_List_Font(int x, int y, int w, int h, const char *l) : Flv_List(x,y,w,h,l) {
}

void Flv_List_Font::draw_row(int Offset, int &X, int &Y, int &W, int &H, int R) {
  char *buf[] =
	{	"Helvetica",
		"Helvetica bold",
		"Helvetica italic",
		"Helvetica bold italic",
		"Courier",
		"Courier bold",
		"Courier italic",
		"Courier bold italic",
		"Times New Roman",
		"Times New Roman bold",
		"Times New Roman italic",
		"Times New Roman bold italic",
		"Symbol",
		"Screen",
		"Screen bold",
		"Zapf Dingbats"
	};

	Flv_List::draw_row(Offset,X,Y,W,H,R);
	fl_draw(buf[R], X-Offset, Y, W, H, FL_ALIGN_LEFT );
}

Flv_List_Frame::Flv_List_Frame(int x, int y, int w, int h, const char *l) : Flv_List(x,y,w,h,l) {
}

void Flv_List_Frame::draw_row(int Offset, int &X, int &Y, int &W, int &H, int R) {
  char *buf[] =
	{
		"Flat box",
		"Up box",
		"Down box",
		"Normal box",
		"Thin up box",
		"Thin down box",
		"Thin box",
		"Engraved box",
		"Border box",
		"Round up box",
		"Round down box",
		"Diamond up box",
		"Diamond down box",
		"Diamond box",
		"Shadow box",
		"Rounded box",
		"Oval box",
	};

	Flv_List::draw_row(Offset,X,Y,W,H,R);
	fl_draw(buf[R], X-Offset, Y, W, H, FL_ALIGN_LEFT );
}

Flv_List_Style_Section::Flv_List_Style_Section( int x, int y, int w, int h, const char *l ) : Flv_List(x,y,w,h,l) {
}

void Flv_List_Style_Section::draw_row(int Offset, int &X, int &Y, int &W, int &H, int R) {
  char *buf[] =
	{
		"Color",
		"Font",
		"Frame",
		"Alignment",
		"Size",
		"Misc",
		"Border"
	};

	Flv_List::draw_row(Offset,X,Y,W,H,R);
	fl_draw(buf[R], X-Offset, Y, W, H, FL_ALIGN_LEFT );
}

Fl_Window *win=(Fl_Window *)0;

Fl_Group *Rows_Value=(Fl_Group *)0;

Fl_Group *Cols_Value=(Fl_Group *)0;

Fl_Group *Row_Width_Value=(Fl_Group *)0;

Fl_Input *title=(Fl_Input *)0;

static void cb_title(Fl_Input*, void*) {
  if (title->value() && *(title->value()))
	{
		strcpy( row_head[0], title->value() );
		wintable->label(row_head[0]);
		winlist->label(row_head[0]);
	} else
	{
		wintable->label(0);
		winlist->label(0);
	}
	wintable->damage(FL_DAMAGE_CHILD);
	winlist->damage(FL_DAMAGE_CHILD);
}

Fl_Input *row_header=(Fl_Input *)0;

static void cb_row_header(Fl_Input*, void*) {
  if (row_header->value() && *(row_header->value()))
		strcpy( row_head[2], row_header->value() );
	else
		row_head[2][0] = 0;
	wintable->damage(FL_DAMAGE_CHILD);
	winlist->damage(FL_DAMAGE_CHILD);
}

Fl_Input *row_footer=(Fl_Input *)0;

static void cb_row_footer(Fl_Input*, void*) {
  if (row_footer->value() && *(row_footer->value()))
		strcpy( row_head[1], row_footer->value() );
	else
		row_head[1][0] = 0;
	wintable->damage(FL_DAMAGE_CHILD);
	winlist->damage(FL_DAMAGE_CHILD);
}

Fl_Input *col_header=(Fl_Input *)0;

static void cb_col_header(Fl_Input*, void*) {
  if (col_header->value() && *(col_header->value()))
		strcpy( col_head[1], col_header->value() );
	else
		col_head[1][0] = 0;
	wintable->damage(FL_DAMAGE_CHILD);
	winlist->damage(FL_DAMAGE_CHILD);
}

Fl_Input *col_footer=(Fl_Input *)0;

static void cb_col_footer(Fl_Input*, void*) {
  if (col_footer->value() && *(col_footer->value()))
		strcpy( col_head[0], col_footer->value() );
	else
		col_head[0][0] = 0;
	wintable->damage(FL_DAMAGE_CHILD);
	winlist->damage(FL_DAMAGE_CHILD);
}

Fl_Input *cell=(Fl_Input *)0;

static void cb_cell(Fl_Input*, void*) {
  if (cell->value() && *(cell->value()))
		strcpy( cell_text, cell->value() );
	else
		cell_text[0] = 0;
	wintable->damage(FL_DAMAGE_CHILD);
	winlist->damage(FL_DAMAGE_CHILD);
}

Fl_Output *table_loc=(Fl_Output *)0;

Fl_Output *list_loc=(Fl_Output *)0;

Flv_List2 *Style_Type=(Flv_List2 *)0;

Flv_List_Style_Section *Style_Section=(Flv_List_Style_Section *)0;

Fl_Group *Color_Group=(Fl_Group *)0;

Fl_Button *Foreground_Style_Clear=(Fl_Button *)0;

static void cb_Foreground_Style_Clear(Fl_Button*, void*) {
  Flv_Style *s = read_table_style();

	if (s)
	{
		s->clear_foreground();
		s = read_list_style();
		if (s)
			s->clear_foreground();
		wintable->row_style.compact();
		wintable->col_style.compact();
		update_style_info();
		wintable->redraw();
		winlist->redraw();
	};
}

Fl_Group *Foreground_Style_Defined=(Fl_Group *)0;

Fl_Group *Foreground_Style_Value=(Fl_Group *)0;

static void cb_Background(Fl_Button*, void*) {
  int c;
	Fl_Color nc;
	Flv_Style *s;

	nc = Background_Style_Value->color();
#ifndef FLTK_2
	nc = fl_show_colormap(nc);
	c = 1;
#else
	c = fl_color_chooser( "Background", nc );
#endif
	if (c)
	{
		Background_Style_Value->color(nc);
		s = write_table_style();
		if (s)
			s->background(nc);
		s  = write_list_style();
		if (s)
			s->background(nc);
		wintable->redraw();
		winlist->redraw();
		update_style_info();
	};
}

Fl_Button *Background_Style_Clear=(Fl_Button *)0;

static void cb_Background_Style_Clear(Fl_Button*, void*) {
  Flv_Style *s = read_table_style();

	if (s)
	{
		s->clear_background();
		s = read_list_style();
		if (s)
			s->clear_background();
		wintable->row_style.compact();
		wintable->col_style.compact();
		update_style_info();
		wintable->redraw();
		winlist->redraw();
	};
}

Fl_Group *Background_Style_Defined=(Fl_Group *)0;

Fl_Group *Background_Style_Value=(Fl_Group *)0;

Fl_Group *Font_Group=(Fl_Group *)0;

Flv_List_Font *Font_Style=(Flv_List_Font *)0;

Fl_Button *Font_Style_Clear=(Fl_Button *)0;

static void cb_Font_Style_Clear(Fl_Button*, void*) {
  Flv_Style *s = read_table_style();

	if (style<0)
		return;
	if (s)
	{
		s->clear_font();
		s = read_list_style();
		if (s)
			s->clear_font();
		winlist->redraw();
		wintable->row_style.compact();
		wintable->col_style.compact();
		update_style_info();
		wintable->redraw();
	};
}

Fl_Group *Font_Style_Defined=(Fl_Group *)0;

Fl_Roller *Font_Size_Style=(Fl_Roller *)0;

Fl_Group *Font_Size_Style_Value=(Fl_Group *)0;

Fl_Button *Font_Size_Style_Clear=(Fl_Button *)0;

static void cb_Font_Size_Style_Clear(Fl_Button*, void*) {
  Flv_Style *s = read_table_style();

	if (style<0)
		return;
	if (s)
	{
		s->clear_font_size();
		s = read_list_style();
		if (s)
			s->clear_font_size();
		winlist->redraw();
		wintable->row_style.compact();
		wintable->col_style.compact();
		update_style_info();
		wintable->redraw();
	};
}

Fl_Group *Font_Size_Style_Defined=(Fl_Group *)0;

Fl_Group *Frame_Group=(Fl_Group *)0;

Fl_Button *Frame_Style_Clear=(Fl_Button *)0;

static void cb_Frame_Style_Clear(Fl_Button*, void*) {
  Flv_Style *s = read_table_style();

	if (style<0)
		return;
	if (s)
	{
		s->clear_frame();
		s = read_list_style();
		if (s)
			s->clear_frame();
		winlist->redraw();
		wintable->row_style.compact();
		wintable->col_style.compact();
		update_style_info();
		wintable->redraw();
	};
}

Fl_Group *Frame_Style_Defined=(Fl_Group *)0;

Flv_List_Frame *Frame_Style=(Flv_List_Frame *)0;

Fl_Group *Alignment_Group=(Fl_Group *)0;

Fl_Button *Alignment_Style_Clear=(Fl_Button *)0;

static void cb_Alignment_Style_Clear(Fl_Button*, void*) {
  Flv_Style *s = read_table_style();

	if (style<0)
		return;

	if (s)
	{
		s->clear_align();
		s = read_list_style();
		if (s)
			s->clear_align();
		winlist->redraw();
		update_style_info();
		wintable->redraw();
	};
}

Fl_Group *Alignment_Style_Defined=(Fl_Group *)0;

Flv_List_Alignment *Alignment_Style=(Flv_List_Alignment *)0;

Fl_Group *Size_Group=(Fl_Group *)0;

Fl_Roller *Width_Style=(Fl_Roller *)0;

Fl_Button *Width_Style_Clear=(Fl_Button *)0;

static void cb_Width_Style_Clear(Fl_Button*, void*) {
  Flv_Style *s = read_table_style();

	if (style<0)
		return;
	if (s)
	{
		s->clear_width();
		s = read_list_style();
		if (s)
			s->clear_width();
		winlist->redraw();
		wintable->row_style.compact();
		wintable->col_style.compact();
		update_style_info();
		wintable->redraw();
	};
}

Fl_Group *Width_Style_Value=(Fl_Group *)0;

Fl_Group *Width_Style_Defined=(Fl_Group *)0;

Fl_Group *Height_Style_Defined=(Fl_Group *)0;

Fl_Roller *Height_Style=(Fl_Roller *)0;

Fl_Button *Height_Style_Clear=(Fl_Button *)0;

static void cb_Height_Style_Clear(Fl_Button*, void*) {
  Flv_Style *s = read_table_style();

	if (style<0)
		return;
	if (s)
	{
		s->clear_height();
		s = read_list_style();
		if (s)
			s->clear_height();
		winlist->redraw();
		wintable->row_style.compact();
		wintable->col_style.compact();
		update_style_info();
		wintable->redraw();
	};
}

Fl_Group *Height_Style_Value=(Fl_Group *)0;

Fl_Group *Misc_Group=(Fl_Group *)0;

Fl_Group *Resizable_Style_Defined=(Fl_Group *)0;

Fl_Check_Button *Locked_Style=(Fl_Check_Button *)0;

Fl_Check_Button *Resizable_Style=(Fl_Check_Button *)0;

Fl_Button *Resizable_Style_Clear=(Fl_Button *)0;

static void cb_Resizable_Style_Clear(Fl_Button*, void*) {
  Flv_Style *s = read_table_style();

	if (style<0)
		return;
	if (s)
	{
		s->clear_resizable();
		s = read_list_style();
		if (s)
			s->clear_resizable();
		winlist->redraw();
		wintable->row_style.compact();
		wintable->col_style.compact();
		update_style_info();
		wintable->redraw();
	};
}

Fl_Button *Locked_Style_Clear=(Fl_Button *)0;

static void cb_Locked_Style_Clear(Fl_Button*, void*) {
  Flv_Style *s = read_table_style();

	if (style<0)
		return;
	if (s)
	{
		s->clear_locked();
		wintable->row_style.compact();
		wintable->col_style.compact();
		update_style_info();
		wintable->redraw();
	};
}

Fl_Group *Locked_Style_Defined=(Fl_Group *)0;

Fl_Group *Border_Group=(Fl_Group *)0;

Fl_Check_Button *Border_Inner_Left_Style=(Fl_Check_Button *)0;

Fl_Check_Button *Border_Inner_Bottom_Style=(Fl_Check_Button *)0;

Fl_Check_Button *Border_Inner_Right_Style=(Fl_Check_Button *)0;

Fl_Check_Button *Border_Top_Style=(Fl_Check_Button *)0;

Fl_Check_Button *Border_Inner_Top_Style=(Fl_Check_Button *)0;

Fl_Check_Button *Border_Right_Style=(Fl_Check_Button *)0;

Fl_Check_Button *Border_Bottom_Style=(Fl_Check_Button *)0;

Fl_Check_Button *Border_Left_Style=(Fl_Check_Button *)0;

Fl_Group *Border_Color_Style_Value=(Fl_Group *)0;

Fl_Button *Border_Color_Style=(Fl_Button *)0;

static void cb_Border_Color_Style(Fl_Button*, void*) {
  int c;
	Fl_Color nc;
	Flv_Style *s;

	nc = Border_Color_Style_Value->color();
#ifndef FLTK_2
	nc = fl_show_colormap(nc);
	c = 1;
#else
	c = fl_color_chooser( "Border", nc );
#endif
	if (c)
	{
		Border_Color_Style_Value->color(nc);
		s = write_table_style();
		if (s)
			s->border_color(nc);
		s = write_list_style();
		if (s)
			s->border_color(nc);
		update_style_info();
		wintable->redraw();
		winlist->redraw();
	};
}

Fl_Button *Border_Color_Style_Clear=(Fl_Button *)0;

static void cb_Border_Color_Style_Clear(Fl_Button*, void*) {
  Flv_Style *s = read_table_style();

	if (s)
	{
		s->clear_border_color();
		s = read_list_style();
		if (s)
			s->clear_border_color();
		winlist->redraw();
		wintable->row_style.compact();
		wintable->col_style.compact();
		update_style_info();
		wintable->redraw();
	};
}

Fl_Group *Border_Color_Style_Defined=(Fl_Group *)0;

Fl_Button *Border_Style_Clear=(Fl_Button *)0;

static void cb_Border_Style_Clear(Fl_Button*, void*) {
  Flv_Style *s = read_table_style();

	if (s)
	{
		s->clear_border();
		s = read_list_style();
		if (s)
			s->clear_border();
		winlist->redraw();
		wintable->row_style.compact();
		wintable->col_style.compact();
		update_style_info();
		wintable->redraw();
	};
}

Fl_Group *Border_Style_Defined=(Fl_Group *)0;

Fl_Roller *Border_Spacing_Style=(Fl_Roller *)0;

Fl_Button *Border_Spacing_Style_Clear=(Fl_Button *)0;

static void cb_Border_Spacing_Style_Clear(Fl_Button*, void*) {
  Flv_Style *s = read_table_style();

	if (style<0)
		return;
	if (s)
	{
		s->clear_border_spacing();
		s = read_list_style();
		if (s)
			s->clear_border_spacing();
		winlist->redraw();
		wintable->row_style.compact();
		wintable->col_style.compact();
		update_style_info();
		wintable->redraw();
	};
}

Fl_Group *Border_Spacing_Style_Value=(Fl_Group *)0;

Fl_Group *Border_Spacing_Style_Defined=(Fl_Group *)0;

static void cb_Clear(Fl_Button*, void*) {
  Flv_Style *s = read_table_style();

	if (s)
	{
		s->clear_all();
		wintable->row_style.compact();
		wintable->col_style.compact();
		update_style_info();
		wintable->redraw();
	};
}

static void cb_Clear1(Fl_Button*, void*) {
  wintable->global_style.clear_all();
	wintable->row_style.release();
	wintable->col_style.release();
	update_style_info();
	wintable->redraw();
}

Fl_Group *Style_Type_Defined=(Fl_Group *)0;

static void cb_Done(Fl_Button*, void*) {
  if (win_table)
		delete win_table;
	win_table = 0;
	if (win_list)
		delete win_list;
	win_list = 0;
	if (win)
		delete win;
	win = 0;
}

Fl_Window *win_table=(Fl_Window *)0;

Flv_TableE *wintable=(Flv_TableE *)0;

Fl_Window *win_list=(Fl_Window *)0;

Flv_ListE *winlist=(Flv_ListE *)0;

Fl_Window* make_window() {
  Fl_Window* w;
  { Fl_Window* o = win = new Fl_Window(641, 445, "Widget exerciser");
    { Fl_Group* o = new Fl_Group(70, 10, 90, 70, "Row ");
      o->box(FL_THIN_DOWN_BOX);
      o->align(FL_ALIGN_LEFT);
      { Fl_Check_Button* o = new Fl_Check_Button(75, 15, 75, 20, "header");
        o->box(FL_FLAT_BOX);
        o->glyph_box(FL_THIN_DOWN_BOX);
        o->callback((Fl_Callback*)row_header_callback);
        o->label_size(12);
      }
      { Fl_Check_Button* o = new Fl_Check_Button(75, 35, 75, 20, "footer");
        o->box(FL_FLAT_BOX);
        o->glyph_box(FL_THIN_DOWN_BOX);
        o->callback((Fl_Callback*)row_footer_callback);
        o->label_size(12);
      }
      { Fl_Check_Button* o = new Fl_Check_Button(75, 55, 75, 20, "divider");
        o->box(FL_FLAT_BOX);
        o->glyph_box(FL_THIN_DOWN_BOX);
        o->callback((Fl_Callback*)row_divider_callback);
        o->label_size(12);
      }
      o->label_size(12);
      o->end();
    }
    { Fl_Group* o = new Fl_Group(205, 10, 90, 70, "Cols ");
      o->box(FL_THIN_DOWN_BOX);
      o->align(FL_ALIGN_LEFT);
      { Fl_Check_Button* o = new Fl_Check_Button(210, 15, 75, 20, "header");
        o->box(FL_FLAT_BOX);
        o->glyph_box(FL_THIN_DOWN_BOX);
        o->callback((Fl_Callback*)col_header_callback);
        o->label_size(12);
      }
      { Fl_Check_Button* o = new Fl_Check_Button(210, 35, 75, 20, "footer");
        o->box(FL_FLAT_BOX);
        o->glyph_box(FL_THIN_DOWN_BOX);
        o->callback((Fl_Callback*)col_footer_callback);
        o->label_size(12);
      }
      { Fl_Check_Button* o = new Fl_Check_Button(210, 55, 75, 20, "divider");
        o->box(FL_FLAT_BOX);
        o->glyph_box(FL_THIN_DOWN_BOX);
        o->callback((Fl_Callback*)col_divider_callback);
        o->label_size(12);
      }
      o->label_size(12);
      o->end();
    }
    { Fl_Group* o = new Fl_Group(370, 10, 90, 70, "Scroll bars");
      o->box(FL_THIN_DOWN_BOX);
      o->align(FL_ALIGN_LEFT);
      { Fl_Check_Button* o = new Fl_Check_Button(375, 15, 75, 20, " vertical");
        o->box(FL_FLAT_BOX);
        o->glyph_box(FL_THIN_DOWN_BOX);
        o->callback((Fl_Callback*)vertical_callback);
        o->label_size(12);
      }
      { Fl_Check_Button* o = new Fl_Check_Button(375, 35, 75, 20, " horizontal");
        o->box(FL_FLAT_BOX);
        o->glyph_box(FL_THIN_DOWN_BOX);
        o->callback((Fl_Callback*)horizontal_callback);
        o->label_size(12);
      }
      { Fl_Check_Button* o = new Fl_Check_Button(375, 55, 75, 20, " always");
        o->box(FL_FLAT_BOX);
        o->glyph_box(FL_THIN_DOWN_BOX);
        o->callback((Fl_Callback*)always_callback);
        o->label_size(12);
      }
      o->label_size(12);
      o->end();
    }
    { Fl_Roller* o = new Fl_Roller(70, 90, 90, 20, "Rows ");
      o->type(1);
      o->maximum(80);
      o->step(0.5);
      o->value(10);
      o->callback((Fl_Callback*)rows_callback);
      o->align(FL_ALIGN_LEFT);
      o->label_size(12);
    }
    { Fl_Group* o = Rows_Value = new Fl_Group(165, 90, 30, 20, "10");
      o->box(FL_THIN_DOWN_BOX);
      o->align(FL_ALIGN_CENTER);
      o->label_size(12);
      o->end();
    }
    { Fl_Roller* o = new Fl_Roller(70, 110, 90, 20, "Cols ");
      o->type(1);
      o->maximum(80);
      o->step(0.5);
      o->value(10);
      o->callback((Fl_Callback*)cols_callback);
      o->align(FL_ALIGN_LEFT);
      o->label_size(12);
    }
    { Fl_Group* o = Cols_Value = new Fl_Group(165, 110, 30, 20, "10");
      o->box(FL_THIN_DOWN_BOX);
      o->align(FL_ALIGN_CENTER);
      o->label_size(12);
      o->end();
    }
    { Fl_Roller* o = new Fl_Roller(70, 140, 90, 20, "Row width ");
      o->type(1);
      o->maximum(300);
      o->step(1);
      o->callback((Fl_Callback*)row_width_callback);
      o->align(FL_ALIGN_LEFT);
      o->label_size(12);
    }
    { Fl_Group* o = Row_Width_Value = new Fl_Group(165, 140, 30, 20, "0");
      o->box(FL_THIN_DOWN_BOX);
      o->align(FL_ALIGN_CENTER);
      o->label_size(12);
      o->end();
    }
    { Fl_Check_Button* o = new Fl_Check_Button(340, 85, 20, 20, "Multi-select");
      o->glyph_box(FL_THIN_DOWN_BOX);
      o->callback((Fl_Callback*)multi_select_callback);
      o->align(FL_ALIGN_LEFT);
      o->label_size(12);
    }
    { Fl_Check_Button* o = new Fl_Check_Button(340, 105, 20, 20, "Row select");
      o->glyph_box(FL_THIN_DOWN_BOX);
      o->callback((Fl_Callback*)row_select_callback);
      o->align(FL_ALIGN_LEFT);
      o->label_size(12);
    }
    { Fl_Check_Button* o = new Fl_Check_Button(340, 125, 20, 20, "Persistant selection ");
      o->glyph_box(FL_THIN_DOWN_BOX);
      o->value(1);
      o->callback((Fl_Callback*)persist_select_callback);
      o->align(FL_ALIGN_LEFT);
      o->label_size(12);
    }
    { Fl_Check_Button* o = new Fl_Check_Button(340, 145, 20, 20, "Full widget area resizing");
      o->glyph_box(FL_THIN_DOWN_BOX);
      o->callback((Fl_Callback*)full_resize_callback);
      o->align(FL_ALIGN_LEFT);
      o->label_size(12);
    }
    { Fl_Input* o = title = new Fl_Input(540, 10, 90, 20, "Title ");
      o->callback((Fl_Callback*)cb_title);
      o->when(FL_WHEN_CHANGED);
      o->label_size(12);
    }
    { Fl_Input* o = row_header = new Fl_Input(540, 35, 90, 20, "Row header");
      o->callback((Fl_Callback*)cb_row_header);
      o->when(FL_WHEN_CHANGED);
      o->label_size(12);
    }
    { Fl_Input* o = row_footer = new Fl_Input(540, 60, 90, 20, "Row footer");
      o->callback((Fl_Callback*)cb_row_footer);
      o->when(FL_WHEN_CHANGED);
      o->label_size(12);
    }
    { Fl_Input* o = col_header = new Fl_Input(540, 85, 90, 20, "Col header");
      o->callback((Fl_Callback*)cb_col_header);
      o->when(FL_WHEN_CHANGED);
      o->label_size(12);
    }
    { Fl_Input* o = col_footer = new Fl_Input(540, 110, 90, 20, "Col footer");
      o->callback((Fl_Callback*)cb_col_footer);
      o->when(FL_WHEN_CHANGED);
      o->label_size(12);
    }
    { Fl_Input* o = cell = new Fl_Input(540, 135, 90, 20, "Cell");
      o->callback((Fl_Callback*)cb_cell);
      o->when(FL_WHEN_CHANGED);
      o->label_size(12);
    }
    { Fl_Output* o = table_loc = new Fl_Output(585, 160, 45, 20, "Table");
      o->label_size(12);
    }
    { Fl_Output* o = list_loc = new Fl_Output(495, 160, 45, 20, "List");
      o->label_size(12);
    }
    { Fl_Group* o = new Fl_Group(370, 95, 90, 90, "FLVW");
      o->box(FL_EMBOSSED_BOX);
      o->label_type(FL_ENGRAVED_LABEL);
      o->align(FL_ALIGN_TOP|FL_ALIGN_INSIDE);
      { Fl_Group* o = new Fl_Group(375, 165, 75, 15, "0.0.1");
        o->align(FL_ALIGN_CENTER);
        o->label_size(12);
        o->end();
      }
      { Fl_Group* o = new Fl_Group(375, 115, 75, 15, "Exerciser");
        o->align(FL_ALIGN_CENTER);
        o->label_size(12);
        o->end();
      }
      { Fl_Group* o = new Fl_Group(375, 130, 80, 15, "Program");
        o->align(FL_ALIGN_CENTER);
        o->label_size(12);
        o->end();
      }
      { Fl_Group* o = new Fl_Group(375, 145, 80, 15, "version");
        o->align(FL_ALIGN_CENTER);
        o->label_size(12);
        o->end();
      }
      o->end();
    }
    { Flv_List2* o = Style_Type = new Flv_List2(10, 205, 165, 185, "Style Type");
      o->box(FL_THIN_DOWN_BOX);
      o->callback((Fl_Callback*)style_type_callback);
      o->align(FL_ALIGN_TOP|FL_ALIGN_INSIDE);
      o->rows(9);
      o->has_scrollbar(FLVS_VERTICAL);
      o->label("Style type");
      o->end();
    }
    { Flv_List_Style_Section* o = Style_Section = new Flv_List_Style_Section(185, 205, 165, 185, "Style Section");
      o->box(FL_THIN_DOWN_BOX);
      o->callback((Fl_Callback*)style_section_callback);
      o->align(FL_ALIGN_TOP|FL_ALIGN_INSIDE);
      o->rows(7);
      o->has_scrollbar(FLVS_VERTICAL);
      o->label("Styles section");
      o->end();
    }
    { Fl_Group* o = Color_Group = new Fl_Group(360, 205, 265, 185);
      o->box(FL_THIN_DOWN_BOX);
      { Fl_Button* o = new Fl_Button(370, 215, 95, 25, "&Foreground");
        o->callback((Fl_Callback*)Foreground_callback);
        o->label_size(12);
      }
      { Fl_Button* o = Foreground_Style_Clear = new Fl_Button(370, 245, 45, 25, "Clear");
        o->callback((Fl_Callback*)cb_Foreground_Style_Clear);
        o->label_size(12);
      }
      { Fl_Group* o = Foreground_Style_Defined = new Fl_Group(420, 245, 20, 25, "U");
        o->box(FL_DOWN_BOX);
        o->label_type(FL_ENGRAVED_LABEL);
        o->align(FL_ALIGN_CENTER);
        o->label_size(12);
        o->end();
      }
      { Fl_Group* o = Foreground_Style_Value = new Fl_Group(445, 245, 20, 25);
        o->box(FL_THIN_DOWN_BOX);
        o->label_size(12);
        o->end();
      }
      { Fl_Button* o = new Fl_Button(370, 325, 95, 25, "&Background");
        o->callback((Fl_Callback*)cb_Background);
        o->label_size(12);
      }
      { Fl_Button* o = Background_Style_Clear = new Fl_Button(370, 355, 45, 25, "Clear");
        o->callback((Fl_Callback*)cb_Background_Style_Clear);
        o->label_size(12);
      }
      { Fl_Group* o = Background_Style_Defined = new Fl_Group(420, 355, 20, 25, "U");
        o->box(FL_DOWN_BOX);
        o->label_type(FL_ENGRAVED_LABEL);
        o->align(FL_ALIGN_CENTER);
        o->label_size(12);
        o->end();
      }
      { Fl_Group* o = Background_Style_Value = new Fl_Group(445, 355, 20, 25);
        o->box(FL_THIN_DOWN_BOX);
        o->label_size(12);
        o->end();
      }
      o->end();
    }
    { Fl_Group* o = Font_Group = new Fl_Group(360, 205, 270, 185);
      o->box(FL_THIN_DOWN_BOX);
      o->hide();
      { Flv_List_Font* o = Font_Style = new Flv_List_Font(370, 215, 165, 140, "Font");
        o->box(FL_THIN_DOWN_BOX);
        o->callback((Fl_Callback*)font_style_callback);
        o->align(FL_ALIGN_TOP|FL_ALIGN_INSIDE);
        o->rows(16);
        o->has_scrollbar(FLVS_VERTICAL);
        o->label("Font List");
        o->label_size(12);
        o->end();
      }
      { Fl_Button* o = Font_Style_Clear = new Fl_Button(370, 360, 45, 25, "Clear");
        o->callback((Fl_Callback*)cb_Font_Style_Clear);
        o->label_size(12);
      }
      { Fl_Group* o = Font_Style_Defined = new Fl_Group(420, 360, 20, 25, "U");
        o->box(FL_DOWN_BOX);
        o->label_type(FL_ENGRAVED_LABEL);
        o->align(FL_ALIGN_CENTER);
        o->label_size(12);
        o->end();
      }
      { Fl_Roller* o = Font_Size_Style = new Fl_Roller(555, 225, 25, 70, "Font size");
        o->minimum(8);
        o->maximum(18);
        o->step(1);
        o->callback((Fl_Callback*)font_size_callback);
        o->align(FL_ALIGN_TOP);
        o->label_size(12);
      }
      { Fl_Group* o = Font_Size_Style_Value = new Fl_Group(585, 245, 35, 25, "0");
        o->box(FL_THIN_DOWN_BOX);
        o->align(FL_ALIGN_CENTER|FL_ALIGN_INSIDE);
        o->label_size(12);
        o->end();
      }
      { Fl_Button* o = Font_Size_Style_Clear = new Fl_Button(555, 300, 45, 25, "Clear");
        o->callback((Fl_Callback*)cb_Font_Size_Style_Clear);
        o->label_size(12);
      }
      { Fl_Group* o = Font_Size_Style_Defined = new Fl_Group(605, 300, 20, 25, "U");
        o->box(FL_DOWN_BOX);
        o->label_type(FL_ENGRAVED_LABEL);
        o->align(FL_ALIGN_CENTER);
        o->label_size(12);
        o->end();
      }
      o->end();
    }
    { Fl_Group* o = Frame_Group = new Fl_Group(360, 205, 270, 185);
      o->box(FL_THIN_DOWN_BOX);
      o->hide();
      { Fl_Button* o = Frame_Style_Clear = new Fl_Button(370, 360, 45, 25, "Clear");
        o->callback((Fl_Callback*)cb_Frame_Style_Clear);
        o->label_size(12);
      }
      { Fl_Group* o = Frame_Style_Defined = new Fl_Group(420, 360, 20, 25, "U");
        o->box(FL_DOWN_BOX);
        o->label_type(FL_ENGRAVED_LABEL);
        o->align(FL_ALIGN_CENTER);
        o->label_size(12);
        o->end();
      }
      { Flv_List_Frame* o = Frame_Style = new Flv_List_Frame(370, 215, 165, 140, "Frame");
        o->box(FL_THIN_DOWN_BOX);
        o->callback((Fl_Callback*)frame_style_callback);
        o->align(FL_ALIGN_TOP|FL_ALIGN_INSIDE);
        o->rows(17);
        o->has_scrollbar(FLVS_VERTICAL);
        o->label_size(12);
        o->end();
      }
      o->end();
    }
    { Fl_Group* o = Alignment_Group = new Fl_Group(360, 205, 270, 185);
      o->box(FL_THIN_DOWN_BOX);
      o->hide();
      { Fl_Button* o = Alignment_Style_Clear = new Fl_Button(370, 355, 45, 25, "Clear");
        o->callback((Fl_Callback*)cb_Alignment_Style_Clear);
        o->label_size(12);
      }
      { Fl_Group* o = Alignment_Style_Defined = new Fl_Group(420, 355, 20, 25, "U");
        o->box(FL_DOWN_BOX);
        o->label_type(FL_ENGRAVED_LABEL);
        o->align(FL_ALIGN_CENTER);
        o->label_size(12);
        o->end();
      }
      { Flv_List_Alignment* o = Alignment_Style = new Flv_List_Alignment(370, 215, 165, 135, "Alignment");
        o->box(FL_THIN_DOWN_BOX);
        o->callback((Fl_Callback*)alignment_style_callback);
        o->align(FL_ALIGN_TOP|FL_ALIGN_INSIDE);
        o->label_size(12);
        o->has_scrollbar(FLVS_VERTICAL);
        o->rows(9);
        o->end();
      }
      o->end();
    }
    { Fl_Group* o = Size_Group = new Fl_Group(360, 205, 270, 185);
      o->box(FL_THIN_DOWN_BOX);
      o->hide();
      { Fl_Roller* o = Width_Style = new Fl_Roller(410, 215, 85, 25, "Width");
        o->type(1);
        o->maximum(100);
        o->step(1);
        o->callback((Fl_Callback*)width_style_callback);
        o->align(FL_ALIGN_LEFT);
        o->label_size(12);
      }
      { Fl_Button* o = Width_Style_Clear = new Fl_Button(410, 245, 45, 25, "Clear");
        o->callback((Fl_Callback*)cb_Width_Style_Clear);
        o->label_size(12);
      }
      { Fl_Group* o = Width_Style_Value = new Fl_Group(500, 215, 35, 25, "0");
        o->box(FL_THIN_DOWN_BOX);
        o->align(FL_ALIGN_CENTER|FL_ALIGN_INSIDE);
        o->label_size(12);
        o->end();
      }
      { Fl_Group* o = Width_Style_Defined = new Fl_Group(460, 245, 20, 25, "U");
        o->box(FL_DOWN_BOX);
        o->label_type(FL_ENGRAVED_LABEL);
        o->align(FL_ALIGN_CENTER);
        o->label_size(12);
        o->end();
      }
      { Fl_Group* o = Height_Style_Defined = new Fl_Group(460, 320, 20, 25, "U");
        o->box(FL_DOWN_BOX);
        o->label_type(FL_ENGRAVED_LABEL);
        o->align(FL_ALIGN_CENTER);
        o->label_size(12);
        o->end();
      }
      { Fl_Roller* o = Height_Style = new Fl_Roller(410, 290, 85, 25, "Height");
        o->type(1);
        o->maximum(100);
        o->step(1);
        o->callback((Fl_Callback*)height_style_callback);
        o->align(FL_ALIGN_LEFT);
        o->label_size(12);
      }
      { Fl_Button* o = Height_Style_Clear = new Fl_Button(410, 320, 45, 25, "Clear");
        o->callback((Fl_Callback*)cb_Height_Style_Clear);
        o->label_size(12);
      }
      { Fl_Group* o = Height_Style_Value = new Fl_Group(500, 290, 35, 25, "0");
        o->box(FL_THIN_DOWN_BOX);
        o->align(FL_ALIGN_CENTER|FL_ALIGN_INSIDE);
        o->label_size(12);
        o->end();
      }
      o->end();
    }
    { Fl_Group* o = Misc_Group = new Fl_Group(360, 205, 270, 185);
      o->box(FL_THIN_DOWN_BOX);
      o->hide();
      { Fl_Group* o = Resizable_Style_Defined = new Fl_Group(510, 240, 20, 25, "U");
        o->box(FL_DOWN_BOX);
        o->label_type(FL_ENGRAVED_LABEL);
        o->align(FL_ALIGN_CENTER);
        o->label_size(12);
        o->end();
      }
      { Fl_Check_Button* o = Locked_Style = new Fl_Check_Button(440, 215, 20, 20, "Locked");
        o->box(FL_FLAT_BOX);
        o->glyph_box(FL_THIN_DOWN_BOX);
        o->callback((Fl_Callback*)locked_style_callback);
        o->align(FL_ALIGN_LEFT);
        o->label_size(12);
      }
      { Fl_Check_Button* o = Resizable_Style = new Fl_Check_Button(440, 235, 20, 20, "Resizable");
        o->box(FL_FLAT_BOX);
        o->glyph_box(FL_THIN_DOWN_BOX);
        o->callback((Fl_Callback*)resizable_style_callback);
        o->align(FL_ALIGN_LEFT);
        o->label_size(12);
      }
      { Fl_Button* o = Resizable_Style_Clear = new Fl_Button(460, 240, 45, 25, "Clear");
        o->callback((Fl_Callback*)cb_Resizable_Style_Clear);
        o->label_size(12);
      }
      { Fl_Button* o = Locked_Style_Clear = new Fl_Button(460, 215, 45, 25, "Clear");
        o->callback((Fl_Callback*)cb_Locked_Style_Clear);
        o->label_size(12);
      }
      { Fl_Group* o = Locked_Style_Defined = new Fl_Group(510, 215, 20, 25, "U");
        o->box(FL_DOWN_BOX);
        o->label_type(FL_ENGRAVED_LABEL);
        o->align(FL_ALIGN_CENTER);
        o->hide();
        o->label_size(12);
        o->end();
      }
      o->end();
    }
    { Fl_Group* o = Border_Group = new Fl_Group(360, 205, 270, 185);
      o->box(FL_THIN_DOWN_BOX);
      o->hide();
      { Fl_Group* o = new Fl_Group(380, 225, 70, 60);
        o->box(FL_BORDER_BOX);
        o->end();
      }
      { Fl_Group* o = new Fl_Group(395, 240, 40, 30);
        o->box(FL_BORDER_BOX);
        o->end();
      }
      { Fl_Check_Button* o = Border_Inner_Left_Style = new Fl_Check_Button(385, 245, 20, 20, " ");
        o->glyph_box(FL_THIN_DOWN_BOX);
        o->callback((Fl_Callback*)border_style_callback);
      }
      { Fl_Check_Button* o = Border_Inner_Bottom_Style = new Fl_Check_Button(405, 260, 20, 20, " ");
        o->glyph_box(FL_THIN_DOWN_BOX);
        o->callback((Fl_Callback*)border_style_callback);
      }
      { Fl_Check_Button* o = Border_Inner_Right_Style = new Fl_Check_Button(425, 245, 20, 20, " ");
        o->glyph_box(FL_THIN_DOWN_BOX);
        o->callback((Fl_Callback*)border_style_callback);
      }
      { Fl_Check_Button* o = Border_Top_Style = new Fl_Check_Button(405, 215, 20, 20, " ");
        o->glyph_box(FL_THIN_DOWN_BOX);
        o->callback((Fl_Callback*)border_style_callback);
      }
      { Fl_Check_Button* o = Border_Inner_Top_Style = new Fl_Check_Button(405, 230, 20, 20, " ");
        o->glyph_box(FL_THIN_DOWN_BOX);
        o->callback((Fl_Callback*)border_style_callback);
      }
      { Fl_Check_Button* o = Border_Right_Style = new Fl_Check_Button(440, 245, 20, 20, " ");
        o->glyph_box(FL_THIN_DOWN_BOX);
        o->callback((Fl_Callback*)border_style_callback);
      }
      { Fl_Check_Button* o = Border_Bottom_Style = new Fl_Check_Button(405, 275, 20, 20, " ");
        o->glyph_box(FL_THIN_DOWN_BOX);
        o->callback((Fl_Callback*)border_style_callback);
      }
      { Fl_Check_Button* o = Border_Left_Style = new Fl_Check_Button(370, 245, 20, 20, " ");
        o->glyph_box(FL_THIN_DOWN_BOX);
        o->callback((Fl_Callback*)border_style_callback);
      }
      { Fl_Group* o = Border_Color_Style_Value = new Fl_Group(445, 355, 20, 25);
        o->box(FL_THIN_DOWN_BOX);
        o->label_size(12);
        o->end();
      }
      { Fl_Button* o = Border_Color_Style = new Fl_Button(370, 325, 95, 25, "&Border");
        o->callback((Fl_Callback*)cb_Border_Color_Style);
        o->label_size(12);
      }
      { Fl_Button* o = Border_Color_Style_Clear = new Fl_Button(370, 355, 45, 25, "Clear");
        o->callback((Fl_Callback*)cb_Border_Color_Style_Clear);
        o->label_size(12);
      }
      { Fl_Group* o = Border_Color_Style_Defined = new Fl_Group(420, 355, 20, 25, "U");
        o->box(FL_DOWN_BOX);
        o->label_type(FL_ENGRAVED_LABEL);
        o->align(FL_ALIGN_CENTER);
        o->label_size(12);
        o->end();
      }
      { Fl_Button* o = Border_Style_Clear = new Fl_Button(460, 245, 45, 25, "Clear");
        o->callback((Fl_Callback*)cb_Border_Style_Clear);
        o->label_size(12);
      }
      { Fl_Group* o = Border_Style_Defined = new Fl_Group(510, 245, 20, 25, "U");
        o->box(FL_DOWN_BOX);
        o->label_type(FL_ENGRAVED_LABEL);
        o->align(FL_ALIGN_CENTER);
        o->label_size(12);
        o->end();
      }
      { Fl_Roller* o = Border_Spacing_Style = new Fl_Roller(555, 215, 25, 80, "Spacing");
        o->maximum(100);
        o->step(1);
        o->callback((Fl_Callback*)border_spacing_style_callback);
        o->label_size(12);
      }
      { Fl_Button* o = Border_Spacing_Style_Clear = new Fl_Button(550, 315, 45, 25, "Clear");
        o->callback((Fl_Callback*)cb_Border_Spacing_Style_Clear);
        o->label_size(12);
      }
      { Fl_Group* o = Border_Spacing_Style_Value = new Fl_Group(585, 240, 35, 25, "0");
        o->box(FL_THIN_DOWN_BOX);
        o->align(FL_ALIGN_CENTER|FL_ALIGN_INSIDE);
        o->label_size(12);
        o->end();
      }
      { Fl_Group* o = Border_Spacing_Style_Defined = new Fl_Group(600, 315, 20, 25, "U");
        o->box(FL_DOWN_BOX);
        o->label_type(FL_ENGRAVED_LABEL);
        o->align(FL_ALIGN_CENTER);
        o->label_size(12);
        o->end();
      }
      o->end();
    }
    { Fl_Button* o = new Fl_Button(10, 395, 65, 25, "Clear &This");
      o->callback((Fl_Callback*)cb_Clear);
      o->label_size(12);
    }
    { Fl_Button* o = new Fl_Button(80, 395, 65, 25, "&Clear all");
      o->callback((Fl_Callback*)cb_Clear1);
      o->label_size(12);
    }
    { Fl_Group* o = Style_Type_Defined = new Fl_Group(155, 395, 20, 25, "U");
      o->box(FL_DOWN_BOX);
      o->label_type(FL_ENGRAVED_LABEL);
      o->align(FL_ALIGN_CENTER);
      o->label_size(12);
      o->end();
    }
    { Fl_Button* o = new Fl_Button(185, 395, 50, 25, "&Done");
      o->callback((Fl_Callback*)cb_Done);
      o->label_size(12);
    }
    { Fl_Group* o = new Fl_Group(360, 395, 20, 25, "U");
      o->box(FL_DOWN_BOX);
      o->label_type(FL_ENGRAVED_LABEL);
      o->align(FL_ALIGN_CENTER);
      o->label_size(12);
      o->end();
    }
    { Fl_Group* o = new Fl_Group(380, 395, 75, 25, "= Undefined");
      o->align(FL_ALIGN_LEFT|FL_ALIGN_INSIDE);
      o->label_size(12);
      o->end();
    }
    { Fl_Group* o = new Fl_Group(555, 395, 20, 25, "D");
      o->box(FL_DOWN_BOX);
      o->label_type(FL_ENGRAVED_LABEL);
      o->align(FL_ALIGN_CENTER);
      o->label_size(12);
      o->end();
    }
    { Fl_Group* o = new Fl_Group(575, 395, 55, 25, "= Defined");
      o->align(FL_ALIGN_LEFT|FL_ALIGN_INSIDE);
      o->label_size(12);
      o->end();
    }
    o->end();
  }
  { Fl_Window* o = win_table = new Fl_Window(179, 154, "Flv_Table");
    { Flv_TableE* o = wintable = new Flv_TableE(5, 10, 165, 135);
      o->box(FL_THIN_DOWN_BOX);
      o->callback((Fl_Callback*)table_callback);
      init_table();
      win_table->resizable(wintable);
      o->end();
    }
    o->end();
  }
  { Fl_Window* o = win_list = new Fl_Window(180, 157, "Flv_List");
    w = o;
    { Flv_ListE* o = winlist = new Flv_ListE(5, 10, 165, 135);
      o->box(FL_THIN_DOWN_BOX);
      o->callback((Fl_Callback*)list_callback);
      init_list();
      win_list->resizable(winlist);
      o->end();
    }
    o->end();
  }
  style = 0;
  return w;
}

void init_table() {
  //	Set-up row/col stuff
	wintable->rows(10);
	wintable->cols(10);
	wintable->col_width(0,40);
	wintable->has_scrollbar(FLVS_NONE);
}

void init_list() {
  winlist->rows(10);
	winlist->has_scrollbar(FLVS_NONE);
	winlist->feature(FLVF_FULL_RESIZE);
}

void row_header_callback(Fl_Check_Button*n, void*) {
  if (n->value())
	{
		wintable->feature_add(FLVF_ROW_HEADER);
		winlist->feature_add(FLVF_ROW_HEADER);
	} else
	{
		wintable->feature_remove(FLVF_ROW_HEADER);
		winlist->feature_remove(FLVF_ROW_HEADER);
	}
}

void row_footer_callback(Fl_Check_Button*n, void*) {
  if( n->value() )
	{
		wintable->feature_add(FLVF_ROW_FOOTER);
		winlist->feature_add(FLVF_ROW_FOOTER);
	} else
	{
		wintable->feature_remove(FLVF_ROW_FOOTER);
		winlist->feature_remove(FLVF_ROW_FOOTER);
	}
}

void row_divider_callback(Fl_Check_Button *n, void *) {
  if (n->value())
	{
		wintable->feature_add( FLVF_ROW_DIVIDER );
		winlist->feature_add( FLVF_ROW_DIVIDER );
	} else
	{
		wintable->feature_remove( FLVF_ROW_DIVIDER );
		winlist->feature_remove( FLVF_ROW_DIVIDER );
	}
}

void rows_callback(Fl_Roller *n, void *) {
  static char buf[10];
	wintable->rows( n->value() );
	winlist->rows( n->value() );
	sprintf( buf, "%d", (int)n->value() );
	Rows_Value->label( buf );
	Rows_Value->redraw();
}

void row_select_callback(Fl_Check_Button *n, void *) {
  if (n->value())
		wintable->feature_add(FLVF_ROW_SELECT);
	else
		wintable->feature_remove(FLVF_ROW_SELECT);
}

void row_width_callback(Fl_Roller *n, void *) {
  static char buf[10];
	winlist->row_width( n->value() );
	sprintf( buf, "%d", (int)n->value() );
	Row_Width_Value->label( buf );
	Row_Width_Value->redraw();
}

void col_header_callback(Fl_Check_Button *n, void *) {
  if (n->value())
		wintable->feature_add(FLVF_COL_HEADER);
	else
		wintable->feature_remove(FLVF_COL_HEADER);
}

void col_footer_callback(Fl_Check_Button *n, void *) {
  if (n->value())
		wintable->feature_add(FLVF_COL_FOOTER);
	else
		wintable->feature_remove(FLVF_COL_FOOTER);
}

void col_divider_callback(Fl_Check_Button *n, void *) {
  if (n->value())
		wintable->feature_add(FLVF_COL_DIVIDER);
	else
		wintable->feature_remove(FLVF_COL_DIVIDER);
}

void cols_callback(Fl_Roller *n, void *) {
  static char buf[10];

	wintable->cols( n->value() );
	sprintf( buf, "%d", (int)n->value() );
	Cols_Value->label( buf );
	Cols_Value->redraw();
}

void vertical_callback(Fl_Check_Button *n, void*) {
  if (n->value())
	{
		wintable->has_scrollbar( Flv_ShowScrollbar(wintable->has_scrollbar()|FLVS_VERTICAL) );
		winlist->has_scrollbar( Flv_ShowScrollbar(wintable->has_scrollbar()|FLVS_VERTICAL) );
	} else
	{
		wintable->has_scrollbar( Flv_ShowScrollbar(wintable->has_scrollbar() & (~FLVS_VERTICAL)) );
		winlist->has_scrollbar( Flv_ShowScrollbar(wintable->has_scrollbar() & (~FLVS_VERTICAL)) );
	}
}

void horizontal_callback(Fl_Check_Button *n, void *) {
  if (n->value())
	{
		wintable->has_scrollbar( Flv_ShowScrollbar(wintable->has_scrollbar()|FLVS_HORIZONTAL) );
		winlist->has_scrollbar( Flv_ShowScrollbar(wintable->has_scrollbar()|FLVS_HORIZONTAL) );
	} else
	{
		wintable->has_scrollbar( Flv_ShowScrollbar(wintable->has_scrollbar() & (~FLVS_HORIZONTAL)) );
		winlist->has_scrollbar( Flv_ShowScrollbar(wintable->has_scrollbar() & (~FLVS_HORIZONTAL)) );
	}
}

void always_callback(Fl_Check_Button *n, void *) {
  if (n->value())
	{
		wintable->has_scrollbar( Flv_ShowScrollbar(wintable->has_scrollbar()|FLVS_ALWAYS) );
		winlist->has_scrollbar( Flv_ShowScrollbar(wintable->has_scrollbar()|FLVS_ALWAYS) );
	} else
	{
		wintable->has_scrollbar( Flv_ShowScrollbar(wintable->has_scrollbar() & (~FLVS_ALWAYS)) );
		winlist->has_scrollbar( Flv_ShowScrollbar(wintable->has_scrollbar() & (~FLVS_ALWAYS)) );
	}
}

void multi_select_callback(Fl_Check_Button *n, void *) {
  if (n->value())
	{
		wintable->feature_add(FLVF_MULTI_SELECT);
		winlist->feature_add(FLVF_MULTI_SELECT);
	} else
	{
		wintable->feature_remove(FLVF_MULTI_SELECT);
		winlist->feature_remove(FLVF_MULTI_SELECT);
	}
}

void persist_select_callback(Fl_Check_Button *n, void *) {
  if (n->value())
	{
		wintable->feature_add(FLVF_PERSIST_SELECT);
		winlist->feature_add(FLVF_PERSIST_SELECT);
	} else
	{
		wintable->feature_remove(FLVF_PERSIST_SELECT);
		winlist->feature_remove(FLVF_PERSIST_SELECT);
	}
}

void table_callback(Flv_TableE *n, void *) {
  static char buf[10];

	switch( n->why_event() )
	{
		case FLVE_ROW_CHANGED:
		case FLVE_COL_CHANGED:
			if (style<0)
				return;
			sprintf( buf, "(%d,%d)", n->row(), n->col() );
			table_loc->value(buf);
			update_style_info();
			break;
	}
}

void list_callback(Flv_ListE *n, void *) {
  static char buf[10];

	switch( n->why_event() )
	{
		case FLVE_ROW_CHANGED:
			sprintf( buf, "(%d)", n->row() );
			list_loc->value(buf);
			break;
	}
}

void style_type_callback( Flv_List2 *n, void *) {
  if (style<0)
		return;

	style = n->row();
	update_style_info();
}

void full_resize_callback(Fl_Check_Button *n, void *) {
  if (n->value())
		wintable->feature_add(FLVF_FULL_RESIZE);
	else
		wintable->feature_remove(FLVF_FULL_RESIZE);
}

void style_section_callback(Flv_List_Style_Section *n, void *) {
  if (n->why_event()==FLVE_ROW_CHANGED)
	{
		style_section = n->row();
		change_style_group(style_section,true);
		change_style_group(last_style_section,false);
		last_style_section = style_section;
	}
}

void change_style_group( int style, bool visible ) {
  Fl_Group *g=0;

	switch( style )
	{
	  case 0:	g = Color_Group;	break;
	  case 1:	g = Font_Group;	break;
	  case 2:	g = Frame_Group;	break;
	  case 3:	g = Alignment_Group;	break;
	  case 4:	g = Size_Group;	break;
	  case 5:	g = Misc_Group;	break;
	  case 6:	g = Border_Group;	break;
	}

	if (g)
	{
		if (visible)		g->show();
		else			g->hide();
	}
}
static Flv_Style table_label_style;
static Flv_Style list_label_style;

Flv_Style * read_table_style() {
  Flv_Style *rows;

	switch( style )
	{
		case 0: // Global
			return	&(wintable->global_style);
		case 1: // Title/label
			return &table_label_style;
		case 2: // Row footer
			return wintable->row_style.find(-2);
		case 3:	// Row header
			return wintable->row_style.find(-1);
		case 4: // Current row
			return wintable->row_style.find(wintable->row());
		case 5: //	Column footer
			return wintable->col_style.find(-2);
		case 6: // Column header
			return wintable->col_style.find(-1);
		case 7: // Current column
			return wintable->col_style.find(wintable->col());
		case 8: // Current Cell
			rows = wintable->row_style.find(wintable->row());
		  if (!rows)
		  	return 0;
		  return rows->cell_style.find(wintable->col());
	}
	return	&(wintable->global_style);
}

Flv_Style * write_table_style() {
  switch( style )
	{
		case 0: // Global
			return &wintable->global_style;
		case 1: // Title/label
			return &table_label_style;
		case 2: // Row footer
			return &(wintable->row_style[-2]);
		case 3:	// Row header
			return &(wintable->row_style[-1]);
		case 4: // Current row
			return &(wintable->row_style[wintable->row()]);
		case 5: //	Column footer
			return &(wintable->col_style[-2]);
		case 6: // Column header
			return &(wintable->col_style[-1]);
		case 7: // Current column
			return &(wintable->col_style[wintable->col()]);
		case 8: // Current Cell
			return &(wintable->row_style[wintable->row()].cell_style[wintable->col()]);
	}
	return &wintable->global_style;
}

Flv_Style * read_list_style() {
  Flv_Style *rows;

	switch( style )
	{
		case 0: // Global
			return	&(winlist->global_style);
		case 1: // Title/label
			return &list_label_style;
		case 2: // Row footer
			return winlist->row_style.find(-2);
		case 3:	// Row header
			return winlist->row_style.find(-1);
		case 4: // Current row
			return winlist->row_style.find(winlist->row());
		case 8: // Current Cell
			rows = winlist->row_style.find(winlist->row());
			if (!rows)
				return 0;
			return rows->cell_style.find(0);
	}
	return NULL;
}

Flv_Style * write_list_style() {
  switch( style )
	{
		case 0: // Global
			return &winlist->global_style;
		case 1: // Title/label
			return &list_label_style;
		case 2: // Row footer
			return &(winlist->row_style[-2]);
		case 3:	// Row header
			return &(winlist->row_style[-1]);
		case 4: // Current row
			return &(winlist->row_style[winlist->row()]);
		case 8: // Current Cell
			return &(winlist->row_style[winlist->row()].cell_style[0]);
	}
	return NULL;
}

void font_size_callback(Fl_Roller *n, void *) {
  Flv_Style *s = write_table_style();

	if (style<0)
		return;
	if (s)
	{
		s->font_size( n->value() );
		s = write_list_style();
		if (s)
			s->font_size( n->value() );
		update_style_info();
		wintable->redraw();
		winlist->redraw();
	}
}

void font_style_callback(Flv_List_Font *n, void *) {
  Flv_Style *s = write_table_style();

	if (style<0)
		return;

	if (n->why_event()==FLVE_ROW_CHANGED && s)
	{
		s->font( font_list[n->row()] );
		s = write_list_style();
		if (s)
			s->font( font_list[n->row()] );
		update_style_info();
		wintable->redraw();
		winlist->redraw();
	}
}

void frame_style_callback(Flv_List_Frame *n, void *) {
  Flv_Style *s = write_table_style();

	if (style<0)
		return;


	if (n->why_event()==FLVE_ROW_CHANGED && s )
	{
		s->frame( box_list[n->row()] );
		s = write_list_style();
		if (s)
			s->frame( box_list[n->row()] );
		update_style_info();
		wintable->redraw();
		winlist->redraw();
	}
}

void alignment_style_callback(Flv_List_Alignment *n, void *) {
  Flv_Style *s = write_table_style();

	if (style<0)
		return;

	if (s && n->why_event()==FLVE_ROW_CHANGED)
	{
		s->align( alignment_list[ n->row() ] );
		s = write_list_style();
		if (s)
			s->align( alignment_list[ n->row() ] );
		update_style_info();
		wintable->redraw();
		winlist->redraw();
	}
}

void width_style_callback(Fl_Roller *n, void *) {
  Flv_Style *s = write_table_style();

	if (style<0)
		return;
	if (s)
	{
		s->width( n->value() );
		s = write_list_style();
		if (s)
			s->width( n->value() );
		update_style_info();
		wintable->redraw();
		winlist->redraw();
	}
}

void height_style_callback(Fl_Roller *n, void *) {
  Flv_Style *s = write_table_style();

	if (style<0)
		return;
	if (s)
	{
		s->height( n->value() );
		s = write_list_style();
		if (s)
			s->height( n->value() );
		winlist->redraw();
		update_style_info();
		wintable->redraw();
	}
}

void locked_style_callback(Fl_Check_Button *n, void *) {
  Flv_Style *s = write_table_style();

	if (style<0)
		return;
	if (s && s->locked()!=n->value())
	{
		s->locked( n->value() );
		s = write_list_style();
		if (s)
			s->locked( n->value() );
		winlist->redraw();
		update_style_info();
		wintable->redraw();
	}
}

void resizable_style_callback(Fl_Check_Button *n, void *) {
  Flv_Style *s = write_table_style();

	if (style<0)
		return;
	if (s && s->resizable()!=n->value())
	{
		s->resizable( n->value() );
		s = write_list_style();
		if (s)
			s->resizable( n->value() );
		winlist->redraw();
		update_style_info();
		wintable->redraw();
	}
}

void border_style_callback( Fl_Check_Button *, void *) {
  Flv_Style *s = write_table_style();
	int bs=0;

	if (style<0)
		return;

	if (s)
	{
		bs |= Border_Left_Style->value()?FLVB_LEFT:0;
		bs |= Border_Top_Style->value()?FLVB_TOP:0;
		bs |= Border_Right_Style->value()?FLVB_RIGHT:0;
		bs |= Border_Bottom_Style->value()?FLVB_BOTTOM:0;
		bs |= Border_Inner_Left_Style->value()?FLVB_INNER_LEFT:0;
		bs |= Border_Inner_Top_Style->value()?FLVB_INNER_TOP:0;
		bs |= Border_Inner_Right_Style->value()?FLVB_INNER_RIGHT:0;
		bs |= Border_Inner_Bottom_Style->value()?FLVB_INNER_BOTTOM:0;
		s->border(bs);
		s = write_list_style();
		if (s)
			s->border(bs);
		winlist->redraw();
		update_style_info();
		wintable->redraw();
	}
}

void border_spacing_style_callback(Fl_Roller *n, void *) {
  Flv_Style *s = write_table_style();

	if (style<0)
		return;
	if (s)
	{
		s->border_spacing( n->value() );
		s = write_list_style();
		if (s)
			s->border_spacing( n->value() );
		winlist->redraw();
		update_style_info();
		wintable->redraw();
	}
}

void Foreground_callback(Fl_Button *, void *) {
  int c;
	Fl_Color nc;
	Flv_Style *s;

	nc = Foreground_Style_Value->color();
#ifndef FLTK_2
	nc = fl_show_colormap(nc);
	c = 1;
#else
	c = fl_color_chooser( "Foreground", nc );
#endif
	if (c)
	{
		Foreground_Style_Value->color(nc);
		s = write_table_style();
		if (s)
			s->foreground(nc);
		s = write_list_style();
		if (s)
			s->foreground(nc);
		wintable->redraw();
		winlist->redraw();
		update_style_info();
	}
}

void update_style_info(void) {
  Flv_Style *s = read_table_style();
	int t;


	Style_Type_Defined->label("U");
	Foreground_Style_Defined->label("U");
 	Background_Style_Defined->label("U");
	Font_Style_Defined->label("U");
	Font_Size_Style_Defined->label("U");
	Font_Size_Style_Value->label("");
	Frame_Style_Defined->label("U");
	Alignment_Style_Defined->label("U");
	Width_Style_Defined->label("U");
	Width_Style_Value->label("");
	Height_Style_Defined->label("U");
	Height_Style_Value->label("");
	Locked_Style_Defined->label("U");
	Resizable_Style_Defined->label("U");
	Border_Style_Defined->label("U");
	Border_Spacing_Style_Defined->label("U");
	Border_Color_Style_Defined->label("U");

	if (s)
	{
		Style_Type_Defined->label("D");
		if (s->foreground_defined())
		{
			Foreground_Style_Defined->label("D");
			Foreground_Style_Value->color(s->foreground());
		}

		if (s->background_defined())
		 {
			Background_Style_Defined->label("D");
			Background_Style_Value->color(s->background());
		}
		if (s->font_defined())
		{
			Font_Style_Defined->label("D");
			for (t=0;	t<16;	t++ )
			{
				if (s->font()==font_list[t])
				{
					Font_Style->row(t);
					break;
				}
			}
		}
		if (s->font_size_defined())
		{
			static char font_size[10];
			sprintf( font_size, "%d", s->font_size() );
			Font_Size_Style_Value->label(font_size);
			Font_Size_Style_Defined->label("D");
		}
		if (s->frame_defined())
		{
			Frame_Style_Defined->label("D");
			for (t=0;	t<17;	t++ )
			{
				if (s->frame()==box_list[t])
				{
					Frame_Style->row(t);
					break;
				}
			}
		}
		if (s->align_defined())
		{
			Alignment_Style_Defined->label("D");
			for (t=0;	t<9;	t++ )
			{
				if (s->align()==alignment_list[t])
				{
					Alignment_Style->row(t);
					break;
				}
			}
		}
		if (s->width_defined())
		{
			static char width[10];
			sprintf( width, "%d", s->width() );
			Width_Style_Value->label(width);
			Width_Style_Defined->label("D");
		}
		if (s->height_defined())
		{
			static char height[10];
			sprintf( height, "%d", s->height() );
			Height_Style_Value->label(height);
			Height_Style_Defined->label("D");
		}
		if (s->locked_defined())
		{
			Locked_Style_Defined->label("D");
			Locked_Style->value(s->locked());
		} else
			Locked_Style->value(0);

		if (s->resizable_defined())
		{
			Resizable_Style_Defined->label("D");
			Resizable_Style->value(s->resizable());
		} else
			Resizable_Style->value(0);

		if (s->border_defined())
		{
			Border_Style_Defined->label("D");
			int bs = s->border();
			Border_Left_Style->value( (bs&FLVB_LEFT)!=0 );
			Border_Top_Style->value( (bs&FLVB_TOP)!=0 );
			Border_Right_Style->value( (bs&FLVB_RIGHT)!=0 );
			Border_Bottom_Style->value( (bs&FLVB_BOTTOM)!=0 );
			Border_Inner_Left_Style->value( (bs&FLVB_INNER_LEFT)!=0 );
			Border_Inner_Top_Style->value( (bs&FLVB_INNER_TOP)!=0 );
			Border_Inner_Right_Style->value( (bs&FLVB_INNER_RIGHT)!=0 );
			Border_Inner_Bottom_Style->value( (bs&FLVB_INNER_BOTTOM)!=0 );
		} else
		{
			Border_Left_Style->value( 0 );
			Border_Top_Style->value( 0 );
			Border_Right_Style->value( 0 );
			Border_Bottom_Style->value( 0 );
			Border_Inner_Left_Style->value( 0 );
			Border_Inner_Top_Style->value( 0 );
			Border_Inner_Right_Style->value( 0 );
			Border_Inner_Bottom_Style->value( 0 );
		}
		if (s->border_spacing_defined())
		{
			static char border_spacing[10];
			sprintf( border_spacing, "%d", s->border_spacing() );
			Border_Spacing_Style_Defined->label("D");
			Border_Spacing_Style_Value->label(border_spacing);
			Border_Spacing_Style->value( s->border_spacing() );
		}
		if (s->border_color_defined())
		 {
			Border_Color_Style_Defined->label("D");
			Border_Color_Style_Value->color(s->border_color() );
		}
	} else
	{
	 	Foreground_Style_Value->color(win->color());
	 	Background_Style_Value->color(win->color());
		Border_Color_Style_Value->color(win->color());
		Border_Left_Style->value( 0 );
		Border_Top_Style->value( 0 );
		Border_Right_Style->value( 0 );
		Border_Bottom_Style->value( 0 );
		Border_Inner_Left_Style->value( 0 );
		Border_Inner_Top_Style->value( 0 );
		Border_Inner_Right_Style->value( 0 );
		Border_Inner_Bottom_Style->value( 0 );
		Resizable_Style->value(0);
		Locked_Style->value(0);
	}
	if (Color_Group->visible())
		Color_Group->redraw();
	if (Frame_Group->visible())
		Frame_Group->redraw();
	if (Font_Group->visible())
		Font_Group->redraw();
	if (Alignment_Group->visible())
		Alignment_Group->redraw();
	if (Size_Group->visible())
		Size_Group->redraw();
	if (Misc_Group->visible())
		Misc_Group->redraw();
	if (Border_Group->visible())
		Border_Group->redraw();

//	win->redraw();
}

int main(int argc, char **argv) {
  row_head[0][0]=0;
	row_head[1][0]=0;
	row_head[2][0]=0;
	col_head[0][0]=0;
	col_head[1][0]=0;
	cell_text[0]=0;

	make_window();
	wintable->row(1);
	wintable->row(0);
	winlist->row(1);
	winlist->row(0);
	win->show(argc, argv);
	win_table->show(argc, argv);
	win_list->show(argc, argv);
	update_style_info();
  return Fl::run();
}
