/* --< GKrellAclock 0.1 >--{ 21 Aug 2001 }--
 *
 * Author: M.R.Muthu Kumar (m_muthukumar@users.sourceforge.net)
 *
 * All the graphic routines are from - Tom Gilbert ( http://linuxbrit.co.uk/ )
 */

#include <gkrellm/gkrellm.h>

#include<math.h>

#define GKRELLACLOCK_VER 	"0.1"

#define	CONFIG_NAME	"GkrellAclock"	/* Name in the configuration window */
#define	STYLE_NAME	"GkrellAclock"	/* Theme subdirectory name */
			                /*  and gkrellmrc style name.*/ 


#define CHART_W 60
#define CHART_H 40

static Monitor		*mon;
static Chart		*chart;
static ChartConfig	*chart_config=NULL;

static gint		style_id;

struct tm  *tm;

guchar rgbbuf[CHART_W * CHART_H * 3];

/* Set a pixel, takes a brightness and a colour value */
static void
set_col_pixel (gint x, gint y,  guchar c,  guchar rrr,
                guchar ggg,  guchar bbb)
{
  guchar *ptr;

  if ((((int) c) == 0) || (x < 0) || (y < 0) || (x > 59) || (y > 39))
    return;
 

  ptr = rgbbuf + ( CHART_W * 3 * (y)) + (3 * x);
  ptr[0] = ((double) rrr / 255 * (double) c);
  ptr[1] = ((double) ggg / 255 * (double) c);
  ptr[2] = ((double) bbb / 255 * (double) c);
}

static void
blank_buf(void)
{
  guchar *pos;
  gint x,y;

  pos = rgbbuf;
  for (y = 0; y < CHART_H; y++)
    {
      for (x = 0; x < CHART_W; x++)
        {

          pos[0] = pos[1] = pos[2] = 0;
          pos += 3;
        }
    }
}

static void
aa_line (gint x1, gint y1, gint x2, gint y2, guchar b,
         guchar rr, guchar gg, guchar bb)
{
  gdouble grad, line_width, line_height, xgap, ygap, xend, yend, yf, xf,
    brightness1, brightness2, db, xm, ym;
  gint ix1, ix2, iy1, iy2, i;
  gint temp;

  guchar c1, c2;

  line_width = (x2 - x1);
  line_height = (y2 - y1);

  if (abs (line_width) > abs (line_height))
    {
      if (x1 > x2)
        {
          temp = x1;
          x1 = x2;
          x2 = temp;
          temp = y1;
          y1 = y2;
          y2 = temp;
          line_width = (x2 - x1);
          line_height = (y2 - y1);
        }

      /* This is currently broken. It is supposed to account
       * for lines that don't span more than one pixel */
      if (abs (line_width) < 0.1)
        {
          x2 = x1 + 0.5;
          x1 -= 0.5;
          grad = 0;
        }
      else
        {
          grad = line_height / line_width;
          if (line_width < 1)
            {
              xm = (x1 + x2) / 2;
              ym = (y1 + y2) / 2;

              x1 = xm - 0.5;
              x2 = xm + 0.5;
              y1 = ym - (grad / 2);
            y2 = ym + (grad / 2);

              line_width = 1;
              line_height = grad;
            }
        }

      xend = (int) x1 + 0.5;
      yend = y1 + grad * (xend - x1);

      xgap = (1 - modf (x1 + 0.5, &db));
      ix1 = (int) xend;
      iy1 = (int) yend;

      brightness1 = (1 - modf (yend, &db)) * xgap;
      brightness2 = modf (yend, &db) * xgap;

      c1 = (unsigned char) (brightness1 * b);
      c2 = (unsigned char) (brightness2 * b);

      set_col_pixel (ix1, iy1, c1, rr, gg, bb);
      set_col_pixel (ix1, iy1 + 1, c2, rr, gg, bb);

      yf = yend + grad;

      xend = (int) (x2 + .5);
      yend = y2 + grad * (xend - x2);

      xgap = 1 - modf (x2 - .5, &db);

      ix2 = (int) xend;
      iy2 = (int) yend;

      brightness1 = (1 - modf (yend, &db)) * xgap;
      brightness2 = modf (yend, &db) * xgap;

      c1 = (unsigned char) (brightness1 * b);
      c2 = (unsigned char) (brightness2 * b);

      set_col_pixel (ix2, iy2, c1, rr, gg, bb);
      set_col_pixel (ix2, iy2 + 1, c2, rr, gg, bb);

      for (i = ix1 + 1; i < ix2; i++)
        {
          brightness1 = (1 - modf (yf, &db));
          brightness2 = modf (yf, &db);
          c1 = (unsigned char) (brightness1 * b);
          c2 = (unsigned char) (brightness2 * b);

          set_col_pixel (i, (int) yf, c1, rr, gg, bb);
          set_col_pixel (i, (int) yf + 1, c2, rr, gg, bb);

          yf = yf + grad;
        }
    }
  else
    {
      if (y2 < y1)
        {
          temp = x1;
          x1 = x2;
          x2 = temp;
          temp = y1;
          y1 = y2;
          y2 = temp;
          line_width = (x2 - x1);
          line_height = (y2 - y1);
        }

      /* This is currently broken */
      if (abs (line_height) < 0.1)
        {
          y2 = y1 + 0.5;
          y1 -= 0.5;
          grad = 0;
        }
      else
        {
          grad = line_width / line_height;
          if (line_height < 1)
            {
              xm = (x1 + x2) / 2;
              ym = (y1 + y2) / 2;

              x1 = xm - (grad / 2);
              x2 = xm + (grad / 2);
              y1 = ym - 0.5;
              y2 = ym + 0.5;

              line_height = 1;
              line_width = grad;
            }
        }

      yend = (int) (y1 + 0.5);
      xend = x1 + grad * (yend - y1);

      ygap = (1 - modf (y1 + 0.5, &db));
      ix1 = (int) xend;
      iy1 = (int) yend;

      brightness1 = (1 - modf (xend, &db)) * ygap;
      brightness2 = modf (xend, &db) * ygap;

      c1 = (unsigned char) (brightness1 * b);
      c2 = (unsigned char) (brightness2 * b);

      set_col_pixel (ix1, iy1, c1, rr, gg, bb);
      set_col_pixel (ix1 + 1, iy1, c2, rr, gg, bb);

      xf = xend + grad;

      yend = (int) (y2 + .5);
      xend = x2 + grad * (yend - y2);

      ygap = 1 - modf (y2 - .5, &db);

      ix2 = (int) xend;
      iy2 = (int) yend;

      brightness1 = (1 - modf (xend, &db)) * ygap;
      brightness2 = modf (xend, &db) * ygap;

      c1 = (unsigned char) (brightness1 * b);
      c2 = (unsigned char) (brightness2 * b);

      set_col_pixel (ix2, iy2, c1, rr, gg, bb);
      set_col_pixel (ix2 + 1, iy2, c2, rr, gg, bb);
      for (i = iy1 + 1; i < iy2; i++)
        {
          brightness1 = (1 - modf (xf, &db));
          brightness2 = modf (xf, &db);

          c1 = (unsigned char) (brightness1 * b);
          c2 = (unsigned char) (brightness2 * b);

          set_col_pixel ((int) xf, i, c1, rr, gg, bb);
          set_col_pixel ((int) (xf + 1), i, c2, rr, gg, bb);

          xf += grad;
        }
    }
}

static void
draw_clock(void)
{
   gint tempX, tempY;
   gint                 h, m, s;

   gdouble        minutes = 20, hours = 12, seconds = 0;

   tm = gkrellm_get_current_time();

   h = tm->tm_hour;
   m = tm->tm_min;
   s = tm->tm_sec;
   hours = (double)h + ((double)m / 60) + ((double)s / 3600);
   minutes = (double)m + ((double)s / 60);
   seconds = (double)s;

   blank_buf();

   set_col_pixel (29, 0, 255, 255, 255, 255);
   set_col_pixel (30, 0, 255, 255, 255, 255);

   set_col_pixel (38, 5, 255, 255, 255, 255);
   set_col_pixel (44, 11, 255, 255, 255, 255);
   set_col_pixel (38, 34, 255, 255, 255, 255);
   set_col_pixel (44, 28, 255, 255, 255, 255);

   set_col_pixel (29, 39, 255, 255, 255, 255);
   set_col_pixel (30, 39, 255, 255, 255, 255);

   set_col_pixel (15, 11, 255, 255, 255, 255);
   set_col_pixel (22, 5, 255, 255, 255, 255);
   set_col_pixel (15, 28, 255, 255, 255, 255);
   set_col_pixel (22, 34, 255, 255, 255, 255);

   set_col_pixel (9, 19, 255, 255, 255, 255);
   set_col_pixel (9, 20, 255, 255, 255, 255);

   set_col_pixel (49, 19, 255, 255, 255, 255);
   set_col_pixel (49, 20, 255, 255, 255, 255);


   tempX = 29 + (int)(sin((seconds * 3.14159 * 2) / 60) * 19 );
   tempY = 19 - (int)(cos((seconds * 3.14159 * 2) / 60)  * 19);
   aa_line (29, 19, tempX, tempY, (unsigned char) 255, 255, 0, 0);

   tempX = 30 + (int)(sin((seconds * 3.14159 * 2) / 60) * 19 );
   tempY = 20 - (int)(cos((seconds * 3.14159 * 2) / 60)  * 19);
   aa_line (30, 20, tempX, tempY, (unsigned char) 255, 255, 0, 0);

   tempX = 29 + (int)(sin((minutes * 3.14159 * 2) / 60) * 18 );
   tempY = 19 - (int)(cos((minutes * 3.14159 * 2) / 60)  * 18);
   aa_line (29, 19, tempX, tempY, (unsigned char) 255, 255, 255, 255);
   tempX = 30 + (int)(sin((minutes * 3.14159 * 2) / 60) * 18 );
   tempY = 20 - (int)(cos((minutes * 3.14159 * 2) / 60)  * 18);
   aa_line (30, 20, tempX, tempY, (unsigned char) 255, 255, 255, 255);

   tempX = 29 + (int)(sin((hours * 3.14159 * 2) / 12) * 12 );
   tempY = 19 - (int)(cos((hours * 3.14159 * 2) / 12)  * 12);
   aa_line (29, 19, tempX, tempY, (unsigned char) 255, 255, 255, 255);
   tempX = 30 + (int)(sin((hours * 3.14159 * 2) / 12) * 12 );
   tempY = 20 - (int)(cos((hours * 3.14159 * 2) / 12)  * 12);
   aa_line (30, 20, tempX, tempY, (unsigned char) 255, 255, 255, 255);

}
static gint
chart_expose_event(GtkWidget *widget, GdkEventExpose *ev)
{
   draw_clock();

   gdk_draw_rgb_image (widget->window, widget->style->fg_gc[GTK_STATE_NORMAL],
                      0, 0, CHART_W, CHART_H,
                      GDK_RGB_DITHER_MAX, rgbbuf, CHART_W * 3);
   return TRUE;
}

static void
update_plugin ()
{
  GdkEventExpose event;
  gint ret_val;

  gtk_signal_emit_by_name(GTK_OBJECT(chart->drawing_area),
                                "expose_event", &event, &ret_val  );
}

static void
create_plugin(GtkWidget *vbox, gint first_create)
{
	Style			*style;
	TextStyle		*ts, *ts_alt;

	if (first_create)
	{
	  chart = gkrellm_chart_new0();
	}  

	gkrellm_set_chart_height_default(chart, 40);

	gkrellm_chart_create(vbox, mon, chart, &chart_config);

	style = gkrellm_meter_style(style_id);

	/* Each Style has two text styles.  The theme designer has picked the
	|  colors and font sizes, presumably based on knowledge of what you draw
	|  on your panel.  You just do the drawing.  You probably could assume
	|  the ts font is larger than the ts_alt font, but again you can be
	|  overridden by the theme designer.
	*/
	ts = gkrellm_meter_textstyle(style_id);
	ts_alt = gkrellm_meter_alt_textstyle(style_id);
	/**
	panel->textstyle = ts;		
	**/


        /***
        if (shoot_tips == NULL)
        {
          shoot_tips = gtk_tooltips_new();
          shoot_tips_text = g_strdup("Click <Shoot> to grab window or screen\nClick <Lock> to lock the screen");
          gtk_tooltips_set_tip(shoot_tips, panel->drawing_area,
                               shoot_tips_text, NULL);
          gtk_tooltips_set_delay(shoot_tips, 1000);
        }
	***/

	if (first_create)
	{	
	    gtk_signal_connect(GTK_OBJECT (chart->drawing_area), "expose_event",
    	        (GtkSignalFunc) chart_expose_event, NULL);

	    gdk_rgb_init();
	    blank_buf();
	}  

}
#define PLUGIN_CONFIG_KEYWORD    "gkrellaclock"

static void
create_aclock_tab (GtkWidget *tab)
{
    GtkWidget *laptop, *about_label, *label;

    gchar *about_text = NULL;

    laptop = gtk_notebook_new();
    gtk_notebook_set_tab_pos(GTK_NOTEBOOK(laptop), GTK_POS_TOP);
    gtk_box_pack_start(GTK_BOX(tab), laptop, TRUE, TRUE, 0);

        /* about */
    about_text = g_strdup_printf(
        "GKrellAclock %s\n" \
        "GKrellM Aclock Plugin\n" \
        "\n" \
        "Copyright (C) 2001 M.R.Muthu Kumar\n" \
        "m_muthukumar@users.sourceforge.net\n" \
        "\n" \
        "Released under the GNU Public License\n" \
	"GkrellAclock comes with ABSOLUTELY NO WARRANTY\n" \
        , GKRELLACLOCK_VER
    );
    about_label = gtk_label_new(about_text);
    g_free(about_text);
    label = gtk_label_new("About");
    gtk_notebook_append_page(GTK_NOTEBOOK(laptop), about_label, label);
}


/* The monitor structure tells GKrellM how to call the plugin routines.
*/
static Monitor	plugin_mon	=
	{
	CONFIG_NAME,        	/* Name, for config tab.    */
	0,			/* Id,  0 if a plugin       */
	create_plugin,		/* The create function      */
	update_plugin,			/* The update function      */
	create_aclock_tab,	/* The config tab create function   */
	NULL,			/* Apply the config function        */ 
	NULL,			/* Save user config*/
	NULL,			/* Load user config*/
	PLUGIN_CONFIG_KEYWORD,	/* config keyword*/ 
	NULL,			/* Undefined 2	*/
	NULL,			/* Undefined 1	*/
	NULL,			/* private		*/ 
	MON_CAL,		/* Insert plugin before this monitor*/ 
	NULL,			/* Handle if a plugin, filled in by GKrellM */
	NULL			/* path if a plugin, filled in by GKrellM   */
	};


  /* All GKrellM plugins must have one global routine named init_plugin()
  |  which returns a pointer to a filled in monitor structure.
  */
Monitor *
init_plugin()
	{
	/* If this call is made, the background and krell images for this plugin
	|  can be custom themed by putting bg_meter.png or krell.png in the
	|  subdirectory STYLE_NAME of the theme directory.  Text colors (and
	|  other things) can also be specified for the plugin with gkrellmrc
	|  lines like:  StyleMeter  STYLE_NAME.textcolor orange black shadow
	|  If no custom themeing has been done, then all above calls using
	|  style_id will be equivalent to style_id = DEFAULT_STYLE_ID.
	*/
	style_id = gkrellm_add_meter_style(&plugin_mon, STYLE_NAME); 

	/* style_id = gkrellm_lookup_meter_style_id(CAL_STYLE_NAME); */


	mon = &plugin_mon;
	return &plugin_mon;
	}
