/*
** Copyright 2000 Double Precision, Inc.
** See COPYING for distribution information.
**
** $Id: unicode.c,v 1.1 2000/09/29 04:38:47 mrsam Exp $
*/

#include	"config.h"
#include	"unicode.h"
#include	<string.h>
#include	<ctype.h>
#include	<stdlib.h>
#include	<errno.h>

const char *unicode_default_chset()
{
const char *p=RFC2045CHARSET;

	if (unicode_find(p))
		return (p);

	return (unicode_ISO8859_1.chset);
}

const struct unicode_info *unicode_find(const char *chset)
{
char *p, *q;
int	i;

	if (!chset)	/* Default character set */
		return (&unicode_ISO8859_1);

	p=strdup(chset);
	if (!p)
		return (0);

	for (q=p; *q; q++)
		*q=toupper(*q);

	if (strcmp(unicode_ISO8859_1.chset, p) == 0)
	{
		free(p);
		return (&unicode_ISO8859_1);
	}

	for (i=0; unicode_chsetlist[i].chsetname; i++)
		if (strcmp(unicode_chsetlist[i].chsetname, p) == 0)
		{
			free(p);
			return (unicode_chsetlist[i].ptr);
		}
	return (0);
}

char *unicode_convert(const char *txt, const struct unicode_info *from,
		      const struct unicode_info *to)
{
	unicode_char *uc;
	char *s;
	int dummy;

	if (strcmp(from->chset, to->chset) == 0)	/* NOOP */
		return (strdup(txt));

	uc=(*from->c2u)(txt, &dummy);
	if (!uc)
	{
		if (dummy >= 0)
			errno=EINVAL;

		return (0);
	}

	s=(*to->u2c)(uc, &dummy);

	free(uc);

	if (dummy >= 0)
		errno=EINVAL;

	return (s);
}

char *unicode_convert_fromchset(const char *txt, const char *from,
		      const struct unicode_info *to)
{
	const struct unicode_info *fromu=unicode_find(from);

	if (!fromu)
	{
		errno=EINVAL;
		return (0);
	}
	return (unicode_convert(txt, fromu, to));
}



