/*
** Copyright 1998 - 1999 Double Precision, Inc.
** See COPYING for distribution information.
*/

#if	HAVE_CONFIG_H
#include	"config.h"
#endif
#include	<stdio.h>
#include	<stdlib.h>
#include	<string.h>
#include	<errno.h>
#include	<ctype.h>
#include	<fcntl.h>
#include	<signal.h>
#include	<unistd.h>
#include	"imaptoken.h"
#include	"imapwrite.h"

static const char rcsid[]="$Id: mainloop.c,v 1.3 2000/02/28 05:16:52 mrsam Exp $";

extern int do_imap_command(const char *);

static RETSIGTYPE sigexit(int n)
{
static char byemsg[]="* BYE Courier-IMAP server shut down by signal.\r\n";

	write(1, byemsg, sizeof(byemsg)-1);
	exit(0);
#if	RETSIGTYPE != void
	return (0);
#endif
}

void mainloop(void)
{
	signal(SIGTERM, sigexit);
	signal(SIGHUP, sigexit);
	signal(SIGINT, sigexit);

	for (;;)
	{
	char	tag[IT_MAX_ATOM_SIZE+1];
	struct	imaptoken *curtoken;

		read_timeout(30 * 60);
		curtoken=nexttoken_nouc();
		tag[0]=0;
		if (curtoken->tokentype == IT_ATOM ||
			curtoken->tokentype == IT_NUMBER)
		{
		int	rc;

			strncat(tag, curtoken->tokenbuf, IT_MAX_ATOM_SIZE);
			rc=do_imap_command(tag);

			if (rc == 0)
			{
				writeflush();
				read_eol();
				continue;
			}
		}

		read_eol();
		writes(tag[0] ? tag:"*");
		writes(" NO Error in IMAP command received by server.\r\n");
		writeflush();
	}
}
