/*
** Copyright 1998 - 2000 Double Precision, Inc.  See COPYING for
** distribution information.
*/

#if	HAVE_CONFIG_H
#include	"config.h"
#endif
#include	<stdio.h>
#include	<stdlib.h>
#include	<string.h>
#include	<errno.h>
#include	<pwd.h>
#if	HAVE_UNISTD_H
#include	<unistd.h>
#endif
#include	"auth.h"
#include	"authmod.h"
#include	<vpopmail.h>
#include	<vauth.h>
#include	"vpopmail_config.h"

extern char *authvchkpw_isvirtual(char *);

extern FILE *authvchkpw_file(const char *, const char *);
extern struct passwd *authvchkpw_search(FILE *, const char *);

static const char rcsid[]="$Id: preauthvchkpw.c,v 1.11 2000/10/06 23:45:17 mrsam Exp $";

int auth_vchkpw_pre(const char *userid, const char *service,
        int (*callback)(struct authinfo *, void *),
                        void *arg)
{
struct passwd *pw;
char	*s;
uid_t	uid;
gid_t	gid;
char	*usercopy;
int	notfound;
struct authinfo auth;

	memset(&auth, 0, sizeof(auth));

	usercopy=strdup(userid);
	if (!usercopy)
	{
		perror("strdup");
		return (1);
	}

	notfound=EACCES;
	if ((s=authvchkpw_isvirtual(usercopy)) != 0)
	{
	char	*t;

		*s++=0;
		while ((t=strchr(s, '/')) != 0)
			*t='.';	/* Fuck you */
	}
	else
	{
		s = DEFAULT_DOMAIN;
		notfound=EPERM;
	}
	

	vget_assign(s,NULL,0,&uid, &gid);
	pw=vauth_getpw(usercopy, s);
	free(usercopy);
	vclose();

	if (!pw)
	{
		errno=notfound;
		return (-1);
	}

	pw->pw_uid=uid;
	pw->pw_gid=gid;

	auth.sysuserid= &pw->pw_uid;
	auth.sysgroupid=pw->pw_gid;
	auth.homedir=pw->pw_dir;
	auth.address=userid;
	auth.fullname=pw->pw_gecos;
	auth.passwd=pw->pw_passwd;

	return ((*callback)(&auth, arg));
}
