.\"
.\"Copyright (c) 1994, 1995 Joerg Wunsch
.\"
.\"All rights reserved.
.\"
.\"This program is free software.
.\"
.\"Redistribution and use in source and binary forms, with or without
.\"modification, are permitted provided that the following conditions
.\"are met:
.\"1. Redistributions of source code must retain the above copyright
.\"   notice, this list of conditions and the following disclaimer.
.\"2. Redistributions in binary form must reproduce the above copyright
.\"   notice, this list of conditions and the following disclaimer in the
.\"   documentation and/or other materials provided with the distribution.
.\"
.\"THIS SOFTWARE IS PROVIDED BY THE DEVELOPERS ``AS IS'' AND ANY EXPRESS OR
.\"IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
.\"OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED.
.\"IN NO EVENT SHALL THE DEVELOPERS BE LIABLE FOR ANY DIRECT, INDIRECT,
.\"INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT
.\"NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,
.\"DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY
.\"THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
.\"(INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF
.\"THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
.\"
.\" $Id: xtestpicture.man,v 1.4 1995/08/25 16:02:49 j Exp $
.\"
.TH XTESTPICTURE 1 "Contributed" "X Version 11"
.SH NAME
xtestpicture - draw a simple monitor test pattern
.SH SYNOPSIS
.B xtestpicture
.I [\-s[aturated]]
.I [\-d[isplay] display]
.I [\-v[ersion]]
.SH DESCRIPTION
This program creates a single window covering the whole screen, and
draws several test patterns in it. The window is configured to be not
intercepted by a window manager and raised to the top of the window
stack, so it should be the only picture on the screen at all.

A couple of lines between the opposite corners, two rectangles near
the border of the screen, a single rectangle, and a circle in the
middle of the screen are mainly useful for convergency and linearity
considerations.

A box with alternating black and white vertical lines above the center
of the screen, two pixels thick on the left side and one pixel thick
each on the right side is intented to evaluate the sharpness and
bandwidth of the monitor.

Finally, there's a box containing a palette of eight colors. These are
the basic CRT colors \fIred\fP, \fIgreen\fP, and \fIblue\fP, along
with their mutual mixture colors \fImagenta\fP, \fIcyan\fP,
\fIyellow\fP, and \fIwhite\fP, accompanied by a black rectangle to
complete the series. The colors are fully saturated in the top row,
i.\& e. with 100\& % intensity and not intermixed with white, while the
saturation decreases in steps of 25\& % towards the bottom row, which is
plain gray scale (0\& % saturation).

Since this color palette causes a total cost of 32 color cells, it can
be avoided by starting \fBxtestpicture\fP with the option
\fI\-s[aturated]\fP.  This will cause the program to display only
fully saturated colors.

The program will exit if any pointer button is pressed.

Specifying the option \fI\-v[ersion]\fP will cause the program to
print its version identification to stderr and exit.
.SH AUTHOR
.if n Joerg Wunsch,
.if t J\(:org Wunsch,
Dresden <joerg_wunsch@uriah.heep.sax.de>

