#!/bin/sh
echo
echo Checking that each command expects each option only once
echo

set -e

test $DARCS || DARCS=$PWD/../darcs
rm -rf temp1
mkdir temp1
cd temp1

command_good() {
    echo -n Checking $1... ' '
    # only output actual command options, i.e. lines that contain a --
    $DARCS $1 --help | grep -- "--" | sort > foo
    uniq foo > unifoo
    if cmp foo unifoo; then
        echo passed.
    else
        echo failed!
        diff -u unifoo foo
        return 1
    fi
    return 0
}

command_good get
command_good init
$DARCS init
command_good annotate
command_good add
command_good whatsnew
command_good record
command_good get
command_good pull
command_good remove
command_good rollback
command_good unrecord
command_good unpull
command_good check
command_good revert
command_good unrevert
command_good dist
command_good mv
command_good replace
command_good tag
command_good push
command_good apply
command_good diff
command_good setpref
command_good trackdown
command_good optimize
command_good changes
command_good annotate
command_good repair

cd ..
rm -rf temp1

