%  Copyright (C) 2002-2003 David Roundy
%
%  This program is free software; you can redistribute it and/or modify
%  it under the terms of the GNU General Public License as published by
%  the Free Software Foundation; either version 2, or (at your option)
%  any later version.
%
%  This program is distributed in the hope that it will be useful,
%  but WITHOUT ANY WARRANTY; without even the implied warranty of
%  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
%  GNU General Public License for more details.
%
%  You should have received a copy of the GNU General Public License
%  along with this program; if not, write to the Free Software Foundation,
%  Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
\chapter{Theory of patches}
\label{Patch}

\newtheorem{thm}{Theorem}
\newtheorem{dfn}{Definition}

\section{Background}

I think a little background on the author is in order.  I am a physicist,
and think like a physicist.  The proofs and theorems given here are what I
would call ``physicist'' proofs and theorems, which is to say that while
the proofs may not be rigorous, they are practical, and the theorems are
intended to give physical insight.  It would be great to have a
mathematician work on this, but I am not a mathematician, and don't care
for math.

From the beginning of this theory, which originated as the result of a
series of email discussions with Tom Lord, I have looked at patches as
being analogous to the operators of quantum mechanics.  I include in this
appendix footnotes explaining the theory of patches in terms of the theory
of quantum mechanics.  I know that for most people this won't help at all,
but many of my friends (and as I write this all three of darcs' users) are
physicists, and this will be helpful to them.  To non-physicists, perhaps it
will provide some insight into how at least this physicist thinks.

\begin{code}
module Patch ( Patch, eq_patches,
               null_patch, is_null_patch,
               rmfile, addfile, rmdir, adddir, move,
               hunk, tokreplace, join_patches, namepatch,
               binary,
               patch_description,
               showContextPatch, showPatch,
               infopatch, changepref,
               is_similar, is_addfile, is_hunk, is_setpref, is_merger,
               is_binary, gzWritePatch, writePatch, is_adddir,
               invert, commute, merge,
               readPatchPS,
               canonize, reorder_and_coalesce, submerge_in_dir, flatten,
               flatten_to_primitives, try_to_shrink,
               apply_to_slurpy, patchname, unjoin_patches,
               apply_to_filepaths, apply_to_filepath, force_replace_slurpy,
               patch2patchinfo,
               LineMark(AddedLine, RemovedLine, AddedRemovedLine, None),
               MarkedUpFile, markup_file, empty_markedup_file,
               patch_summary, xml_summary,
               adddeps, getdeps,
               list_conflicted_files, list_touched_files,
               resolve_conflicts,
               merger_equivalent,
               -- for Population
               DirMark(..), patchChanges, applyToPop,
               -- for PatchTest
               unravel, merger, glump, elegant_merge,
             ) where
import PopulationData ( DirMark(..) )
import PatchCore ( Patch,
                   adddeps, adddir, addfile, binary, changepref,
                   hunk, move, namepatch, rmdir, rmfile, tokreplace,
                   join_patches, unjoin_patches, getdeps,
                   null_patch, is_null_patch, infopatch, invert,
                   eq_patches, flatten, flatten_to_primitives, is_adddir,
                   is_addfile, is_hunk, is_binary, is_merger, is_setpref,
                   is_similar, patch2patchinfo, patchname )
import PatchRead ( readPatchPS )
import PatchShow ( writePatch, gzWritePatch, showPatch )
import PatchViewing ( patch_summary, xml_summary, patch_description,
                      showContextPatch )
import PatchApply ( applyToPop, patchChanges, empty_markedup_file,
                    markup_file, force_replace_slurpy,
                    apply_to_filepath, apply_to_filepaths, apply_to_slurpy,
                    LineMark(..), MarkedUpFile )
import PatchCommute ( merge, elegant_merge, submerge_in_dir,
                      merger, merger_equivalent, glump, unravel,
                      resolve_conflicts, reorder_and_coalesce, canonize,
                      commute, list_touched_files, list_conflicted_files,
                      try_to_shrink )
\end{code}

\input{PatchApply.lhs}
\input{PatchCore.lhs}
\input{PatchCommute.lhs}
\input{PatchShow.lhs}

