/*
 * GQmpeg
 * (C)1998, 1999 John Ellis
 *
 * Author: John Ellis
 *
 * This software is released under the GNU General Public License.
 * Please read the included file COPYING for more information.
 * This software comes with no warranty of any kind, use at you own risk!
 */

typedef struct _IO_ModuleData IO_ModuleData;
struct _IO_ModuleData
{
	gchar *title;
	gchar *description;

	void (* songdata_init_func)(SongData *sd);
	gint (* songdata_info_func)(SongData *sd, gint generic_info, gint format_info);

	gint (* start_func)(SongData *sd, gint position);
	gint (* stop_func)(SongData *sd);

	gint (* pause_func)(SongData *sd);
	gint (* continue_func)(SongData *sd);

	gint (* seek_func)(SongData *sd, gint position);

	void (* config_load_func)(FILE *f, gchar *option, gchar *value, gchar *value_all);
	void (* config_save_func)(FILE *f);

	GtkWidget *(* config_init_func)(void);
	void (* config_apply_func)(void);
	void (* config_close_func)(void);

	GtkWidget *(* info_func)(gchar *name);
};

/*
 *----------------------------------------------------------------------------
 * misc module interface functions
 *----------------------------------------------------------------------------
 */

gint player_module_register(IO_ModuleData *imd);
void module_register_file_suffix_type(gchar *extension, gchar *description, gint module_id);
void module_register_misc_type(gchar *format, gchar *description, gint module_id, gint live,
			       gint (*is_type_func)(gchar *),
			       GtkWidget *(*entry_setup_func)(gchar *),
			       GtkWidget *(*edit_func)(SongData *),
			       gchar *(*get_path_func)(GtkWidget *));
void module_playback_end();
void module_playback_error();

/*
 *----------------------------------------------------------------------------
 * the various init functions for eachplayer module
 *----------------------------------------------------------------------------
 */

void mpg123_init();

