/*
** Beaver's an Early AdVanced EditoR
** (C) 1999-2000 Marc Bevand, Damien Terrier and Emmanuel Turquin
**
** tools.c
**
** Author<s>:     Emmanuel Turquin (aka "Ender") <turqui_e@epita.fr>
** Latest update: Fri Jun  2 01:08:28 2000
** Description:   Beaver tools source
**
** This program is free software; you can redistribute it and/or modify
** it under the terms of the GNU General Public License as published by
** the Free Software Foundation; either version 2 of the License, or
** (at your option) any later version.
**
** This program is distributed in the hope that it will be useful,
** but WITHOUT ANY WARRANTY; without even the implied warranty of
** MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
** GNU General Public License for more details.
**
** You should have received a copy of the GNU General Public License
** along with this program; if not, write to the Free Software
** Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/

#include <gtk/gtk.h>
#include <time.h>
#include <string.h>
#include <sys/stat.h>
#include <stdio.h>
#include <stdlib.h>
#include "main.h"
#include "interface.h"
#include "filesops.h"
#include "editor.h"
#include "struct.h"
#include "msgbar.h"
#include "search.h"
#include "tools.h"
#include "conf.h"

extern GtkWidget *MainNotebook;
extern GArray *FileProperties;
extern gint OpenedFilesCnt;
static GtkWidget *Entry[4];

static const gchar *FormatTypeStrings[3] = {"UNIX", "MAC", "DOS"};

/* Returns the number of characters in the view */

gint get_num_characters (GtkTextView *Text)
{
  return gtk_text_buffer_get_char_count(
    gtk_text_view_get_buffer(Text));
}


/* Returns the beginning of the current selection */

gint min_from_selection (GtkTextView *Text)
{
  GtkTextIter start;
  GtkTextBuffer *Buffer;

  Buffer = gtk_text_view_get_buffer(Text);
  gtk_text_buffer_get_selection_bounds (Buffer, &start, NULL);
	
  return gtk_text_iter_get_offset (&start);
}


/* Returns the end of the current selection */

gint max_from_selection (GtkTextView *Text)
{
  GtkTextIter end;
  GtkTextBuffer *Buffer;
	
  Buffer = gtk_text_view_get_buffer(Text);
  gtk_text_buffer_get_selection_bounds (Buffer, NULL, &end);
	
  return gtk_text_iter_get_offset (&end);
}


/* Returns the string that is currently selected */

gchar *get_selection (GtkTextBuffer *Buffer)
{
  GtkTextIter start, end;
  gchar *selected_str;
  
  gtk_text_buffer_get_selection_bounds (Buffer, &start, &end);
  selected_str = gtk_text_buffer_get_slice(Buffer, 
	           &start, &end, FALSE);
  
  return selected_str;
}


/* Returns the contents of the buffer; must be g_free'd */

gchar *get_text (GtkTextBuffer *Buffer)
{
  GtkTextIter start, end;
  gchar *str;
  
  gtk_text_buffer_get_bounds (Buffer, &start, &end);
  str = gtk_text_buffer_get_slice(Buffer, 
	           &start, &end, FALSE);
  
  return str;
}

/* Replaces the currently selected text with new text */

void replace_selection (GtkTextBuffer *Buffer, const gchar *str)
{
  GtkTextIter start, end;
  
  /*START_FCN causes segfault*/

  gtk_text_buffer_get_selection_bounds(Buffer, &start, &end);
  replace_text (Buffer, &start, &end, str);
	
  /*END_FCN*/
}

/* Replaces the indicated text with new text; reinitializes start and end to
  point to beginning and end of inserted text*/

void replace_text (GtkTextBuffer *Buffer, GtkTextIter *start, GtkTextIter *end, const gchar *text)
{
  GtkTextMark *mark;
  
  START_FCN
  
  gtk_text_buffer_begin_user_action (Buffer);
  gtk_text_buffer_delete (Buffer, start, end);
  mark = gtk_text_buffer_create_mark (Buffer, NULL, start, TRUE);
  gtk_text_buffer_insert (Buffer, end, text, -1);
  gtk_text_buffer_get_iter_at_mark (Buffer, start, mark);
  gtk_text_buffer_delete_mark (Buffer, mark);
  gtk_text_buffer_end_user_action (Buffer);
  
  END_FCN
}


/* Returns the offset of the cursor */

gint get_position (GtkTextBuffer *Buffer)
{
  GtkTextIter current;
  
  gtk_text_buffer_get_iter_at_mark (Buffer, &current,
           gtk_text_buffer_get_insert (Buffer));
  
  return gtk_text_iter_get_offset (&current);
}

/* Returns the iter where the cursor is */

GtkTextIter get_cursor_iter (GtkTextBuffer *Buffer)
{
  GtkTextIter current;
  
  gtk_text_buffer_get_iter_at_mark (Buffer, &current,
           gtk_text_buffer_get_insert (Buffer));
  
  return current;
}


/* Returns the text between the two offsets */

gchar *get_chars (GtkTextBuffer *Buffer, gint left, gint right)
{
  GtkTextIter start, end;
  
  gtk_text_buffer_get_iter_at_offset (Buffer, &start, left);
  gtk_text_buffer_get_iter_at_offset (Buffer, &end, right);
  
  return gtk_text_buffer_get_text (Buffer, &start, &end, FALSE);
}


/* A few Case manipulations functions */

void change_case (gint UpDown)
{
  gint CurrentPage, l_min, l_max;
  gchar *buffer, *newtext = NULL;

  CurrentPage = gtk_notebook_get_current_page (GTK_NOTEBOOK(MainNotebook));
  l_min = min_from_selection (GTK_TEXT_VIEW(FPROPS(CurrentPage, Text)));
  l_max = max_from_selection (GTK_TEXT_VIEW(FPROPS(CurrentPage, Text)));
  buffer = get_selection (FPROPS(CurrentPage, Buffer));
  if (UpDown == 1) newtext = g_utf8_strup (buffer, -1);
  else if (UpDown == 2) newtext = g_utf8_strdown (buffer, -1);
  else if (UpDown == 3)
    {
      gint l_len, i, j;
      gchar *Delimiters = " \t\b\n\f\'\"{}()[]<>%^&*~-+=_@#$\\|/:;,.?!";

      l_len = l_max - l_min;
      if ((buffer[0] >= 'a') && (buffer[0] <= 'z'))
	buffer[0] = buffer[0] - 'a' + 'A';
      for (i = 1; i < l_len; i++)
	{
	  for (j = 0; j <= (gint)strlen (Delimiters); j++)
	    {
	      if (buffer [i] == Delimiters[j])
		{
		  if ((buffer[i+1] >= 'a') && (buffer[i+1] <= 'z'))
		    buffer[i+1] = buffer[i+1] - 'a' + 'A';
		  break;
		}
	    }
	}
	newtext = g_strdup (buffer);
    }
  else if (UpDown == 4)
    {
      gint l_len, change_case, i;

      l_len = l_max - l_min;
      change_case = 'a' - 'A';
      for (i = 0; i <= l_len; i++)
	{
	  if ((buffer[i] >= 'A') && (buffer[i] <= 'Z'))
	    buffer[i] = buffer[i] + change_case;
	  else if ((buffer[i] >= 'a') && (buffer[i] <= 'z'))
	    buffer[i] = buffer[i] - change_case;
	}
	newtext = g_strdup (buffer);
    }
  replace_selection(FPROPS(CurrentPage, Buffer), newtext);
  g_free (buffer);
  g_free (newtext);
}


/* Well, this function just... inserts time! How surprising! ;) */

void insert_time (gint CurrentPage)
{
  time_t Time;
  char *str_time;

  if ((!OpenedFilesCnt) || FPROPS(CurrentPage, ReadOnly))
    return;
  Time = time (NULL);
  str_time = ctime (&Time);
  if (str_time[strlen (str_time) - 1] == '\n')
	str_time[strlen (str_time) - 1] = '\0';
  replace_selection(FPROPS(CurrentPage, Buffer), str_time);
  print_msg ("Insert Time...");
}



/* Convert & refresh the display of the Converter */

void refresh_converter (GtkWidget *Widget, gpointer data)
{
  gchar *NumberString;
  gint i = 0, j = 1;
  gulong Number = 0;
  gint EntryID = GPOINTER_TO_INT (data);

  NumberString = g_strdup (gtk_entry_get_text (GTK_ENTRY (Entry[EntryID-1])));
  if (EntryID == 1)
    {
      if ((strlen (NumberString) == 10) &&
	  (g_strcasecmp (NumberString, "4294967295") > 0))
	{
	  if (g_strcasecmp (NumberString, "9999999999") <= 0)
	    {
	      Number = ~0; /* <-- Max Unsigned Long Integer */
	    }
	  else
	    {
	      Number = 0; /* <-- Min Unsigned Long Integer */
	    }
	}
      else
	{
	  g_strreverse (NumberString);
	  while ((NumberString[i] >= '0') && (NumberString[i] <= '9'))
	    {
	      Number = Number + (NumberString[i] - '0')*j;
	      j *= 10;
	      i++;
	    }
	  if (NumberString[i] != '\0')
	    Number = 0; /* <-- Min Unsigned Long Integer */
	}
    }
  if (EntryID == 2)
    {
      g_strreverse (NumberString);

      while ((NumberString[i] == '0') || (NumberString[i] == '1'))
	{
	  Number = Number + (NumberString[i] - '0')*j;
	  j *= 2;
	  i++;
	}
      if (NumberString[i] != '\0')
	Number = 0; /* <-- Min Unsigned Long Integer */
    }
  if (EntryID == 3)
    {
      if ((strlen (NumberString) == 11) &&
	  (g_strcasecmp (NumberString, "37777777777") > 0))
	{
	  if (g_strcasecmp (NumberString, "77777777777") <= 0)
	    {
	      Number = ~0; /* <-- Max Unsigned Long Integer */
	    }
	  else
	    {
	      Number = 0; /* <-- Min Unsigned Long Integer */
	    }
	}
      else
	{
	  g_strreverse (NumberString);
	  while ((NumberString[i] >= '0') && (NumberString[i] <= '7'))
	    {
	      Number = Number + (NumberString[i] - '0')*j;
	      j *= 8;
	      i++;
	    }
	  if (NumberString[i] != '\0')
	    Number = 0; /* <-- Min Unsigned Long Integer */
	}
    }
  if (EntryID == 4)
    {
      gint Zero;

      g_strreverse (NumberString);
      while (((NumberString[i] >= '0') && (NumberString[i] <= '9')) ||
	     ((NumberString[i] >= 'a') && (NumberString[i] <= 'f')) ||
	     ((NumberString[i] >= 'A') && (NumberString[i] <= 'F')))
	{
	  if ((NumberString[i] >= '0') && (NumberString[i] <= '9'))
	    Zero = '0';
	  else if ((NumberString[i] >= 'a') && (NumberString[i] <= 'f'))
	    Zero = 'a' - 10;
	  else
	    Zero = 'A' - 10;
	  Number = Number + (NumberString[i] - Zero)*j;
	  j *= 16;
	  i++;
	}
      if (NumberString[i] != '\0')
	Number = 0; /* <-- Min Unsigned Long Integer */
    }
  gtk_entry_set_text (GTK_ENTRY (Entry[0]),
		      g_strdup_printf ("%lu", Number));
  gtk_entry_set_text (GTK_ENTRY (Entry[2]),
		      g_strdup_printf ("%lo", Number));
  gtk_entry_set_text (GTK_ENTRY (Entry[3]),
		      g_strdup_printf ("%lx", Number));
  if (Number)
    {
      gint Bit;

      gtk_entry_set_text (GTK_ENTRY (Entry[1]), "");
      while (Number > 0)
	{
	  Bit = Number % 2;
	  Number = Number / 2;
	  gtk_entry_prepend_text (GTK_ENTRY (Entry[1]),
				  g_strdup_printf ("%d", Bit));
	}
    }
  else
    gtk_entry_set_text (GTK_ENTRY (Entry[1]), "0");
  
  g_free (NumberString);
  (void)Widget; /* avoid the "unused parameter" warning */
}


/* Display a Decimal, Binary, Octal, HexaDecimal Converter */

void converter (void)
{
  GtkWidget *ConverterWindow;
  GtkWidget *Table;
  GtkWidget *Label;
  GtkWidget *Button;
  gint i;

  ConverterWindow = gtk_dialog_new ();
  gtk_window_set_title (GTK_WINDOW(ConverterWindow), "Base Converter");
  /* setting the window modal means, that it stays on top and that the 
   * other windows can't be used, therefore avoiding having to 
   * ColorPickers at the same time */
  gtk_window_set_modal (GTK_WINDOW (ConverterWindow), TRUE);
  gtk_window_set_policy (GTK_WINDOW(ConverterWindow), FALSE, FALSE, FALSE);
  g_signal_connect_swapped (G_OBJECT(ConverterWindow), "delete_event",
			     (GtkSignalFunc) gtk_widget_destroy,
			     G_OBJECT(ConverterWindow));
  g_signal_connect_swapped (G_OBJECT (ConverterWindow), "destroy",
			     (GtkSignalFunc) gtk_widget_destroy,
			     G_OBJECT(ConverterWindow));
  Table = gtk_table_new (4, 3, FALSE);
  gtk_box_pack_start (GTK_BOX(GTK_DIALOG(ConverterWindow) -> vbox),
		      Table, FALSE, FALSE, 0);
  gtk_table_set_row_spacings (GTK_TABLE(Table), 5);
  gtk_table_set_col_spacings (GTK_TABLE(Table), 5);
  gtk_container_set_border_width (GTK_CONTAINER(Table), 10);
  Label = gtk_label_new ("Decimal :");
  gtk_table_attach_defaults (GTK_TABLE(Table), Label, 0, 1, 0, 1);  
  Label = gtk_label_new ("Binary :");
  gtk_table_attach_defaults (GTK_TABLE(Table), Label, 0, 1, 1, 2);
  Label = gtk_label_new ("Octal :");
  gtk_table_attach_defaults (GTK_TABLE(Table), Label, 0, 1, 2, 3);
  Label = gtk_label_new ("Hexa :");
  gtk_table_attach_defaults (GTK_TABLE(Table), Label, 0, 1, 3, 4);
  for (i = 1; i <= 4; i++)
    {
      Entry[i-1] = gtk_entry_new ();
      gtk_table_attach_defaults (GTK_TABLE(Table), Entry[i-1], 1, 2, i-1, i);
      if (i == 1)
	gtk_entry_set_max_length (GTK_ENTRY(Entry[i-1]), 10);
      if (i == 2)
	gtk_entry_set_max_length (GTK_ENTRY(Entry[i-1]), 32);
      if (i == 3)
	gtk_entry_set_max_length (GTK_ENTRY(Entry[i-1]), 11);
      if (i == 4)
	gtk_entry_set_max_length (GTK_ENTRY(Entry[i-1]), 8);
      Button = gtk_button_new_with_label ("Convert");
      gtk_table_attach_defaults (GTK_TABLE(Table), Button, 2, 3, i-1, i);
      g_signal_connect (G_OBJECT(Button), "clicked",
			  G_CALLBACK (refresh_converter),
			  GINT_TO_POINTER (i));
      g_signal_connect(G_OBJECT(Entry[i-1]), "activate",
			     G_CALLBACK (refresh_converter),
			     GINT_TO_POINTER (i));
    }
  Button = gtk_button_new_from_stock (GTK_STOCK_CLOSE);
  g_signal_connect_swapped (G_OBJECT(Button), "clicked",
			     (GtkSignalFunc) gtk_widget_destroy,
			     G_OBJECT(ConverterWindow));
  GTK_WIDGET_SET_FLAGS (Button, GTK_CAN_DEFAULT);
  gtk_box_pack_start (GTK_BOX(GTK_DIALOG(ConverterWindow) -> action_area),
		      Button, TRUE, TRUE, 0);
  //gtk_widget_grab_default (Button);
  gtk_widget_show_all (ConverterWindow);
  print_msg ("Display Base Converter...");
}

/* Insert an hexadecimal color code */

void insert_color (GtkColorSelection *csd)
{
  gdouble Color[3];
  gint CurrentPage;
  gchar *ColorString;

  CurrentPage = gtk_notebook_get_current_page (GTK_NOTEBOOK(MainNotebook));
  if ((!OpenedFilesCnt) || FPROPS(CurrentPage, ReadOnly))
    return;
  gtk_color_selection_get_color (csd, Color);
  ColorString = g_strdup_printf ("%02x%02x%02x",
				 (guint)(255 * Color[0]),
				 (guint)(255 * Color[1]),
				 (guint)(255 * Color[2]));
  replace_selection(FPROPS(CurrentPage, Buffer), ColorString);
  print_msg ("Insert Color...");
}


/* Display a Color Picker */
void color_picker (void)
{
  /* create new Color Picker */
  GtkColorSelectionDialog *ColorWindow;
  ColorWindow = (GtkColorSelectionDialog *)gtk_color_selection_dialog_new
    ("Color Picker");

  /* setting the window modal means, that it stays on top and that the 
   * other windows can't be used, therefore avoiding having to 
   * ColorPickers at the same time */
  gtk_window_set_modal (GTK_WINDOW (ColorWindow), TRUE);

  /* connect the window */
  g_signal_connect_swapped (G_OBJECT(ColorWindow), "delete_event",
			     (GtkSignalFunc) gtk_widget_destroy,
			     G_OBJECT(ColorWindow));
	
  /* rename the "Ok" button to "Insert" and connect it */
  gtk_button_set_label (GTK_BUTTON(ColorWindow -> ok_button), "Insert");
  g_signal_connect_swapped (G_OBJECT(ColorWindow -> ok_button), "clicked",
			     (GtkSignalFunc)insert_color,
			     G_OBJECT(ColorWindow -> colorsel));
			     
  /* connect "Cancel" button */
  g_signal_connect_swapped (G_OBJECT(ColorWindow -> cancel_button),
			     "clicked",
			     (GtkSignalFunc)gtk_widget_destroy,
			     G_OBJECT(ColorWindow));
			     
  /* we dont' want the "Help" button */
  gtk_widget_hide (ColorWindow -> help_button);
 
  /* Show the ColorPicker and show a message */
  gtk_widget_show (GTK_WIDGET(ColorWindow));
  print_msg ("Display Color Picker...");
}



/* File conversion functions */

void convert_all(void (*conv_func)(void))
{
  gint CurrentPage, i;

  if (!OpenedFilesCnt) return;
  CurrentPage = gtk_notebook_get_current_page (GTK_NOTEBOOK(MainNotebook));
  for (i = 0; i < OpenedFilesCnt; i++)
    if (!FPROPS(CurrentPage, ReadOnly))
      {
	gtk_notebook_set_page (GTK_NOTEBOOK(MainNotebook), i);
	conv_func ();
      }
  gtk_notebook_set_page (GTK_NOTEBOOK(MainNotebook), CurrentPage);
}

void conv_unix_to_dos (void)
{
  gint CurrentPage;
  
  CurrentPage = gtk_notebook_get_current_page (GTK_NOTEBOOK(MainNotebook));
  
  if (FPROPS(CurrentPage, Format) != UNIX)
    return;
  
  FPROPS(CurrentPage, Format) = DOS;
  replace_all (CurrentPage, TRUE, FALSE, 0, "\n", "\r\n");
  note_format ();
  print_msg ("File converted from UNIX to DOS Format...");
}


void conv_dos_to_unix (void)
{
  gint CurrentPage;
  
  CurrentPage = gtk_notebook_get_current_page (GTK_NOTEBOOK(MainNotebook));
  
  if (FPROPS(CurrentPage, Format) != DOS)
    return;
  
  FPROPS(CurrentPage, Format) = UNIX;
  replace_all (CurrentPage, TRUE, FALSE, 0, "\r\n", "\n");
  note_format ();
  print_msg ("File converted from DOS to UNIX Format...");
}


void conv_dos_to_mac (void)
{
  gint CurrentPage;
  
  CurrentPage = gtk_notebook_get_current_page (GTK_NOTEBOOK(MainNotebook));
  
  if (FPROPS(CurrentPage, Format) != DOS)
    return;
  
  FPROPS(CurrentPage, Format) = MAC;
  replace_all (CurrentPage, TRUE, FALSE, 0, "\r\n", "\r");
  note_format ();
  print_msg ("File converted from DOS to MAC Format...");
}


void conv_mac_to_unix (void)
{
  gint CurrentPage;
  
  CurrentPage = gtk_notebook_get_current_page (GTK_NOTEBOOK(MainNotebook));
  
  if (FPROPS(CurrentPage, Format) != MAC)
    return;
  
  FPROPS(CurrentPage, Format) = UNIX;
  replace_all (CurrentPage, TRUE, FALSE, 0, "\r", "\n");
  note_format ();
  print_msg ("File converted from MAC to UNIX Format...");
}


void conv_unix_to_mac (void)
{
  gint CurrentPage;
  
  CurrentPage = gtk_notebook_get_current_page (GTK_NOTEBOOK(MainNotebook));
  
  if (FPROPS(CurrentPage, Format) != UNIX)
    return;
  
  FPROPS(CurrentPage, Format) = MAC;
  replace_all (CurrentPage, TRUE, FALSE, 0, "\n", "\r");
  note_format ();
  print_msg ("File converted from UNIX to MAC Format...");
}


void conv_mac_to_dos (void)
{
  gint CurrentPage;
  
  CurrentPage = gtk_notebook_get_current_page (GTK_NOTEBOOK(MainNotebook));
  
  if (FPROPS(CurrentPage, Format) != MAC)
    return;
  
  FPROPS(CurrentPage, Format) = DOS;
  replace_all (CurrentPage, TRUE, FALSE, 0, "\r", "\r\n");
  note_format ();
  print_msg ("File converted from MAC to DOS Format...");
}

void convert_this_to_dos (void)
{
	gint CurrentPage = gtk_notebook_get_current_page (GTK_NOTEBOOK(MainNotebook));
	switch (FPROPS(CurrentPage, Format))
	{
	case UNIX:
		conv_unix_to_dos ();
		break;
	case MAC:
		conv_mac_to_dos ();
		break;
	default:
		break;
	}
}

void convert_this_to_mac (void)
{
	gint CurrentPage = gtk_notebook_get_current_page (GTK_NOTEBOOK(MainNotebook));
	switch (FPROPS(CurrentPage, Format))
	{
	case UNIX:
		conv_unix_to_mac ();
		break;
	case DOS:
		conv_dos_to_mac ();
		break;
	default:
		break;
	}
}

void convert_this_to_unix (void)
{
	gint CurrentPage = gtk_notebook_get_current_page (GTK_NOTEBOOK(MainNotebook));
	switch (FPROPS(CurrentPage, Format))
	{
	case MAC:
		conv_mac_to_unix ();
		break;
	case DOS:
		conv_dos_to_unix ();
		break;
	default:
		break;
	}
}

gint get_format_type (gint CurrentPage)
{
  gchar *string = get_text (FPROPS(CurrentPage, Buffer));
  gint rv;
  
  if (strstr (string, "\r\n"))
    rv = DOS;
  else if (strchr (string, '\r'))
    rv = MAC;
  else
    rv = UNIX; /* default is UNIX */
  
  g_free (string);
  return rv;
}


/* Display a 'File Information' Dialog box */

void file_info (gint CurrentPage)
{
  GtkWidget *FileInfoWindow;
  GtkWidget *Button;
  GtkWidget *HBox;
  GtkWidget *FileInfoLabelLeft, *FileInfoLabelRight;
  gint BufferSize, FileSize, Difference;
  gboolean NewFile = FALSE;
  
  if (!OpenedFilesCnt) return;
  if (stat (FPROPS(CurrentPage, Name), &FPROPS(CurrentPage, Stats)) == -1)
    NewFile = TRUE;
  BufferSize = gtk_text_buffer_get_char_count(
    gtk_text_view_get_buffer(GTK_TEXT_VIEW(FPROPS(CurrentPage, Text))));
  FileSize = NewFile ? 0 : (gint)FPROPS(CurrentPage, Stats).st_size;
  Difference = BufferSize - FileSize;
  FileInfoWindow = gtk_dialog_new ();
  gtk_window_set_title (GTK_WINDOW(FileInfoWindow), "File Information"); 
  gtk_window_set_policy (GTK_WINDOW(FileInfoWindow), FALSE, FALSE, FALSE);
  g_signal_connect_swapped (G_OBJECT(FileInfoWindow), "delete_event",
			     (GtkSignalFunc) gtk_widget_destroy,
			     G_OBJECT(FileInfoWindow));
  g_signal_connect_swapped (G_OBJECT (FileInfoWindow), "destroy",
			     (GtkSignalFunc) gtk_widget_destroy,
			     G_OBJECT(FileInfoWindow));
  HBox = gtk_hbox_new (FALSE, 0);
  gtk_container_set_border_width (GTK_CONTAINER(HBox), 5);
  FileInfoLabelLeft = gtk_label_new
    ("Base name :"
     "\nFull name :"
     "\nLanguage :"
     "\nFormat :"
     "\n"
     "\nModified :"
     "\nReadonly :"
     "\n"
     "\nBuffer Size :"
     "\nFile Size :"
     "\nDifference :"
#ifndef WIN32
     "\n"
     "\nPermissions :"
     "\nOwner UID :"
     "\nOwner GID :"
#endif
       );
  gtk_label_set_justify (GTK_LABEL(FileInfoLabelLeft), GTK_JUSTIFY_LEFT); 
  FileInfoLabelRight = gtk_label_new
    (g_strconcat
     (FPROPS(CurrentPage, BaseName),
      "\n", FPROPS(CurrentPage, Name),
      "\n", FPROPS(CurrentPage, WidgetInfo.Lg) == -1 ?
      UNKNOWN : Prefs.L[FPROPS(CurrentPage, WidgetInfo.Lg)].Description,
      "\n", FormatTypeStrings[FPROPS(CurrentPage, Format)],
      "\n",
      "\n", gtk_text_buffer_get_modified (FPROPS(CurrentPage, Buffer)) ? "Yes" : "No",
      "\n", FPROPS(CurrentPage, ReadOnly) ? "Yes" : "No",
      "\n",
      "\n", g_strdup_printf ("%d", BufferSize),
      ((BufferSize == -1) || (BufferSize == 0) || (BufferSize == 1)) ?
      " Byte" : " Bytes",
      "\n", g_strdup_printf ("%d", FileSize),
      ((FileSize == -1) || (FileSize == 0) || (FileSize == 1)) ?
      " Byte" : " Bytes",
      "\n", g_strdup_printf ("%d", Difference),
      ((Difference == -1) || (Difference == 0) || (Difference == 1)) ?
      " Byte" : " Bytes",
#ifndef WIN32
      "\n",
      "\n", NewFile ?
      UNKNOWN : get_file_mode (FPROPS(CurrentPage, Stats)),
      "\n", NewFile ?
      UNKNOWN : g_strdup_printf ("%d", FPROPS(CurrentPage, Stats).st_uid),
      "\n", NewFile ?
      UNKNOWN : g_strdup_printf ("%d", FPROPS(CurrentPage, Stats).st_gid),
#endif
      NULL));
  gtk_label_set_justify (GTK_LABEL(FileInfoLabelRight), GTK_JUSTIFY_LEFT);
  gtk_box_pack_start (GTK_BOX(HBox), FileInfoLabelLeft, FALSE, FALSE, 5);
  gtk_box_pack_start (GTK_BOX(HBox), FileInfoLabelRight, FALSE, FALSE, 5);
  gtk_box_pack_start (GTK_BOX(GTK_DIALOG(FileInfoWindow) -> vbox),
		      HBox, FALSE, FALSE, 5);
  Button = gtk_button_new_from_stock (GTK_STOCK_OK);
  g_signal_connect_swapped (G_OBJECT(Button), "clicked",
			     (GtkSignalFunc) gtk_widget_destroy,
			     G_OBJECT(FileInfoWindow));
  GTK_WIDGET_SET_FLAGS (Button, GTK_CAN_DEFAULT);
  gtk_box_pack_start (GTK_BOX(GTK_DIALOG(FileInfoWindow) -> action_area),
		      Button, TRUE, TRUE, 0);
  gtk_widget_grab_default (Button);
  gtk_widget_show_all (FileInfoWindow);
  print_msg ("Display File Information window...");
}


/* Print function */

void print_buffer (void)
{
  FILE *File;
  gint CurrentPage;
  char *TempName, *PrintCmd;

  if (!OpenedFilesCnt)
    return;
  CurrentPage = gtk_notebook_get_current_page (GTK_NOTEBOOK(MainNotebook));
  if (!gtk_text_buffer_get_char_count(FPROPS(CurrentPage, Buffer)))
    {
      print_msg ("Nothing to print !");
      return;
    }
  if (!gtk_text_buffer_get_modified (FPROPS(CurrentPage, Buffer)))
    {
      PrintCmd = g_strconcat (get_string_conf ("General/Misc/PrintCommand"),
			      " \"", FPROPS(CurrentPage, Name), "\"", NULL);
      print_msg (g_strconcat ("File \"", FPROPS(CurrentPage, Name),
			      "\" is being printed...", NULL));
    }
  else
    {
      gchar *buffer;
      
      TempName = g_strconcat
	(TEMP_DIR, TEMP_PREFIX, FPROPS(CurrentPage, BaseName), NULL);
      if (!(File = fopen (TempName, "w")))
	{
	  print_msg (g_strconcat ("Buffer \"", FPROPS(CurrentPage, BaseName),
				  "\" cannot be printed", NULL));
	  g_free (TempName);
	  return;
	}
      buffer = get_text(FPROPS(CurrentPage, Buffer));
      fwrite (buffer, gtk_text_buffer_get_char_count(
              FPROPS(CurrentPage, Buffer)), 1, File);
      g_free (buffer);
      fclose (File);
      PrintCmd = g_strconcat(get_string_conf
			     ("General/Misc/PrintCommand"),
			     " \"", TempName,"\"", NULL);
      print_msg (g_strconcat ("Buffer \"", FPROPS(CurrentPage, BaseName),
			      "\" is being printed...", NULL));
      g_free (TempName);
    }
  if (system (PrintCmd))
    print_msg (g_strconcat ("Problem encountered while trying to print", NULL));
  g_free (PrintCmd);
}
