/*

Copyright (C) 2000 - 2007 Christian Kreibich <christian@whoop.org>.

Permission is hereby granted, free of charge, to any person obtaining a copy
of this software and associated documentation files (the "Software"), to
deal in the Software without restriction, including without limitation the
rights to use, copy, modify, merge, publish, distribute, sublicense, and/or
sell copies of the Software, and to permit persons to whom the Software is
furnished to do so, subject to the following conditions:

The above copyright notice and this permission notice shall be included in
all copies of the Software and its documentation and acknowledgment shall be
given in the documentation and software packages that this Software was
used.

THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL
THE AUTHORS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER
IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN
CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.

*/

#include <nd.h>
#include <nd_gui.h>
#include <nd_dialog.h>

#include <nd_arp.h>
#include <nd_arp_callbacks.h>


void    
nd_arp_hrd_cb(LND_Packet  *packet,
	      guchar      *header,
	      guchar      *data)
{
  static GtkWidget *menu = NULL;

  if (!menu)
    menu = nd_gui_create_menu(arp_menu_hrd_data);
  
  gtk_menu_popup(GTK_MENU(menu), NULL, NULL, NULL, NULL, 0, 0);
  
  return;
  TOUCH(header);
  TOUCH(packet);
  TOUCH(data);
}


void    
nd_arp_pro_cb(LND_Packet  *packet,
	      guchar      *header,
	      guchar      *data)
{
  ND_ProtoCallbackData *cb_data;
  struct arphdr *arphdr;

  arphdr = (struct arphdr *) header;
  cb_data = nd_proto_cb_data_new(nd_arp_get(), data, data-header, FALSE);

  nd_dialog_number(_("Enter 16-bit protocol type:"),
		   ND_BASE_HEX,
		   ntohs(arphdr->ar_pro), 65535,
		   nd_proto_iterate_16bit_cb,
		   NULL,
		   packet,
		   cb_data);
}


void    
nd_arp_hln_cb(LND_Packet  *packet,
	      guchar      *header,
	      guchar      *data)
{
  ND_ProtoCallbackData *cb_data;
  struct arphdr *arphdr;

  arphdr = (struct arphdr *) header;
  cb_data = nd_proto_cb_data_new(nd_arp_get(), data, data-header, TRUE);

  nd_dialog_number(_("Enter 8-bit hardware address length:"),
		   ND_BASE_DEC,
		   arphdr->ar_hln, 255,
		   nd_proto_iterate_8bit_cb,
		   NULL,
		   packet,
		   cb_data);
}


void    
nd_arp_pln_cb(LND_Packet  *packet,
	      guchar      *header,
	      guchar      *data)
{
  ND_ProtoCallbackData *cb_data;
  struct arphdr *arphdr;

  arphdr = (struct arphdr *) header;
  cb_data = nd_proto_cb_data_new(nd_arp_get(), data, data-header, TRUE);

  nd_dialog_number(_("Enter 8-bit protocol address length:"),
		   ND_BASE_DEC,
		   arphdr->ar_pln, 255,
		   nd_proto_iterate_8bit_cb,
		   NULL,
		   packet,
		   cb_data);
}


void    
nd_arp_op_cb(LND_Packet  *packet,
	     guchar      *header,
	     guchar      *data)
{
  static GtkWidget *menu = NULL;

  if (!menu)
    menu = nd_gui_create_menu(arp_menu_op_data);
  
  gtk_menu_popup(GTK_MENU(menu), NULL, NULL, NULL, NULL, 0, 0);
  
  return;
  TOUCH(header);
  TOUCH(packet);
  TOUCH(data);
}


static void
arp_sha_okay_cb(guchar     *address,
		int         address_len,
		LND_Packet *packet,
		void       *user_data)
{
  LND_Trace          *trace;
  LND_PacketIterator  pit;
  struct arphdr      *arphdr;

  if (! (trace = libnd_packet_get_trace(packet)))
    return;

  for (libnd_pit_init(&pit, trace); libnd_pit_get(&pit); libnd_pit_next(&pit))
    {
      arphdr = (struct arphdr *) libnd_packet_get_data(libnd_pit_get(&pit), nd_arp_get(), 0);
      if (!arphdr)
	continue;
  
      memcpy(((guchar *)arphdr) + 8, address, address_len);
      libnd_packet_modified(libnd_pit_get(&pit));
    }
  
  return;
  TOUCH(user_data);
}

void    
nd_arp_sha_cb(LND_Packet  *packet,
	      guchar      *header,
	      guchar      *data)
{
  struct arphdr *arphdr;

  arphdr = (struct arphdr *) header;
  nd_dialog_hardware_address(_("Enter source hardware address:"),
			     ((guchar*) arphdr) + 8, arphdr->ar_hln,
			     arp_sha_okay_cb,
			     NULL,
			     packet, data);
}


static void
arp_spr_ok_cb(guchar     *address,
	      int         address_len,
	      LND_Packet *packet,
	      void       *user_data)
{
  LND_Trace          *trace;
  LND_PacketIterator  pit;
  struct arphdr      *arphdr;

  if (! (trace = libnd_packet_get_trace(packet)))
    return;

  for (libnd_pit_init(&pit, trace); libnd_pit_get(&pit); libnd_pit_next(&pit))
    {
      arphdr = (struct arphdr *) libnd_packet_get_data(libnd_pit_get(&pit), nd_arp_get(), 0);
      if (!arphdr)
	continue;
  
      memcpy(((guchar *)arphdr) + 8 + arphdr->ar_hln, address, address_len);
      libnd_packet_modified(libnd_pit_get(&pit));
    }
  
  return;
  TOUCH(user_data);
}


void    
nd_arp_spr_cb(LND_Packet  *packet,
	      guchar      *header,
	      guchar      *data)
{
  struct arphdr *arphdr;

  arphdr = (struct arphdr *) header;
  
  if (ntohs(arphdr->ar_pro) == ETHERTYPE_IP)
    {
      nd_dialog_ip(_("Enter source IP address:"),
		   ((guchar*) arphdr) + 8 + arphdr->ar_hln,
		   arp_spr_ok_cb,
		   NULL,
		   packet, data);
    }
  else
    {
      nd_dialog_hardware_address(_("Enter source protocol address:"),
				 ((guchar*) arphdr) + 8 + arphdr->ar_hln, arphdr->ar_pln,
				 arp_spr_ok_cb,
				 NULL,
				 packet, data);
    }
  
}


static void
arp_dha_okay_cb(guchar     *address,
		int         address_len,
		LND_Packet *packet,
		void       *user_data)
{
  LND_Trace          *trace;
  LND_PacketIterator  pit;
  struct arphdr      *arphdr;

  if (! (trace = libnd_packet_get_trace(packet)))
    return;

  for (libnd_pit_init(&pit, trace); libnd_pit_get(&pit); libnd_pit_next(&pit))
    {
      arphdr = (struct arphdr *) libnd_packet_get_data(libnd_pit_get(&pit), nd_arp_get(), 0);
      if (!arphdr)
	continue;
  
      memcpy(((guchar *)arphdr) + 8 + arphdr->ar_hln + arphdr->ar_pln, address, address_len);
      libnd_packet_modified(libnd_pit_get(&pit));
    }
  
  return;
  TOUCH(user_data);
}


void    
nd_arp_dha_cb(LND_Packet  *packet,
	      guchar      *header,
	      guchar      *data)
{
  struct arphdr *arphdr;

  arphdr = (struct arphdr *) header;
  nd_dialog_hardware_address(_("Enter target hardware address:"),
			     ((guchar*) arphdr) + 8 + arphdr->ar_hln + arphdr->ar_pln, arphdr->ar_hln,
			     arp_dha_okay_cb,
			     NULL,
			     packet, data);
}


static void
arp_dpr_ok_cb(guchar     *address,
	      int         address_len,
	      LND_Packet *packet,
	      void       *user_data)
{
  LND_Trace          *trace;
  LND_PacketIterator  pit;
  struct arphdr      *arphdr;

  if (! (trace = libnd_packet_get_trace(packet)))
    return;

  for (libnd_pit_init(&pit, trace); libnd_pit_get(&pit); libnd_pit_next(&pit))
    {
      arphdr = (struct arphdr *) libnd_packet_get_data(libnd_pit_get(&pit), nd_arp_get(), 0);
      if (!arphdr)
	continue;
  
      memcpy(((guchar *)arphdr) + 8 + 2 * arphdr->ar_hln + arphdr->ar_pln, address, address_len);
      libnd_packet_modified(libnd_pit_get(&pit));
    }
  
  return;
  TOUCH(user_data);
}


void    
nd_arp_dpr_cb(LND_Packet  *packet,
	      guchar      *header,
	      guchar      *data)
{
  struct arphdr *arphdr;

  arphdr = (struct arphdr *) header;
  
  if (ntohs(arphdr->ar_pro) == ETHERTYPE_IP)
    {
      nd_dialog_ip(_("Enter target IP address:"),
		   ((guchar*) arphdr) + 8 + 2 * arphdr->ar_hln + arphdr->ar_pln,
		   arp_dpr_ok_cb,
		   NULL,
		   packet, data);
    }
  else
    {
      nd_dialog_hardware_address(_("Enter target protocol address:"),
				 ((guchar*) arphdr) + 8 + 2 * arphdr->ar_hln + arphdr->ar_pln, arphdr->ar_pln,
				 arp_dpr_ok_cb,
				 NULL,
				 packet, data);
    }
  
}


/* Menu item callbacks */

void    
nd_arp_hrd_value_cb(LND_Packet  *packet,
		    guchar      *header,
		    int          value)
{
  LND_Trace          *trace;
  LND_PacketIterator  pit;
  struct arphdr      *arphdr;

  if (! (trace = libnd_packet_get_trace(packet)))
    return;

  for (libnd_pit_init(&pit, trace); libnd_pit_get(&pit); libnd_pit_next(&pit))
    {
      arphdr = (struct arphdr *) libnd_packet_get_data(libnd_pit_get(&pit), nd_arp_get(), 0);
      if (!arphdr)
	continue;
  
      arphdr->ar_hrd = htons((guint16) value);
      libnd_packet_modified(libnd_pit_get(&pit));
    }
  
  return;
  TOUCH(header);
}


void    
nd_arp_hrd_custom_cb(LND_Packet  *packet,
		     guchar      *header,
		     int          value)
{
  struct arphdr *arphdr;

  arphdr = (struct arphdr *) header;
  nd_dialog_number(_("Enter 16-bit hardware type:"),
		   ND_BASE_HEX,
		   ntohs(arphdr->ar_hrd), 65535,
		   (ND_NumberCallback) nd_arp_hrd_value_cb,
		   NULL,
		   packet,
		   header);

  return;
  TOUCH(value);
}


void    
nd_arp_op_value_cb(LND_Packet  *packet,
		   guchar      *header,
		   int          value)
{
  LND_Trace          *trace;
  LND_PacketIterator  pit;
  struct arphdr      *arphdr;

  if (! (trace = libnd_packet_get_trace(packet)))
    return;

  for (libnd_pit_init(&pit, trace); libnd_pit_get(&pit); libnd_pit_next(&pit))
    {
      arphdr = (struct arphdr *) libnd_packet_get_data(libnd_pit_get(&pit), nd_arp_get(), 0);
      if (!arphdr)
	continue;
  
      arphdr->ar_op = htons((guint16) value);
      libnd_packet_modified(libnd_pit_get(&pit));
    }
  
  return;
  TOUCH(header);
}


void    
nd_arp_op_custom_cb(LND_Packet  *packet,
		    guchar      *header,
		    int          value)
{
  struct arphdr *arphdr;

  arphdr = (struct arphdr *) header;
  nd_dialog_number(_("Enter 8-bit operation type:"),
		   ND_BASE_DEC,
		   ntohs(arphdr->ar_op), 255,
		   (ND_NumberCallback) nd_arp_op_value_cb,
		   NULL,
		   packet,
		   header);

  return;
  TOUCH(value);
}
