# This spec file creates two relocatable RPMS:
# - one for the application + user's manual
# - a devel version needed for plugin development
#
%define prefix 		/usr
%define versionmaj	0.4
%define versionmin	8a

Summary: A libpcap trace file manipulation tool.
Name: netdude
Version: %{versionmaj}.%{versionmin}
Release: 1
License: BSD
Group: Applications/Communications
URL: http://netdude.sf.net
# Using FTP to get around SourceForge's habit of adding something after .tar.gz
Source: ftp://ftp.sf.net/pub/sourceforge/netdude/%{name}-%{version}.tar.gz
BuildRoot: %{_tmppath}/%{name}-%{version}-%{release}-buildroot
Packager: Christian Kreibich <christian@whoop.org> 
Requires: libnetdude >= 0.10
Requires: gtk+
BuildRequires: gtk+-devel

Prefix: %{prefix}

%description
Netdude is the graphical front end of the network dump data
editing framework. Netdude allows users to inspect and edit
trace files to a degree that normally is only achievable by
writing code. Some of its features include scalability to
trace files of arbitrary size, ability to edit multiple traces
at the same time, fine-grained packet header and content
editing, filtering, moving, inserting and deleting packets,
tcpdump output, and a plugin mechanism.

%package devel
Summary: Header files for Netdude plugin development
Group: Applications/Communications
Requires: netdude = 0.4.8 libnetdude-devel >= 0.10

%description devel
Header files required for Netdude plugin development.

%prep
%setup -q
# Needed for snapshot releases.
if [ ! -f configure ]; then
  CFLAGS="$RPM_OPT_FLAGS" ./autogen.sh --prefix=%prefix
else
  CFLAGS="$RPM_OPT_FLAGS" ./configure --prefix=%prefix
fi

%build
if [ "$SMP" != "" ]; then
  (make "MAKE=make -k -j $SMP"; exit 0)
  make
else
  make
fi

%install
rm -rf $RPM_BUILD_ROOT
make prefix=$RPM_BUILD_ROOT%{prefix} install

%clean
rm -rf $RPM_BUILD_ROOT

%post -p /sbin/ldconfig

%postun -p /sbin/ldconfig

%files
%defattr(-,root,root,-)
%doc AUTHORS COPYING ChangeLog NEWS README TODO
%doc %{prefix}/share/gtk-doc/html/netdude
%{prefix}/bin/netdude
%{prefix}/bin/netdude%{versionmaj}
%{prefix}/share/netdude/%{versionmaj}
%{prefix}/man/man1/*

%files devel
%defattr(-,root,root,-)
%{prefix}/include/netdude/%{versionmaj}

%changelog
* Tue Dec  9 2003 Christian Kreibich <christian@whoop.org> 
- Added spec file to tree, including a sucky workaround for
  an automake bug.
