#define aioClientData_t	int
#include "anbio.h"

#include <sys/types.h>	/* socket */
#include <sys/socket.h>	/* socket */
#include <netinet/in.h>	/* sockaddr_in, [nh]to[hn][sl] */
#include <unistd.h>	/* read, write */
#include <errno.h>	/* errno */
#include <string.h>	/* strerror */
#include <stdio.h>	/* printf */

#define error(who)	perror(who)

static void *dataHandler(int fd, int mask, aioClientData_t data)
{
  fprintf(stderr, "handling: data %d %d %s\n", fd, mask, maskString(mask));
  if (mask & AIO_RD)
    {
      fprintf(stderr, "%d read possible\n", fd);
      {
	char buf[4096];
	int n= read(fd, (void *)buf, sizeof(buf));
	if (n < 0) error("read");
	if (n == 0)
	  {
	    fprintf(stderr, "%d EOF detected\n", fd);
	  }
	else
	  {
	    char *ptr= buf;
	    fprintf(stderr, "%d received: ", fd);
	    while (n--)
	      putchar(*ptr++);
	  }
      }
    }
  if (mask & AIO_WR)
    {
      fprintf(stderr, "%d write possible\n", fd);
    }
  if (mask & AIO_EX)
    {
      fprintf(stderr, "%d exception\n", fd);
      {
	int optval= 0;
	socklen_t optlen= sizeof(optval);
	if (getsockopt(fd, SOL_SOCKET, SO_ERROR, &optval, &optlen))
	  error("getsockopt");
	if (optlen != 4)
	  fprintf(stderr, "getsockopt: optlen is not 4!\n");
	fprintf(stderr, "exception condition: %s\n", strerror(optval));
      }
    }
  return (void *)dataHandler;
}

static void *connectHandler(int fd, int mask, aioClientData_t data)
{
  int optval= 0;
  socklen_t optlen= sizeof(optval);
  fprintf(stderr, "handling: connect %d %s\n", fd, maskString(mask));
  if (getsockopt(fd, SOL_SOCKET, SO_ERROR, &optval, &optlen))
    error("getsockopt");
  if (optlen != 4)
    fprintf(stderr, "getsockopt: optlen is not 4!\n");
  if (optval != 0)
    fprintf(stderr, "handled connect: %s\n", strerror(optval));
  fprintf(stderr, "%d connected\n", fd);
  {
    char buf[]= "SOCKET 2 ME DUDE!\n";
    fprintf(stderr, "%d sending: %s", fd, buf);
    write(fd, (void *)buf, strlen(buf));
  }
  return (void *)dataHandler;
}

static void *acceptHandler(int fd, int mask, aioClientData_t data)
{
  int conn= 0;
  struct sockaddr_in saddr;
  int len= sizeof(saddr);
  fprintf(stderr, "handling: accept %d %s\n", fd, maskString(mask));
  conn= accept(fd, &saddr, &len);
  if (conn < 0) error("accept");
  fprintf(stderr, "%d accepted\n", conn); 
  nbioEnable(conn);
  aioHandle(conn, dataHandler);
  aioEnable(conn, 1);
  return (void *)acceptHandler;
}

static void bindSocket(int s, unsigned int host, int port)
{
  struct sockaddr_in saddr;

  memset(&saddr, 0, sizeof(saddr));
  saddr.sin_family= AF_INET;
  saddr.sin_port= htons((short)port);
  saddr.sin_addr.s_addr= host;

  if (bind(s, (struct sockaddr*) &saddr, sizeof(saddr))) error("bind");
}

static int listenOn(int port)
{
  int s= socket(AF_INET, SOCK_STREAM, 0);
  int one= 1;
  if (s < 0) error("socket");
  if (setsockopt(s, SOL_SOCKET, SO_REUSEADDR, (char *)&one, sizeof(one)))
    error("setsockopt");
  bindSocket(s, INADDR_ANY, port);
  nbioEnable(s);
  aioHandle(s, acceptHandler);
  aioEnable(s, 1);
  fprintf(stderr, "%d listening\n", s);
  if (listen(s, 5)) error("listen");
  return s;
}

static int connectTo(unsigned int host, int port)
{
  struct sockaddr_in saddr;
  int one= 1;
  int s= socket(AF_INET, SOCK_STREAM, 0);

  if (s < 0) error("socket");
  if (setsockopt(s, SOL_SOCKET, SO_REUSEADDR, (char *)&one, sizeof(one)))
    error("setsockopt");

  memset(&saddr, 0, sizeof(saddr));
  saddr.sin_family= AF_INET;
  saddr.sin_port= htons((short)port);
  saddr.sin_addr.s_addr= host;

  fprintf(stderr, "%d connecting\n", s);
  nbioEnable(s);
  aioHandle(s, connectHandler);
  aioEnable(s, 1);
  {
    int err= 0;
    do
      {
	err= connect(s, (struct sockaddr*) &saddr, sizeof(saddr));
      }
    while ((err < 0) && (errno == EINTR));
    if (err < 0) error("connect");
  }
  return s;
}

int main()
{
  aioInit();
  {
    int l= listenOn(4321);
    int c= connectTo(INADDR_LOOPBACK, 4321);
    sleep(1);
    aioDisable(c);
    close(c);
    sleep(1);
    aioDisable(l);
    close(l);
  }
  aioFini();

  return 0;
}
