/* Automatically generated from Squeak on #(23 July 2001 3:02:26 pm) */

#include <math.h>
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <time.h>

/* Default EXPORT macro that does nothing (see comment in sq.h): */
#define EXPORT(returnType) returnType

/* Do not include the entire sq.h file but just those parts needed. */
/*  The virtual machine proxy definition */
#include "sqVirtualMachine.h"
/* Configuration options */
#include "sqConfig.h"
/* Platform specific definitions */
#include "sqPlatformSpecific.h"

#define true 1
#define false 0
#define null 0  /* using 'null' because nil is predefined in Think C */
#include "SecurityPlugin.h"

/* memory access macros */
#define byteAt(i) (*((unsigned char *) (i)))
#define byteAtput(i, val) (*((unsigned char *) (i)) = val)
#define longAt(i) (*((int *) (i)))
#define longAtput(i, val) (*((int *) (i)) = val)

/*** Variables ***/
static struct VirtualMachine* interpreterProxy;
static const char *moduleName = "SecurityPlugin 23 July 2001 (i)";

/*** Function Prototypes ***/
#pragma export on
EXPORT(const char*) SecurityPlugin_getModuleName(void);
EXPORT(int) SecurityPlugin_primitiveCanWriteImage(void);
EXPORT(int) SecurityPlugin_primitiveDisableImageWrite(void);
EXPORT(int) SecurityPlugin_primitiveGetSecureUserDirectory(void);
EXPORT(int) SecurityPlugin_primitiveGetUntrustedUserDirectory(void);
EXPORT(int) SecurityPlugin_setInterpreter(struct VirtualMachine* anInterpreter);
#pragma export off


/*	Note: This is hardcoded so it can be run from Squeak.
	The module name is used for validating a module *after*
	it is loaded to check if it does really contain the module
	we're thinking it contains. This is important! */

EXPORT(const char*) SecurityPlugin_getModuleName(void) {
	return moduleName;
}

EXPORT(int) SecurityPlugin_primitiveCanWriteImage(void) {
	interpreterProxy->pop(1);
	interpreterProxy->pushBool(ioCanWriteImage());
}

EXPORT(int) SecurityPlugin_primitiveDisableImageWrite(void) {
	ioDisableImageWrite();
	if (!(interpreterProxy->failed())) {
		interpreterProxy->pop(1);
	}
}


/*	Primitive. Return the secure directory for the current user. */

EXPORT(int) SecurityPlugin_primitiveGetSecureUserDirectory(void) {
    char * dirName;
    int dirLen;
    char * dirPtr;
    int i;
    int dirOop;

	dirName = ioGetSecureUserDirectory();
	if ((dirName == null) || (interpreterProxy->failed())) {
		return interpreterProxy->primitiveFail();
	}
	dirLen = strlen(dirName);
	dirOop = interpreterProxy->instantiateClassindexableSize(interpreterProxy->classString(), dirLen);
	if (interpreterProxy->failed()) {
		return null;
	}
	dirPtr = interpreterProxy->firstIndexableField(dirOop);
	for (i = 0; i <= (dirLen - 1); i += 1) {
		dirPtr[i] = (dirName[i]);
	}
	interpreterProxy->pop(1);
	interpreterProxy->push(dirOop);
}


/*	Primitive. Return the untrusted user directory name. */

EXPORT(int) SecurityPlugin_primitiveGetUntrustedUserDirectory(void) {
    char * dirName;
    int dirLen;
    char * dirPtr;
    int i;
    int dirOop;

	dirName = ioGetUntrustedUserDirectory();
	if ((dirName == null) || (interpreterProxy->failed())) {
		return interpreterProxy->primitiveFail();
	}
	dirLen = strlen(dirName);
	dirOop = interpreterProxy->instantiateClassindexableSize(interpreterProxy->classString(), dirLen);
	if (interpreterProxy->failed()) {
		return null;
	}
	dirPtr = interpreterProxy->firstIndexableField(dirOop);
	for (i = 0; i <= (dirLen - 1); i += 1) {
		dirPtr[i] = (dirName[i]);
	}
	interpreterProxy->pop(1);
	interpreterProxy->push(dirOop);
}


/*	Note: This is coded so that is can be run from Squeak. */

EXPORT(int) SecurityPlugin_setInterpreter(struct VirtualMachine* anInterpreter) {
    int ok;

	interpreterProxy = anInterpreter;
	ok = interpreterProxy->majorVersion() == VM_PROXY_MAJOR;
	if (ok == 0) {
		return 0;
	}
	ok = interpreterProxy->minorVersion() >= VM_PROXY_MINOR;
	return ok;
}
