.TH x2vnc 1
.SH NAME
x2vnc \- a dual-screen hack

.SH SYNOPSIS
.B x2vnc
.I <options>
.I host:0
.br
[
.B \-display
.I display
]
.br
[
.B -version
]
.br
[
.B -shared
]
.br
[
.B -north
] [
.B -south
] [
.B -east
] [
.B -west
]
.br
[
.B -hotkey
.I key
]
.br
[
.B -passwdfile
.I passwd-file
]
.br
[
.B -resurface
]
.br
[
.B -edgewidth
.I width
]
.br
[
.B -desktop
.I desktop-number
]
.br
[
.B -timeout
.I seconds
]
.br
[
.B -nowheel
]
.br
[
.B -reversewheel
]
.br
[
.B -scrolllines
.I lines
]
.br
[
.B -mac
]
.br
[
.B -trimsel
]
.SH DESCRIPTION
.I x2vnc
will let you use two screens on two different computers as if they were
connected to the same computer. The computer with the 'main' keboard must
be running X-window, and the second computer should have a VNC server
running which will update the contents on the actual screen. This means
\fIXvnc\fR is not suitable, but \fIWinVNC\fR is.

For up-to-date information on x2vnc, see the x2vnc home page:
.B http://fredrik.hubbe.net/x2vnc.html

.TP
\fB\-display\fR \fIdisplay\fR
The X windows display to connect from.
.TP
\fB\-shared\fR
Allow multiple connections to the same VNC server.
.TP
\fB\-north\fR, \fB\-south\fR, \fB\-east\fR, \fB\-west\fR,
Determine which edge leads to the other screen. 
.TP
\fB\-passwdfile\fR \fIpassword-file\fR
With this option you can start x2vnc without entering a password. The file is
created by \fBvncpasswd\fR which comes with the X-windows VNC software. 
If the file does not exist, \fIx2vnc\fR will ask for a password and
create the file.
.TP
\fB\-resurface\fR
This option will cause the trigger window to re-surface automatically if it is
covered up by another window. 
.TP
\fB\-hotkey\fR \fIkey\fR
This option allows you to select which key to use to warp the pointer
to and from second computer. The default is "Control-F12", any
combination of modifiers can be used, such as "shift-alt-meta-ctrl-F1"
(or s-a-m-c-F1).
.TP
\fB\-edgewidth\fR \fIpixels\fR
This is a workaround for some X servers which do not allow the mouse to
go all the way to the edge of the screen. By setting this to 2 or greater, the
mouse will be able to reach the x2vnc window and thus warp to the
windows machine. The default value is 1.
.TP
\fB\-desktop\fR \fIdesktop-number\fR
With this option, you can make x2vnc non-sticky. This may not work
with all window-managers. Note that the first desktop is usually
0 (zero). If you want x2vnc to appear on the last (rightmost) desktop,
use -1.  This option was especially created with the sawfish edgeflipping
in mind, normally you would use "-west -desktop 0" or "-east -destkop -1"
with Sawfish to allow edgeflipping to work normally.
.TP
\fB\-timeout\fR \fIseconds\fR
This options tells x2vnc how long to wait before warping the cursor back
to the X screen if there is no activity. The reason for this is that
some screen savers, such as xscreensaver, cannot activate while x2vnc is
in control of the cursor. The default value is 590 seconds, which is
equivialent to 9 minutes and 50 seconds. Using a value of 0 will disable
timeouts completely.
.TP
\fB\-nowheel\fR
Disable mouse wheel emulation. Without this option your wheel will work
like arrow up/down, with this option x2vnc will send them as mouse-button
4/5.
.TP
\fB\-reversewheel\fR
Invert the up/down direction of the mouse wheel emulation.
.TP
\fB\-scrolllines\fR \fIlines\fR
When using mouse wheel emulation, this selects how many up/down
events will be sent for each tick of the mouse wheel.
.TP
\fB\-mac\fR
Macintosh specific mode, maps second mouse button to control-mouseclick.
.TP
\fB\-trimsel\fR
If the X selection looks like a URL, trim leading and trailing spaces.
This can be useful for pasting URLs into a browser.

.SH EXAMPLES
Most common usage:
.br
\fBx2vnc -passwd $HOME/.vncpasswd -resurface host:0\fR

To make x2vnc start (and re-start) automatically, add the following to
your your X startup file (usually .xinitrc):
.br
\fB
while :;
.br
do
  x2vnc -passwd $HOME/.vncpasswd -resurface host:0
.br
  sleep 2
.br
done
\fR

.SH AUTHOR
Fredrik Hbinette, hubbe@hubbe.net
