<?php
/**
 * $Horde: horde/lib/Group.php,v 1.6.2.3 2002/01/02 17:05:39 jan Exp $
 * Copyright 1999-2002 Original Author <shuther@bigfoot.com>
 * See the enclosed file COPYING for license information (LGPL).  If you 
 * did not receive this file, see http://www.fsf.org/copyleft/lgpl.html.
 */

/**
 * @todo
 * - It might be required to adapt Auth to check consistency between the
 *   users in the different classes.
 * - Add a security feature so that not everybody can add/remove users/groups
 */

/**
 * The Group:: class provides a common abstracted interface into the
 * various backends for the Horde authentication system / group manager.
 *
 * @author  Stephane Huther <shuther@bigfoot.com>
 * @author  Chuck Hagenbuch <chuck@horde.org>
 * @version $Revision: 1.6.2.3 $
 * @since   Horde 2.1
 * @package horde.group
 */
class Group {

    /**
     * Pointer to a category instance to manage the different groups.
     * @var object Category $groups
     */
    var $groups;

	/**
     * Constructor
     */
	function Group()
    {
		global $conf;
		$this->groups = &Category::singleton($conf['category']['driver'],
                                             array_merge($conf['category']['params'],
                                                         array('group' => 'horde.groups')));
	}

    /**
     * Attempts to return a reference to a concrete Group instance.
     * It will only create a new instance if no Group instance
     * currently exists.
     *
     * This method must be invoked as: $var = &Group::singleton()
     *
     * @return object Group  The concrete Group reference, or false on an
     *                       error.
     */
    function &singleton()
    {
        static $group;

        if (!isset($group)) {
            $group = new Group();
        }

        return $group;
    }

    /**
     * Add a group
     * 
     * note: there is no check against circular reference!!!
     * @param string $name       The name of the group.
     * @param optional string $parent	the name of the parent group
     */
    function addGroup($name, $parent = '-1')
    {
		return $this->groups->addCategory($name, $parent);
	}

    /**
     * Remove a group
     * 
     * @param string $name       The name of the group.
     * @param string $parent	the name of the parent group
     */
    function removeGroup($name, $parent)
    {
        if ($this->groups->getNumberChilds($name) != 0) {
            return new PEAR_Error('Cannot remove: children exist');
        }
        if ($this->users->getNumberChilds($name) != 0) {
            return new PEAR_Error('Cannot remove: children exist');
        }
        
        $ret = $this->groups->remove($name, $parent);
        if (!PEAR::isError($ret)) {
            $ret = $this->users->remove($name, '-1');
		}
		return $ret;
	}

    /**
     * Move a Group
     * 
     * note: there is no check against circular reference!!!
     * @param string $name       The name of the group.
     * @param string $new_parent The name of the new parent.
     */
    function moveGroup($name, $old_parent, $new_parent)
    {
		return $this->groups->move($name, $old_parent, $new_parent);
	}

    /**
     * Add a user in a group
     * 
     * note: there is no check against circular reference!!!
     * @param string $userId       The name of the user.
     * @param string $group	the name of the group
     */
    function addUserToGroup($userId, $group)
    {
		return $this->users->add($userId, $group);
	}

    /**
     * Remove a user from a group
     * 
     * @param string $userId The name of the user.
     * @param string $group	 The name of the group.
     */
    function removeUserFromGroup($userId, $group)
    {
		return $this->users->remove($userId, $group);
	}

    /**
     * Get a list of parents, based on a child
     * 
     * @param string $group The name of the child
     *
     * @return array 
     */
	function getGroupParents($group)
    {
		return $this->groups->getParents($group);
	}

    /**
     * Get a list of every users that are part of this group ONLY
     * 
     * @param string $group The name of the parent group
     * @parem optional string $filter name of a user that we only show null=no filter
     *
     * @return array 
     * @access private
     */
	function getListofUsers1($group, $filter = null)
    {
		$ret = $this->users->extract1Level($group);
		foreach ($ret as $group => $user) {
			$ret[$group] = array();

			foreach ($user as $user2 => $useless) {
                if (is_null($filter) || $user2 == $filter) {
                    $ret[$group][$user2] = true;
                }
			}
		}
        
		$a = array_values($ret);
		return $a[0];
	}

    /**
     * Get a complete list of every user that is part of the specified
     * group and any of its subgroups.
     * 
     * @param          string $group  The name of the parent group
     * @parem optional string $filter The name of a user that we only show null=no filter
     *
     * @return array 
     */
	function listUsers($group, $filter = null)
        {
		$arr = $this->groups->export(CATEGORY_FORMAT_FLIST, $group);

        // Get a list of every group
		$keyarry = array_keys($arr);
		$listusers = array();
		foreach ($keyarry as $val) {
			foreach($this->getListofUsers1($val, $filter) as $user => $useless) {
				array_push($listusers, $user);
			}
		}
		return $listusers;
	}

    /**
     * Say if a user is part of a group or not
     * 
     * @param string $user  The name of the user
     * @param string $group The name of the parent group
     *
     * @return boolean
     */
	function isUserInGroup($user, $group)
    {
		$ret = $this->getListofUsers($group, $user);
		if (empty($ret)) {
			return false;
		} else {
			return true;
        }
	}
}

/**
 * Extension of the CategoryObject class for storing Group information
 * in the Categories driver.
 */
class CategoryObject_Group extends CategoryObject {

    /**
     * Key-value hash that will be serialized.
     * @see getData()
     */
    var $data = array();

    /**
     * Get a pointer/accessor to the array that we will save
     * needed because PHP is not an object language
     * @return array reference to the internal array to serialize
     */
    function &getData()
    {
        return $this->data;
    }

    /**
     * Merge the data of an array with the one already in the class
     * @param array $arr
     */
    function mergeData(&$arr)
    {
        $this->data = array_merge_recursive($this->getData(), $arr);
    }

}
?>
