/* 
 * PrefController+InterfaceCreation.m created by probert on 2003-06-29 17:32:04 +0000
 *
 * Project ImageViewer
 *
 * Created with ProjectCenter - http://www.gnustep.org
 *
 * $Id: PrefController+InterfaceCreation.m,v 1.1 2003/06/29 17:48:09 probert Exp $
 */

#include "PrefController+InterfaceCreation.h"

@implementation PrefController (InterfaceCreation)

- (void)_createUI
{
    unsigned int style = NSTitledWindowMask | NSClosableWindowMask;
    NSRect winFrame = NSMakeRect(200,300,260,280);
    NSRect rect;
    NSTextField *textField, *reclabel;
    NSBox *box;
    NSMatrix *matrix;
    NSButton *button;
    NSButtonCell* buttonCell = [[NSButtonCell alloc] init];
    NSDictionary *prefs;

    prefs =[[NSUserDefaults standardUserDefaults] dictionaryRepresentation];
    prefDict = [[NSMutableDictionary alloc] initWithDictionary:prefs];

    preferences = [[NSWindow alloc] initWithContentRect:winFrame
                        styleMask:style
                          backing:NSBackingStoreBuffered
                            defer:YES];
    [preferences setMinSize:NSMakeSize(260,280)];
    [preferences setTitle:_(@"Preferences")];
    [preferences setDelegate:self];
    [preferences setReleasedWhenClosed:NO];
    [preferences center];
    [preferences setFrameAutosaveName:_(@"Preferences")];

    box = [[NSBox alloc] init];
	[box setTitle:_(@"Image Cache")];
	[box setFrameFromContentFrame:NSMakeRect(16,180,228,64)];
	[[preferences contentView] addSubview:box];
	RELEASE(box);

    textField = [[NSTextField alloc] initWithFrame:NSMakeRect(8,16,80,21)];
    [textField setAlignment: NSRightTextAlignment];
    [textField setBordered: NO];
    [textField setEditable: NO];
    [textField setBezeled: NO];
    [textField setDrawsBackground: NO];
    [textField setStringValue:_(@"Cache size:")];
    [box addSubview:textField];
    RELEASE(textField);

    rect = NSMakeRect(92,16,124,21);
    cacheSizeField = [[NSTextField alloc] initWithFrame:rect];
    //[cacheSizeField setAlignment: NSRightTextAlignment];
    //[cacheSizeField setBordered: NO];
    [cacheSizeField setEditable: YES];
    [cacheSizeField setBezeled: YES];
    [cacheSizeField setDrawsBackground: YES];
    [cacheSizeField setStringValue : @""];

    [cacheSizeField setTarget:self];
    [cacheSizeField setAction:@selector(setCacheSize:)];
    [box addSubview:cacheSizeField];
    RELEASE(cacheSizeField);

    rect = NSMakeRect(12,144,24,15);
    openRecursive =[[NSButton alloc] initWithFrame:rect];
    [openRecursive setTitle:_(@"")];
    [openRecursive setButtonType:NSSwitchButton];
    [openRecursive setBordered:NO];
    [openRecursive setTarget:self];
    [openRecursive setAction:@selector(setOpenRecursive:)];
    [openRecursive setContinuous:NO];
    [openRecursive sizeToFit];
    [[preferences contentView] addSubview:openRecursive];
    RELEASE(openRecursive);

    reclabel = [[NSTextField alloc] initWithFrame: NSMakeRect(32,144,224,15)];
    [reclabel setEditable: NO];
    [reclabel setBezeled: NO];
    [reclabel setDrawsBackground: NO];
    [reclabel setStringValue :  _(@"Open path recursively")];
    [[preferences contentView] addSubview: reclabel];

    rect = NSMakeRect(100,8,150,24);
    matrix = [[NSMatrix alloc] initWithFrame: rect
                                        mode: NSHighlightModeMatrix
                                   prototype: buttonCell
                                numberOfRows: 1
                             numberOfColumns: 2];
    [matrix setSelectionByRect:YES];
    [matrix setAutoresizingMask: (NSViewMinXMargin | NSViewMaxYMargin)];
    [matrix setTarget:self];
    [matrix setAction:@selector(buttonsPressed:)];
    [matrix setIntercellSpacing: NSMakeSize(2,2)];
    [[preferences contentView] addSubview:matrix];
    RELEASE(matrix);
    RELEASE(buttonCell);

    button = [matrix cellAtRow:0 column:0];
    [button setTag:0];
    [button setStringValue:_(@"Reset")];
    [button setBordered:YES];
    [button setButtonType:NSMomentaryPushButton];

    button = [matrix cellAtRow:0 column:1];
    [button setTag:1];
    [button setStringValue:_(@"Set")];
    [button setBordered:YES];
    [button setButtonType:NSMomentaryPushButton];
}

@end
